/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.nio.file.Path;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.config.QuestoryConfig;

public class QuestoryConfigScreen
extends class_437 {
    private final class_437 parent;
    private ConfigTab currentTab = ConfigTab.HUD;
    private class_4185 hudTabButton;
    private class_4185 notificationsTabButton;
    private class_4185 displayTabButton;
    private class_4185 generalTabButton;
    private String hudPosition;
    private float hudScale;
    private int hudOpacity;
    private boolean hudCompactMode;
    private boolean hudShowIcons;
    private boolean hudShowProgressBars;
    private int hudOffsetX;
    private int hudOffsetY;
    private boolean enableNotifications;
    private boolean enableSounds;
    private boolean enableTitles;
    private boolean enableChatMessages;
    private boolean notifyOnUnlock;
    private boolean notifyOnReady;
    private boolean notifyOnComplete;
    private boolean showProgressPercentage;
    private boolean useColoredMessages;
    private boolean showQuestIDInList;
    private boolean mapIntegrationEnabled;
    private boolean journeyMapEnabled;
    private boolean clientEnableAdvancedEditor;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_4185 resetButton;
    private boolean draggingHud = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int originalOffsetX = 0;
    private int originalOffsetY = 0;

    public QuestoryConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Questify Configuration"));
        this.parent = parent;
        this.loadConfig();
    }

    private void loadConfig() {
        this.hudPosition = ClientConfig.getHudPosition();
        this.hudScale = ClientConfig.getHudScale();
        this.hudOpacity = ClientConfig.getHudOpacity();
        this.hudCompactMode = ClientConfig.isHudCompactMode();
        this.hudShowIcons = ClientConfig.isHudShowIcons();
        this.hudShowProgressBars = ClientConfig.isHudShowProgressBars();
        this.hudOffsetX = ClientConfig.getHudOffsetX();
        this.hudOffsetY = ClientConfig.getHudOffsetY();
        QuestoryConfig config = QuestoryConfig.getInstance();
        this.enableNotifications = config.enableQuestNotifications;
        this.enableSounds = config.enableQuestSounds;
        this.enableTitles = config.enableQuestTitles;
        this.enableChatMessages = config.enableQuestChatMessages;
        this.notifyOnUnlock = config.notifyOnQuestUnlock;
        this.notifyOnReady = config.notifyOnQuestReady;
        this.notifyOnComplete = config.notifyOnQuestComplete;
        this.showProgressPercentage = config.showProgressPercentage;
        this.useColoredMessages = config.useColoredMessages;
        this.showQuestIDInList = config.showQuestIDInList;
        this.mapIntegrationEnabled = ClientConfig.isMapIntegrationEnabled();
        this.journeyMapEnabled = ClientConfig.isJourneyMapEnabled();
        this.clientEnableAdvancedEditor = ClientConfig.isClientEnableAdvancedEditor();
    }

    protected void method_25426() {
        super.method_25426();
        int tabWidth = 100;
        int tabHeight = 20;
        int tabY = 10;
        int tabSpacing = 5;
        int totalTabWidth = tabWidth * 4 + tabSpacing * 3;
        int startX = (this.field_22789 - totalTabWidth) / 2;
        this.hudTabButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)ConfigTab.HUD.label), b -> {
            if (this.currentTab != ConfigTab.HUD) {
                this.switchTab(ConfigTab.HUD);
            }
        }).method_46434(startX, tabY, tabWidth, tabHeight).method_46431());
        this.notificationsTabButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)ConfigTab.NOTIFICATIONS.label), b -> {
            if (this.currentTab != ConfigTab.NOTIFICATIONS) {
                this.switchTab(ConfigTab.NOTIFICATIONS);
            }
        }).method_46434(startX + tabWidth + tabSpacing, tabY, tabWidth, tabHeight).method_46431());
        this.displayTabButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)ConfigTab.DISPLAY.label), b -> {
            if (this.currentTab != ConfigTab.DISPLAY) {
                this.switchTab(ConfigTab.DISPLAY);
            }
        }).method_46434(startX + (tabWidth + tabSpacing) * 2, tabY, tabWidth, tabHeight).method_46431());
        this.generalTabButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)ConfigTab.GENERAL.label), b -> {
            if (this.currentTab != ConfigTab.GENERAL) {
                this.switchTab(ConfigTab.GENERAL);
            }
        }).method_46434(startX + (tabWidth + tabSpacing) * 3, tabY, tabWidth, tabHeight).method_46431());
        int bottomY = this.field_22790 - 30;
        int bottomButtonWidth = 70;
        int centerX = this.field_22789 / 2;
        this.resetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> this.resetCurrentTab()).method_46434(centerX - bottomButtonWidth * 2 - 10, bottomY, bottomButtonWidth, 20).method_46431());
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.saveAllConfig();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX - bottomButtonWidth / 2, bottomY, bottomButtonWidth, 20).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + bottomButtonWidth + 10, bottomY, bottomButtonWidth, 20).method_46431());
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.initHudTab();
                break;
            }
            case 1: {
                this.initNotificationsTab();
                break;
            }
            case 2: {
                this.initDisplayTab();
                break;
            }
            case 3: {
                this.initGeneralTab();
            }
        }
    }

    private void switchTab(ConfigTab tab) {
        this.currentTab = tab;
        this.method_37067();
        this.method_25426();
    }

    private void initHudTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 25;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Position: " + this.hudPosition)), b -> {
            this.hudPosition = switch (this.hudPosition) {
                case "TOP_LEFT" -> "TOP_RIGHT";
                case "TOP_RIGHT" -> "BOTTOM_RIGHT";
                case "BOTTOM_RIGHT" -> "BOTTOM_LEFT";
                default -> "TOP_LEFT";
            };
            b.method_25355((class_2561)class_2561.method_43470((String)("Position: " + this.hudPosition)));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        int scaleY = startY + spacing;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.hudScale = Math.max(0.5f, this.hudScale - 0.1f);
        }).method_46434(centerX - 60, scaleY, 20, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.hudScale = Math.min(2.0f, this.hudScale + 0.1f);
        }).method_46434(centerX + 40, scaleY, 20, buttonHeight).method_46431());
        int opacityY = startY + spacing * 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.hudOpacity = Math.max(0, this.hudOpacity - 10);
        }).method_46434(centerX - 60, opacityY, 20, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.hudOpacity = Math.min(100, this.hudOpacity + 10);
        }).method_46434(centerX + 40, opacityY, 20, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))), b -> {
            this.hudCompactMode = !this.hudCompactMode;
            b.method_25355((class_2561)class_2561.method_43470((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))), b -> {
            this.hudShowIcons = !this.hudShowIcons;
            b.method_25355((class_2561)class_2561.method_43470((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))), b -> {
            this.hudShowProgressBars = !this.hudShowProgressBars;
            b.method_25355((class_2561)class_2561.method_43470((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
    }

    private void initNotificationsTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))), b -> {
            this.enableNotifications = !this.enableNotifications;
            b.method_25355((class_2561)class_2561.method_43470((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))), b -> {
            this.enableSounds = !this.enableSounds;
            b.method_25355((class_2561)class_2561.method_43470((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))), b -> {
            this.enableTitles = !this.enableTitles;
            b.method_25355((class_2561)class_2561.method_43470((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))), b -> {
            this.enableChatMessages = !this.enableChatMessages;
            b.method_25355((class_2561)class_2561.method_43470((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))), b -> {
            this.notifyOnUnlock = !this.notifyOnUnlock;
            b.method_25355((class_2561)class_2561.method_43470((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))), b -> {
            this.notifyOnReady = !this.notifyOnReady;
            b.method_25355((class_2561)class_2561.method_43470((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))), b -> {
            this.notifyOnComplete = !this.notifyOnComplete;
            b.method_25355((class_2561)class_2561.method_43470((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).method_46431());
    }

    private void initDisplayTab() {
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))), b -> {
            this.showProgressPercentage = !this.showProgressPercentage;
            b.method_25355((class_2561)class_2561.method_43470((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))), b -> {
            this.useColoredMessages = !this.useColoredMessages;
            b.method_25355((class_2561)class_2561.method_43470((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))), b -> {
            this.showQuestIDInList = !this.showQuestIDInList;
            b.method_25355((class_2561)class_2561.method_43470((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
    }

    private void initGeneralTab() {
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))), b -> {
            this.mapIntegrationEnabled = !this.mapIntegrationEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))), b -> {
            this.journeyMapEnabled = !this.journeyMapEnabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))), b -> {
            this.clientEnableAdvancedEditor = !this.clientEnableAdvancedEditor;
            b.method_25355((class_2561)class_2561.method_43470((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).method_46431());
    }

    private void resetCurrentTab() {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.hudPosition = "TOP_LEFT";
                this.hudScale = 1.0f;
                this.hudOpacity = 80;
                this.hudCompactMode = false;
                this.hudShowIcons = true;
                this.hudShowProgressBars = true;
                this.hudOffsetX = 10;
                this.hudOffsetY = 10;
                break;
            }
            case 1: {
                this.enableNotifications = true;
                this.enableSounds = true;
                this.enableTitles = true;
                this.enableChatMessages = true;
                this.notifyOnUnlock = true;
                this.notifyOnReady = true;
                this.notifyOnComplete = true;
                break;
            }
            case 2: {
                this.showProgressPercentage = true;
                this.useColoredMessages = true;
                this.showQuestIDInList = false;
                break;
            }
            case 3: {
                this.mapIntegrationEnabled = true;
                this.journeyMapEnabled = true;
                this.clientEnableAdvancedEditor = true;
            }
        }
        this.method_37067();
        this.method_25426();
    }

    private void saveAllConfig() {
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestoryConfig config = QuestoryConfig.getInstance();
        config.enableQuestNotifications = this.enableNotifications;
        config.enableQuestSounds = this.enableSounds;
        config.enableQuestTitles = this.enableTitles;
        config.enableQuestChatMessages = this.enableChatMessages;
        config.notifyOnQuestUnlock = this.notifyOnUnlock;
        config.notifyOnQuestReady = this.notifyOnReady;
        config.notifyOnQuestComplete = this.notifyOnComplete;
        config.showProgressPercentage = this.showProgressPercentage;
        config.useColoredMessages = this.useColoredMessages;
        config.showQuestIDInList = this.showQuestIDInList;
        ClientConfig.setMapIntegrationEnabled(this.mapIntegrationEnabled);
        ClientConfig.setJourneyMapEnabled(this.journeyMapEnabled);
        ClientConfig.setClientEnableAdvancedEditor(this.clientEnableAdvancedEditor);
        try {
            Path configPath = this.field_22787.field_1697.toPath().resolve("config");
            QuestoryConfig.save(configPath);
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to save config: " + e.getMessage());
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        if (this.currentTab == ConfigTab.HUD) {
            this.renderHudTabContent(graphics, mouseX, mouseY, partialTick);
        } else if (this.currentTab == ConfigTab.GENERAL) {
            this.renderGeneralTabContent(graphics);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderHudTabContent(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.field_22789 / 2;
        String instruction = "Click and drag the HUD preview to reposition it";
        graphics.method_25300(this.field_22793, instruction, centerX, this.field_22790 - 50, 0xAAAAFF);
        String scaleText = String.format("Scale: %.1fx", Float.valueOf(this.hudScale));
        graphics.method_25300(this.field_22793, scaleText, centerX, 78, 0xFFFFFF);
        String opacityText = String.format("Opacity: %d%%", this.hudOpacity);
        graphics.method_25300(this.field_22793, opacityText, centerX, 103, 0xFFFFFF);
        this.renderHudPreview(graphics, partialTick);
    }

    private void renderGeneralTabContent(class_332 graphics) {
        int centerX = this.field_22789 / 2;
        int startY = 200;
        graphics.method_25300(this.field_22793, "Additional settings can be configured in:", centerX, startY, 0xCCCCCC);
        graphics.method_25300(this.field_22793, "config/questory-common.json", centerX, startY + 15, 0xFFAA00);
        graphics.method_25300(this.field_22793, "Use /quest reload to apply changes", centerX, startY + 35, 0x88FF88);
    }

    private void renderHudPreview(class_332 graphics, float partialTick) {
        String oldPos = ClientConfig.getHudPosition();
        float oldScale = ClientConfig.getHudScale();
        int oldOpacity = ClientConfig.getHudOpacity();
        boolean oldCompact = ClientConfig.isHudCompactMode();
        boolean oldIcons = ClientConfig.isHudShowIcons();
        boolean oldBars = ClientConfig.isHudShowProgressBars();
        int oldOffsetX = ClientConfig.getHudOffsetX();
        int oldOffsetY = ClientConfig.getHudOffsetY();
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestHudOverlay.render(graphics, partialTick);
        ClientConfig.setHudPosition(oldPos);
        ClientConfig.setHudScale(oldScale);
        ClientConfig.setHudOpacity(oldOpacity);
        ClientConfig.setHudCompactMode(oldCompact);
        ClientConfig.setHudShowIcons(oldIcons);
        ClientConfig.setHudShowProgressBars(oldBars);
        ClientConfig.setHudOffsetX(oldOffsetX);
        ClientConfig.setHudOffsetY(oldOffsetY);
        if (this.draggingHud) {
            this.drawDragIndicator(graphics);
        }
    }

    private void drawDragIndicator(class_332 graphics) {
        int hudX;
        int panelWidth = this.hudCompactMode ? 200 : 240;
        int panelHeight = 100;
        int hudY = switch (this.hudPosition) {
            case "TOP_RIGHT" -> {
                hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                yield this.hudOffsetY;
            }
            case "BOTTOM_LEFT" -> {
                hudX = this.hudOffsetX;
                yield this.field_22790 - panelHeight - this.hudOffsetY;
            }
            case "BOTTOM_RIGHT" -> {
                hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                yield this.field_22790 - panelHeight - this.hudOffsetY;
            }
            default -> {
                hudX = this.hudOffsetX;
                yield this.hudOffsetY;
            }
        };
        graphics.method_25294(hudX - 2, hudY - 2, hudX + panelWidth + 2, hudY, -2013200640);
        graphics.method_25294(hudX - 2, hudY + panelHeight, hudX + panelWidth + 2, hudY + panelHeight + 2, -2013200640);
        graphics.method_25294(hudX - 2, hudY, hudX, hudY + panelHeight, -2013200640);
        graphics.method_25294(hudX + panelWidth, hudY, hudX + panelWidth + 2, hudY + panelHeight, -2013200640);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.currentTab == ConfigTab.HUD && button == 0) {
            int hudX;
            int panelWidth = this.hudCompactMode ? 200 : 240;
            int panelHeight = 100;
            int hudY = switch (this.hudPosition) {
                case "TOP_RIGHT" -> {
                    hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                    yield this.hudOffsetY;
                }
                case "BOTTOM_LEFT" -> {
                    hudX = this.hudOffsetX;
                    yield this.field_22790 - panelHeight - this.hudOffsetY;
                }
                case "BOTTOM_RIGHT" -> {
                    hudX = this.field_22789 - panelWidth - this.hudOffsetX;
                    yield this.field_22790 - panelHeight - this.hudOffsetY;
                }
                default -> {
                    hudX = this.hudOffsetX;
                    yield this.hudOffsetY;
                }
            };
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + panelWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + panelHeight)) {
                this.draggingHud = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.originalOffsetX = this.hudOffsetX;
                this.originalOffsetY = this.hudOffsetY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingHud) {
            this.draggingHud = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingHud) {
            int deltaX = (int)(mouseX - (double)this.dragStartX);
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            this.hudOffsetX = this.hudPosition.contains("RIGHT") ? Math.max(0, Math.min(this.field_22789 / 2, this.originalOffsetX - deltaX)) : Math.max(0, Math.min(this.field_22789 / 2, this.originalOffsetX + deltaX));
            this.hudOffsetY = this.hudPosition.contains("BOTTOM") ? Math.max(0, Math.min(this.field_22790 / 2, this.originalOffsetY - deltaY)) : Math.max(0, Math.min(this.field_22790 / 2, this.originalOffsetY + deltaY));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static enum ConfigTab {
        HUD("HUD"),
        NOTIFICATIONS("Notifications"),
        DISPLAY("Display"),
        GENERAL("General");

        final String label;

        private ConfigTab(String label) {
            this.label = label;
        }
    }
}

