/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class ThemeIconRenderer {
    public static void draw(class_332 g, IconProperty iconProperty, int x, int y, int w, int h) {
        if (iconProperty == null) {
            return;
        }
        String path = iconProperty.getTexturePath();
        if ("builtin".equals(path)) {
            ThemeIconRenderer.drawBuiltin(g, iconProperty, x, y, w, h);
            return;
        }
        class_2960 loc = iconProperty.getResourceLocation();
        if (loc == null) {
            Integer tint = iconProperty.getColorModifier();
            if (tint != null) {
                g.method_25294(x, y, x + w, y + h, tint.intValue());
            }
            return;
        }
        Integer tint = iconProperty.getColorModifier();
        if (tint != null) {
            float a = (float)(tint >> 24 & 0xFF) / 255.0f;
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float gch = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
            g.method_25290(loc, x, y, 0.0f, 0.0f, w, h, w, h);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            g.method_25290(loc, x, y, 0.0f, 0.0f, w, h, w, h);
        }
    }

    private static void drawBuiltin(class_332 g, IconProperty prop, int x, int y, int w, int h) {
        int out = (Integer)ThemeProperties.SYMBOL_OUT.get();
        int in = (Integer)ThemeProperties.SYMBOL_IN.get();
        if (prop == ThemeProperties.CHECK_ICON) {
            int i;
            int thick = Math.max(2, Math.min(w, h) / 8);
            for (i = 0; i < thick; ++i) {
                g.method_51448().method_22903();
                g.method_25294(x + w / 8, y + h / 2 + i, x + w / 2, y + h - h / 8 + i, out);
                g.method_51448().method_22909();
            }
            for (i = 0; i < Math.max(1, thick - 1); ++i) {
                g.method_25294(x + w / 8, y + h / 2 + i, x + w / 2 - thick / 2, y + h - h / 8 + i, in);
            }
            for (i = 0; i < thick; ++i) {
                g.method_25294(x + w / 2 - i, y + h - h / 8 - i, x + w - w / 8, y + h / 4 - i, out);
            }
            for (i = 0; i < Math.max(1, thick - 1); ++i) {
                g.method_25294(x + w / 2, y + h - h / 8 - i, x + w - w / 8 - thick / 2, y + h / 4 - i, in);
            }
            return;
        }
        if (prop == ThemeProperties.CHECKMARK_TASK_ACTIVE) {
            int thick = Math.max(1, Math.min(w, h) / 7);
            int lx = x + w / 8;
            int ly = y + h / 2;
            int mx = x + w / 2;
            int my = y + h - h / 6;
            int rx = x + w - w / 8;
            int ry = y + h / 4;
            g.method_25294(lx, ly, mx, my, out);
            g.method_25294(lx + thick, ly + thick, mx, my, in);
            g.method_25294(mx - thick, my - thick, rx, ry, out);
            g.method_25294(mx, my - thick / 2, rx - thick, ry + thick / 2, in);
            return;
        }
        if (prop == ThemeProperties.CHECKMARK_TASK_INACTIVE) {
            int thick = Math.max(1, Math.min(w, h) / 10);
            int cx = x + w / 2;
            int cy = y + h / 2;
            int r = Math.max(3, Math.min(w, h) / 3);
            g.method_25294(cx - r, cy - r, cx + r, cy - r + thick, out);
            g.method_25294(cx - r, cy + r - thick, cx + r, cy + r, out);
            g.method_25294(cx - r, cy - r, cx - r + thick, cy + r, out);
            g.method_25294(cx + r - thick, cy - r, cx + r, cy + r, out);
            return;
        }
        if (prop == ThemeProperties.LOCK_ICON) {
            int thick = Math.max(2, Math.min(w, h) / 10);
            int bodyH = (int)((double)h * 0.55);
            int shackleH = h - bodyH;
            g.method_25294(x + thick, y + shackleH, x + w - thick, y + h - thick, out);
            g.method_25294(x + thick * 2, y + shackleH + thick, x + w - thick * 2, y + h - thick * 2, in);
            int sx = x + w / 4;
            int ex = x + w - w / 4;
            int sy = y + thick;
            int ey = y + shackleH;
            g.method_25294(sx, sy, sx + thick, ey, out);
            g.method_25294(ex - thick, sy, ex, ey, out);
            g.method_25294(sx + thick, sy, ex - thick, sy + thick, out);
            return;
        }
        if (prop == ThemeProperties.HIDDEN_ICON) {
            int cx = x + w / 2;
            int cy = y + h / 2;
            int rx = Math.max(4, w / 3);
            int ry = Math.max(3, h / 3);
            g.method_25294(cx - rx, cy - ry / 2, cx + rx, cy + ry / 2, out);
            g.method_25294(cx - rx + 2, cy - ry / 3, cx + rx - 2, cy + ry / 3, in);
            int pr = Math.max(2, Math.min(w, h) / 8);
            g.method_25294(cx - pr, cy - pr, cx + pr, cy + pr, out);
            int thick = Math.max(2, Math.min(w, h) / 10);
            g.method_25294(x, y + h - thick, x + thick, y + h, out);
            g.method_25294(x + thick, y + h - 2 * thick, x + 2 * thick, y + h - thick, out);
            g.method_25294(x + 2 * thick, y + h - 3 * thick, x + 3 * thick, y + h - 2 * thick, out);
            return;
        }
        int thick = Math.max(1, Math.min(w, h) / 12);
        int c = out;
        g.method_25294(x, y, x + w, y + thick, c);
        g.method_25294(x, y + h - thick, x + w, y + h, c);
        g.method_25294(x, y, x + thick, y + h, c);
        g.method_25294(x + w - thick, y, x + w, y + h, c);
    }
}

