/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.texboobcat.questory.config.ConfigBackupManager;
import org.texboobcat.questory.config.ConfigVersion;

public class ConfigMigrator {
    private static final Map<String, Function<JsonObject, JsonObject>> MIGRATIONS = new LinkedHashMap<String, Function<JsonObject, JsonObject>>();

    private static void registerMigrations() {
        MIGRATIONS.put("1.0.0->1.1.0", ConfigMigrator::migrate_1_0_0_to_1_1_0);
        MIGRATIONS.put("1.1.0->1.2.0", ConfigMigrator::migrate_1_1_0_to_1_2_0);
    }

    public static boolean migrate(Path configPath, String configFileName, ConfigVersion targetVersion) {
        Path configFile = configPath.resolve(configFileName);
        if (!Files.exists(configFile, new LinkOption[0])) {
            System.out.println("[Questory] No config file to migrate");
            return true;
        }
        try {
            String content = Files.readString(configFile);
            content = ConfigMigrator.removeComments(content);
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            String versionStr = json.has("configVersion") ? json.get("configVersion").getAsString() : "1.0.0";
            ConfigVersion currentVersion = ConfigVersion.fromString(versionStr);
            System.out.println("[Questory] Config version: " + String.valueOf(currentVersion) + " | Target version: " + String.valueOf(targetVersion));
            if (currentVersion.equals(targetVersion)) {
                System.out.println("[Questory] Config is already at target version");
                return true;
            }
            if (currentVersion.isNewerThan(targetVersion)) {
                System.err.println("[Questory] Config version is newer than target version! This may indicate a downgrade or mod version mismatch.");
                return false;
            }
            ConfigBackupManager backupManager = new ConfigBackupManager(configPath);
            backupManager.createBackup(configFile, "migration-" + String.valueOf(currentVersion) + "-to-" + String.valueOf(targetVersion));
            JsonObject migratedJson = ConfigMigrator.applyMigrations(json, currentVersion, targetVersion);
            migratedJson.addProperty("configVersion", targetVersion.toString());
            return true;
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to migrate config: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static JsonObject applyMigrations(JsonObject json, ConfigVersion current, ConfigVersion target) {
        JsonObject result = json.deepCopy();
        ArrayList<String> migrationsToApply = new ArrayList<String>();
        if (current.isOlderThan(ConfigVersion.V1_1_0) && !target.isOlderThan(ConfigVersion.V1_1_0)) {
            migrationsToApply.add("1.0.0->1.1.0");
        }
        if (current.isOlderThan(ConfigVersion.V1_2_0) && !target.isOlderThan(ConfigVersion.V1_2_0)) {
            migrationsToApply.add("1.1.0->1.2.0");
        }
        for (String migrationKey : migrationsToApply) {
            Function<JsonObject, JsonObject> migration = MIGRATIONS.get(migrationKey);
            if (migration != null) {
                System.out.println("[Questory] Applying migration: " + migrationKey);
                result = migration.apply(result);
                continue;
            }
            System.err.println("[Questory] Missing migration function for: " + migrationKey);
        }
        return result;
    }

    private static JsonObject migrate_1_0_0_to_1_1_0(JsonObject config) {
        System.out.println("[Questory] Migrating config 1.0.0 -> 1.1.0: Adding daily quest settings");
        ConfigMigrator.addIfMissing(config, "dailyEnable", false);
        ConfigMigrator.addIfMissing(config, "dailyRemoteUrl", "");
        ConfigMigrator.addIfMissing(config, "dailyFetchOnWorldLoad", true);
        ConfigMigrator.addIfMissing(config, "dailyFetchIntervalMinutes", 0);
        ConfigMigrator.addIfMissing(config, "dailyCacheTtlMinutes", 1440);
        ConfigMigrator.addIfMissing(config, "dailyOfflineFallback", "use_cache");
        ConfigMigrator.addIfMissing(config, "dailyRolloverHour", 0);
        ConfigMigrator.addIfMissing(config, "dailyTimeZone", "UTC");
        ConfigMigrator.addIfMissing(config, "dailyGroupName", "Daily");
        ConfigMigrator.addIfMissing(config, "dailyTagKey", "daily");
        ConfigMigrator.addIfMissing(config, "dailyPrefixQuestIds", "daily_");
        ConfigMigrator.addIfMissing(config, "dailyMaxActiveQuests", 0);
        ConfigMigrator.addIfMissing(config, "dailyCompletionMode", "ALL");
        ConfigMigrator.addIfMissing(config, "dailyMinQuestsToComplete", 0);
        ConfigMigrator.addIfMissing(config, "dailyStoreHistory", true);
        ConfigMigrator.addIfMissing(config, "dailyHttpTimeoutMs", 8000);
        ConfigMigrator.addIfMissing(config, "dailyRetryCount", 2);
        ConfigMigrator.addIfMissing(config, "dailyDataDirNameOverride", "");
        return config;
    }

    private static JsonObject migrate_1_1_0_to_1_2_0(JsonObject config) {
        System.out.println("[Questory] Migrating config 1.1.0 -> 1.2.0: Adding script integration settings");
        ConfigMigrator.addIfMissing(config, "scriptIntegrationEnabled", false);
        ConfigMigrator.addIfMissing(config, "scriptAllowExternalHttp", false);
        ConfigMigrator.addIfMissing(config, "scriptWebhookUrl", "");
        ConfigMigrator.addIfMissing(config, "scriptHttpTimeoutMs", 5000);
        ConfigMigrator.addIfMissing(config, "scriptCommandOnUnlock", "");
        ConfigMigrator.addIfMissing(config, "scriptCommandOnStarted", "");
        ConfigMigrator.addIfMissing(config, "scriptCommandOnProgress", "");
        ConfigMigrator.addIfMissing(config, "scriptCommandOnComplete", "");
        ConfigMigrator.addIfMissing(config, "scriptCommandOnRewardClaimed", "");
        ConfigMigrator.addIfMissing(config, "scriptEmitOnUnlock", true);
        ConfigMigrator.addIfMissing(config, "scriptEmitOnStarted", true);
        ConfigMigrator.addIfMissing(config, "scriptEmitOnProgress", false);
        ConfigMigrator.addIfMissing(config, "scriptEmitOnCompleted", true);
        ConfigMigrator.addIfMissing(config, "scriptEmitOnRewardClaimed", true);
        return config;
    }

    private static void addIfMissing(JsonObject obj, String key, Object value) {
        if (!obj.has(key)) {
            if (value instanceof Boolean) {
                obj.addProperty(key, (Boolean)value);
            } else if (value instanceof Number) {
                obj.addProperty(key, (Number)value);
            } else if (value instanceof String) {
                obj.addProperty(key, (String)value);
            }
        }
    }

    private static String removeComments(String content) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        for (String line : lines = content.split("\n")) {
            String trimmed = line.trim();
            if (trimmed.startsWith("//")) continue;
            result.append(line).append("\n");
        }
        return result.toString();
    }

    public static boolean validateConfig(JsonObject config, ConfigVersion version) {
        return config.has("configVersion");
    }

    static {
        ConfigMigrator.registerMigrations();
    }
}

