/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.config.ConfigMigrator;
import org.texboobcat.questory.config.ConfigVersion;

public class QuestoryConfig {
    private static QuestoryConfig instance;
    public String configVersion = ConfigVersion.CURRENT.toString();
    public boolean enableQuestNotifications = true;
    public boolean enableQuestSounds = true;
    public boolean enableQuestTitles = true;
    public boolean enableQuestChatMessages = true;
    public boolean notifyOnQuestUnlock = true;
    public boolean notifyOnQuestReady = true;
    public boolean notifyOnQuestComplete = true;
    public int autoSaveIntervalTicks = 6000;
    public boolean saveOnEveryProgress = false;
    public boolean trackCompletionTime = true;
    public boolean allowQuestReset = true;
    public boolean allowQuestReload = true;
    public boolean requireOPForAdmin = true;
    public int adminPermissionLevel = 2;
    public boolean showQuestIDInList = false;
    public boolean showProgressPercentage = true;
    public boolean useColoredMessages = true;
    public int maxQuestsPerPlayer = 1000;
    public int maxRequirementsPerQuest = 50;
    public int maxRewardsPerQuest = 20;
    public boolean observationEnabled = true;
    public int observationScanIntervalTicks = 10;
    public double observationMaxLookDistance = 5.0;
    public boolean environmentOnlyVisibleQuests = false;
    public boolean autoCompleteWhenRequirementsMet = false;
    public boolean debugMode = false;
    public boolean logQuestProgress = false;
    public boolean logQuestCompletion = true;
    public boolean enableAdvancedEditor = false;
    public boolean advancedEditorRequiresOp = true;
    public String customThemeName = "";
    public boolean ftbImportPreserveDependencies = true;
    public boolean ftbImportConvertUnknownTasks = true;
    public String ftbImportQuestPrefix = "ftb_";
    public boolean dailyEnable = false;
    public String dailyRemoteUrl = "";
    public List<String> dailyBackupUrls = new ArrayList<String>();
    public boolean dailyFetchOnWorldLoad = true;
    public int dailyFetchIntervalMinutes = 0;
    public int dailyCacheTtlMinutes = 1440;
    public String dailyOfflineFallback = "use_cache";
    public int dailyRolloverHour = 0;
    public String dailyTimeZone = "UTC";
    public String dailyGroupName = "Daily";
    public String dailyTagKey = "daily";
    public String dailyPrefixQuestIds = "daily_";
    public int dailyMaxActiveQuests = 0;
    public String dailyCompletionMode = "ALL";
    public int dailyMinQuestsToComplete = 0;
    public boolean dailyStoreHistory = true;
    public int dailyHttpTimeoutMs = 8000;
    public int dailyRetryCount = 2;
    public String dailyDataDirNameOverride = "";
    public boolean scriptIntegrationEnabled = false;
    public boolean scriptAllowExternalHttp = false;
    public String scriptWebhookUrl = "";
    public int scriptHttpTimeoutMs = 5000;
    public String scriptCommandOnUnlock = "";
    public String scriptCommandOnStarted = "";
    public String scriptCommandOnProgress = "";
    public String scriptCommandOnComplete = "";
    public String scriptCommandOnRewardClaimed = "";
    public boolean scriptEmitOnUnlock = true;
    public boolean scriptEmitOnStarted = true;
    public boolean scriptEmitOnProgress = false;
    public boolean scriptEmitOnCompleted = true;
    public boolean scriptEmitOnRewardClaimed = true;
    public boolean teamSystemEnabled = true;
    public boolean teamUseExternalProvider = true;
    public String teamPreferredProvider = "ftbteams";
    public boolean teamFallbackToBuiltIn = true;
    public String teamDefaultProgressMode = "SHARED";
    public String teamDefaultRewardMode = "SHARED";
    public int teamMaxSize = 10;
    public boolean teamAllowCreation = true;
    public boolean teamRequireAllOnlineDefault = false;
    public int teamSyncProgressDelay = 20;

    private QuestoryConfig() {
    }

    public static QuestoryConfig getInstance() {
        if (instance == null) {
            instance = new QuestoryConfig();
        }
        return instance;
    }

    public static void load(Path configPath) {
        Path configFile = configPath.resolve("questory-common.json");
        try {
            if (Files.exists(configFile, new LinkOption[0])) {
                ConfigVersion targetVersion;
                Gson gson = new Gson();
                String content = Files.readString(configFile);
                String cleanContent = QuestoryConfig.removeComments(content);
                JsonObject jsonObj = (JsonObject)gson.fromJson(cleanContent, JsonObject.class);
                String currentVersionStr = jsonObj.has("configVersion") ? jsonObj.get("configVersion").getAsString() : "1.0.0";
                ConfigVersion currentVersion = ConfigVersion.fromString(currentVersionStr);
                if (currentVersion.isOlderThan(targetVersion = ConfigVersion.CURRENT)) {
                    System.out.println("[Questory] Config migration needed: " + String.valueOf(currentVersion) + " -> " + String.valueOf(targetVersion));
                    boolean migrationSuccess = ConfigMigrator.migrate(configPath, "questory-common.json", targetVersion);
                    if (!migrationSuccess) {
                        System.err.println("[Questory] Migration failed, attempting to load anyway...");
                    }
                    content = Files.readString(configFile);
                    cleanContent = QuestoryConfig.removeComments(content);
                }
                instance = (QuestoryConfig)gson.fromJson(cleanContent, QuestoryConfig.class);
                if (QuestoryConfig.instance.configVersion == null || QuestoryConfig.instance.configVersion.isEmpty()) {
                    QuestoryConfig.instance.configVersion = ConfigVersion.CURRENT.toString();
                }
                System.out.println("[Questory] Config loaded (version " + QuestoryConfig.instance.configVersion + ") from: " + String.valueOf(configFile));
                QuestoryConfig.save(configPath);
            } else {
                instance = new QuestoryConfig();
                QuestoryConfig.save(configPath);
                System.out.println("[Questory] Created default config at: " + String.valueOf(configFile));
            }
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to load config, using defaults: " + e.getMessage());
            e.printStackTrace();
            instance = new QuestoryConfig();
        }
    }

    private static String removeComments(String content) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        for (String line : lines = content.split("\n")) {
            String trimmed = line.trim();
            if (trimmed.startsWith("//")) continue;
            result.append(line).append("\n");
        }
        return result.toString();
    }

    public static void save(Path configPath) {
        if (instance == null) {
            instance = new QuestoryConfig();
        }
        Path configFile = configPath.resolve("questory-common.json");
        try {
            Files.createDirectories(configPath, new FileAttribute[0]);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)instance);
            String commentedJson = "// Questory Configuration File\n// Version: " + (QuestoryConfig.instance.configVersion != null ? QuestoryConfig.instance.configVersion : ConfigVersion.CURRENT.toString()) + "\n// Edit this file to customize quest system behavior\n// Changes require /quest reload or server restart to take effect\n// NOTE: Config backups are automatically created before migrations in questory-backups/\n\n" + json;
            Files.writeString(configFile, (CharSequence)commentedJson, new OpenOption[0]);
            System.out.println("[Questory] Config saved to: " + String.valueOf(configFile));
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to save config: " + e.getMessage());
        }
    }

    public static void reload(Path configPath) {
        QuestoryConfig.load(configPath);
    }

    public boolean shouldNotify(String type) {
        if (!this.enableQuestNotifications) {
            return false;
        }
        return switch (type.toLowerCase()) {
            case "unlock" -> this.notifyOnQuestUnlock;
            case "ready" -> this.notifyOnQuestReady;
            case "complete" -> this.notifyOnQuestComplete;
            default -> true;
        };
    }

    public boolean shouldPlaySound() {
        return this.enableQuestNotifications && this.enableQuestSounds;
    }

    public boolean shouldShowTitle() {
        return this.enableQuestNotifications && this.enableQuestTitles;
    }

    public boolean shouldShowChatMessage() {
        return this.enableQuestNotifications && this.enableQuestChatMessages;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debug) {
        this.debugMode = debug;
    }
}

