/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.ITeamProvider;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class TeamActionPacket {
    private final Action action;
    private final String targetPlayerName;
    private final UUID teamId;

    private boolean isFtbProviderActive() {
        ITeamProvider active = TeamManager.getInstance().getActiveProvider();
        return active != null && "ftbteams".equals(active.getProviderId());
    }

    private void runAsPlayer(class_3222 player, String command) {
        try {
            MinecraftServer server = player.method_5682();
            if (server != null) {
                server.method_3734().method_44252(player.method_5671(), command);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TeamActionPacket(Action action, String targetPlayerName, UUID teamId) {
        this.action = action;
        this.targetPlayerName = targetPlayerName;
        this.teamId = teamId;
    }

    public static TeamActionPacket invite(String playerName) {
        return new TeamActionPacket(Action.INVITE, playerName, null);
    }

    public static TeamActionPacket accept(UUID teamId) {
        return new TeamActionPacket(Action.ACCEPT, null, teamId);
    }

    public static TeamActionPacket decline(UUID teamId) {
        return new TeamActionPacket(Action.DECLINE, null, teamId);
    }

    public static TeamActionPacket leave() {
        return new TeamActionPacket(Action.LEAVE, null, null);
    }

    public static TeamActionPacket kick(String playerName) {
        return new TeamActionPacket(Action.KICK, playerName, null);
    }

    public static void encode(TeamActionPacket packet, class_2540 buf) {
        buf.method_10817((Enum)packet.action);
        buf.writeBoolean(packet.targetPlayerName != null);
        if (packet.targetPlayerName != null) {
            buf.method_10814(packet.targetPlayerName);
        }
        buf.writeBoolean(packet.teamId != null);
        if (packet.teamId != null) {
            buf.method_10797(packet.teamId);
        }
    }

    public static TeamActionPacket decode(class_2540 buf) {
        Action action = (Action)buf.method_10818(Action.class);
        String targetPlayerName = buf.readBoolean() ? buf.method_19772() : null;
        UUID teamId = buf.readBoolean() ? buf.method_10790() : null;
        return new TeamActionPacket(action, targetPlayerName, teamId);
    }

    public void handle(class_3222 player) {
        TeamManager teamMgr = TeamManager.getInstance();
        switch (this.action.ordinal()) {
            case 0: {
                this.handleInvite(player, teamMgr);
                break;
            }
            case 1: {
                this.handleAccept(player, teamMgr);
                break;
            }
            case 2: {
                this.handleDecline(player, teamMgr);
                break;
            }
            case 3: {
                this.handleLeave(player, teamMgr);
                break;
            }
            case 4: {
                this.handleKick(player, teamMgr);
            }
        }
    }

    private void handleInvite(class_3222 player, TeamManager teamMgr) {
        UUID myTeamId = teamMgr.getPlayerTeamId(player.method_5667());
        if (myTeamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (this.isFtbProviderActive()) {
            if (this.targetPlayerName == null || this.targetPlayerName.isBlank()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] No target player specified"));
                return;
            }
            class_3222 target = player.method_5682().method_3760().method_14566(this.targetPlayerName);
            this.runAsPlayer(player, "ftbteams party invite " + this.targetPlayerName);
            this.syncTeamToPlayer(player);
            if (target != null) {
                this.syncTeamToPlayer(target);
            }
            return;
        }
        if (!teamMgr.isTeamOwner(player.method_5667(), myTeamId)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Only the team owner can invite players"));
            return;
        }
        class_3222 target = player.method_5682().method_3760().method_14566(this.targetPlayerName);
        if (target == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c[Questory] Player not found: " + this.targetPlayerName)));
            return;
        }
        if (teamMgr.invitePlayer(myTeamId, target.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Invited " + this.targetPlayerName + " to your team")));
            target.method_43496((class_2561)class_2561.method_43470((String)"\u00a7e[Questory] You have been invited to join a team! Check your Team GUI or use /questory team accept"));
            this.syncTeamToPlayer(player);
            this.syncTeamToPlayer(target);
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Failed to invite player"));
        }
    }

    private void handleAccept(class_3222 player, TeamManager teamMgr) {
        if (this.isFtbProviderActive()) {
            if (this.teamId != null) {
                this.runAsPlayer(player, "ftbteams party join " + String.valueOf(this.teamId));
                this.syncTeamToPlayer(player);
                UUID newTeam = teamMgr.getPlayerTeamId(player.method_5667());
                if (newTeam != null) {
                    for (UUID memberId : teamMgr.getTeamMembers(newTeam)) {
                        class_3222 member = player.method_5682().method_3760().method_14602(memberId);
                        if (member == null || member.method_5667().equals(player.method_5667())) continue;
                        this.syncTeamToPlayer(member);
                    }
                }
            }
            return;
        }
        if (teamMgr.acceptInvite(player.method_5667(), this.teamId)) {
            String teamName = teamMgr.getTeamName(this.teamId);
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] You joined the team: " + teamName)));
            for (UUID memberId : teamMgr.getTeamMembers(this.teamId)) {
                class_3222 member = player.method_5682().method_3760().method_14602(memberId);
                if (member == null || member.method_5667().equals(player.method_5667())) continue;
                member.method_43496((class_2561)class_2561.method_43470((String)("\u00a7e[Questory] " + player.method_5477().getString() + " joined the team!")));
                this.syncTeamToPlayer(member);
            }
            this.syncTeamToPlayer(player);
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Failed to join team"));
        }
    }

    private void handleDecline(class_3222 player, TeamManager teamMgr) {
        if (this.isFtbProviderActive()) {
            if (this.teamId != null) {
                this.runAsPlayer(player, "ftbteams party decline " + String.valueOf(this.teamId));
                this.syncTeamToPlayer(player);
            }
            return;
        }
        if (teamMgr.declineInvite(player.method_5667(), this.teamId)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7a[Questory] Declined team invite"));
            this.syncTeamToPlayer(player);
        }
    }

    private void handleLeave(class_3222 player, TeamManager teamMgr) {
        UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (this.isFtbProviderActive()) {
            this.runAsPlayer(player, "ftbteams party leave");
            Set<UUID> membersBefore = teamMgr.getTeamMembers(teamId);
            for (UUID memberId : membersBefore) {
                class_3222 member;
                if (memberId.equals(player.method_5667()) || (member = player.method_5682().method_3760().method_14602(memberId)) == null) continue;
                this.syncTeamToPlayer(member);
            }
            this.syncTeamToPlayer(player);
            return;
        }
        String teamName = teamMgr.getTeamName(teamId);
        Set<UUID> membersBefore = teamMgr.getTeamMembers(teamId);
        if (teamMgr.leaveTeam(player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] You left the team: " + teamName)));
            for (UUID memberId : membersBefore) {
                class_3222 member;
                if (memberId.equals(player.method_5667()) || (member = player.method_5682().method_3760().method_14602(memberId)) == null) continue;
                member.method_43496((class_2561)class_2561.method_43470((String)("\u00a7e[Questory] " + player.method_5477().getString() + " left the team")));
                this.syncTeamToPlayer(member);
            }
            this.syncTeamToPlayer(player);
        }
    }

    private void handleKick(class_3222 player, TeamManager teamMgr) {
        UUID targetId;
        UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (this.isFtbProviderActive()) {
            if (this.targetPlayerName == null || this.targetPlayerName.isBlank()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] No target player specified"));
                return;
            }
            this.runAsPlayer(player, "ftbteams party kick " + this.targetPlayerName);
            class_3222 target = player.method_5682().method_3760().method_14566(this.targetPlayerName);
            if (target != null) {
                this.syncTeamToPlayer(target);
            }
            this.syncTeamToPlayer(player);
            return;
        }
        class_3222 target = player.method_5682().method_3760().method_14566(this.targetPlayerName);
        UUID uUID = targetId = target != null ? target.method_5667() : null;
        if (targetId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Player must be online to kick"));
            return;
        }
        if (teamMgr.kickPlayer(teamId, targetId, player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Kicked " + this.targetPlayerName + " from the team")));
            if (target != null) {
                target.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You were kicked from the team"));
                this.syncTeamToPlayer(target);
            }
            this.syncTeamToPlayer(player);
        } else {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Failed to kick player"));
        }
    }

    private void syncTeamToPlayer(class_3222 player) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
        QuestTeam team = null;
        if (teamId != null && (team = teamMgr.getTeam(teamId)) == null) {
            team = teamMgr.buildExternalTeamSnapshot(teamId);
        }
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.method_5667());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) {
                inviteTeam = teamMgr.buildExternalTeamSnapshot(inviteTeamId);
            }
            if (inviteTeam == null) continue;
            String ownerName = this.getPlayerName(player.method_5682(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        class_3222 player = server.method_3760().method_14602(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public static enum Action {
        INVITE,
        ACCEPT,
        DECLINE,
        LEAVE,
        KICK;

    }
}

