/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.ITeamProvider;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class TeamCreatePacket {
    private final String teamName;
    private final String description;
    private final Integer colorRGB;

    public TeamCreatePacket(String teamName) {
        this(teamName, null, null);
    }

    public TeamCreatePacket(String teamName, String description, Integer colorRGB) {
        this.teamName = teamName;
        this.description = description;
        this.colorRGB = colorRGB;
    }

    public static void encode(TeamCreatePacket packet, class_2540 buf) {
        buf.method_10814(packet.teamName);
        buf.writeBoolean(packet.description != null);
        if (packet.description != null) {
            buf.method_10814(packet.description);
        }
        buf.writeBoolean(packet.colorRGB != null);
        if (packet.colorRGB != null) {
            buf.writeInt(packet.colorRGB.intValue());
        }
    }

    public static TeamCreatePacket decode(class_2540 buf) {
        String teamName = buf.method_19772();
        String description = null;
        if (buf.readBoolean()) {
            description = buf.method_19772();
        }
        Integer colorRGB = null;
        if (buf.readBoolean()) {
            colorRGB = buf.readInt();
        }
        return new TeamCreatePacket(teamName, description, colorRGB);
    }

    public void handle(class_3222 player) {
        block18: {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (!cfg.teamSystemEnabled) {
                player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questify] Team system is disabled"));
                return;
            }
            if (TeamManager.getInstance().getPlayerTeamId(player.method_5667()) != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questify] You are already in a team!"));
                return;
            }
            try {
                ITeamProvider active = TeamManager.getInstance().getActiveProvider();
                if (active != null && "ftbteams".equals(active.getProviderId())) {
                    try {
                        Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
                        Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
                        if (api == null) break block18;
                        boolean managerLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
                        if (!managerLoaded) {
                            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questify] FTB Teams manager not available on server"));
                            return;
                        }
                        Object manager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
                        Method createMethod = null;
                        for (Method method : manager.getClass().getMethods()) {
                            Class<?>[] p;
                            if (!method.getName().equals("createPartyTeam") || method.getParameterCount() != 4 || !class_3222.class.isAssignableFrom((p = method.getParameterTypes())[0]) || !CharSequence.class.isAssignableFrom(p[1])) continue;
                            createMethod = method;
                            break;
                        }
                        if (createMethod == null) {
                            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questify] Incompatible FTB Teams API: createPartyTeam not found"));
                            return;
                        }
                        Object colorObj = null;
                        if (this.colorRGB != null) {
                            try {
                                Class<?> colorClass = Class.forName("dev.ftb.mods.ftblibrary.icon.Color4I");
                                Method rgb = null;
                                for (Method m : colorClass.getMethods()) {
                                    Class<?>[] p;
                                    if (!m.getName().equals("rgb") || m.getParameterCount() != 3 || (p = m.getParameterTypes())[0] != Integer.TYPE || p[1] != Integer.TYPE || p[2] != Integer.TYPE) continue;
                                    rgb = m;
                                    break;
                                }
                                if (rgb != null) {
                                    int n = this.colorRGB >> 16 & 0xFF;
                                    int g = this.colorRGB >> 8 & 0xFF;
                                    int b = this.colorRGB & 0xFF;
                                    colorObj = rgb.invoke(null, n, g, b);
                                }
                            }
                            catch (Throwable colorClass) {
                                // empty catch block
                            }
                        }
                        try {
                            createMethod.invoke(manager, player, this.teamName, this.description, colorObj);
                            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questify] FTB party '" + this.teamName + "' created successfully!")));
                            break block18;
                        }
                        catch (InvocationTargetException ite) {
                            Throwable cause = ite.getCause();
                            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c[Questify] Failed to create FTB party: " + (cause != null ? cause.getMessage() : ite.getMessage()))));
                            return;
                        }
                    }
                    catch (ClassNotFoundException cnf) {
                        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questify] FTB Teams API not present on server"));
                        return;
                    }
                }
                QuestTeam team = TeamManager.getInstance().createTeam(this.teamName, player.method_5667());
                if (team == null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questify] Team creation is disabled or failed"));
                    return;
                }
                player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questify] Team '" + this.teamName + "' created successfully!")));
            }
            catch (Throwable t) {
                player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c[Questify] Error creating team: " + t.getMessage())));
                return;
            }
        }
        this.syncTeamToPlayer(player);
    }

    private void syncTeamToPlayer(class_3222 player) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
        QuestTeam team = null;
        if (teamId != null && (team = teamMgr.getTeam(teamId)) == null) {
            team = teamMgr.buildExternalTeamSnapshot(teamId);
        }
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.method_5667());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) {
                inviteTeam = teamMgr.buildExternalTeamSnapshot(inviteTeamId);
            }
            if (inviteTeam == null) continue;
            String ownerName = this.getPlayerName(player.method_5682(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        class_3222 player = server.method_3760().method_14602(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public String getTeamName() {
        return this.teamName;
    }
}

