/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class TeamSettingsPacket {
    private final SettingType type;
    private final int intValue;
    private final UUID uuidValue;

    private TeamSettingsPacket(SettingType type, int intValue, UUID uuidValue) {
        this.type = type;
        this.intValue = intValue;
        this.uuidValue = uuidValue;
    }

    public static TeamSettingsPacket setMaxMembers(int maxMembers) {
        return new TeamSettingsPacket(SettingType.MAX_MEMBERS, maxMembers, null);
    }

    public static TeamSettingsPacket transferOwnership(UUID newOwnerId) {
        return new TeamSettingsPacket(SettingType.TRANSFER_OWNERSHIP, 0, newOwnerId);
    }

    public static TeamSettingsPacket disbandTeam() {
        return new TeamSettingsPacket(SettingType.DISBAND_TEAM, 0, null);
    }

    public static void encode(TeamSettingsPacket packet, class_2540 buf) {
        buf.method_10817((Enum)packet.type);
        buf.writeInt(packet.intValue);
        buf.writeBoolean(packet.uuidValue != null);
        if (packet.uuidValue != null) {
            buf.method_10797(packet.uuidValue);
        }
    }

    public static TeamSettingsPacket decode(class_2540 buf) {
        SettingType type = (SettingType)buf.method_10818(SettingType.class);
        int intValue = buf.readInt();
        UUID uuidValue = buf.readBoolean() ? buf.method_10790() : null;
        return new TeamSettingsPacket(type, intValue, uuidValue);
    }

    public void handle(class_3222 player) {
        TeamManager teamMgr = TeamManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
        if (teamId == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (!teamMgr.isTeamOwner(player.method_5667(), teamId)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Only the team owner can modify settings"));
            return;
        }
        QuestTeam team = teamMgr.getTeam(teamId);
        if (team == null) {
            return;
        }
        switch (this.type.ordinal()) {
            case 0: {
                this.handleMaxMembers(player, team);
                break;
            }
            case 1: {
                this.handleTransferOwnership(player, team, teamMgr);
                break;
            }
            case 2: {
                this.handleDisbandTeam(player, team, teamMgr);
            }
        }
    }

    private void handleMaxMembers(class_3222 player, QuestTeam team) {
        int newMax = Math.max(1, Math.min(this.intValue, 100));
        if (newMax < team.getMemberCount()) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c[Questory] Cannot set max members below current member count (" + team.getMemberCount() + ")")));
            return;
        }
        team.getSettings().setMaxMembers(newMax);
        TeamManager.getInstance().saveTeamProgress(team.getTeamId());
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Team max members set to " + newMax)));
        this.syncTeamToAllMembers(team, player.method_5682());
    }

    private void handleTransferOwnership(class_3222 player, QuestTeam team, TeamManager teamMgr) {
        if (this.uuidValue == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Invalid player ID"));
            return;
        }
        if (!team.isMember(this.uuidValue)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Player is not a member of this team"));
            return;
        }
        if (team.isOwner(this.uuidValue)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] That player is already the owner"));
            return;
        }
        team.setOwner(this.uuidValue);
        teamMgr.saveTeamProgress(team.getTeamId());
        String newOwnerName = this.getPlayerName(player.method_5682(), this.uuidValue);
        player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7a[Questory] Transferred team ownership to " + newOwnerName)));
        class_3222 newOwner = player.method_5682().method_3760().method_14602(this.uuidValue);
        if (newOwner != null) {
            newOwner.method_43496((class_2561)class_2561.method_43470((String)("\u00a7e[Questory] You are now the owner of team: " + team.getTeamName())));
        }
        this.syncTeamToAllMembers(team, player.method_5682());
    }

    private void handleDisbandTeam(class_3222 player, QuestTeam team, TeamManager teamMgr) {
        String teamName = team.getTeamName();
        for (UUID memberId : team.getMembers()) {
            class_3222 member = player.method_5682().method_3760().method_14602(memberId);
            if (member == null) continue;
            member.method_43496((class_2561)class_2561.method_43470((String)("\u00a7c[Questory] Team '" + teamName + "' has been disbanded")));
            this.syncTeamToPlayer(member, null);
        }
        teamMgr.deleteTeam(team.getTeamId());
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7a[Questory] Team disbanded successfully"));
    }

    private void syncTeamToAllMembers(QuestTeam team, MinecraftServer server) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        for (UUID memberId : team.getMembers()) {
            class_3222 member = server.method_3760().method_14602(memberId);
            if (member == null) continue;
            this.syncTeamToPlayer(member, team);
        }
    }

    private void syncTeamToPlayer(class_3222 player, QuestTeam team) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.method_5667());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) continue;
            String ownerName = this.getPlayerName(player.method_5682(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        class_3222 player = server.method_3760().method_14602(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public static enum SettingType {
        MAX_MEMBERS,
        TRANSFER_OWNERSHIP,
        DISBAND_TEAM;

    }
}

