/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class AdvancementRequirement
extends Requirement {
    private String advancement;

    public AdvancementRequirement(String advancement) {
        super("advancement");
        this.advancement = advancement;
    }

    public String getAdvancement() {
        return this.advancement;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean completed = this.isMet(progress, questId);
        return (completed ? "\u2713" : "\u2717") + " Complete advancement: " + this.advancement;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("advancement", this.advancement);
        return json;
    }

    public static AdvancementRequirement fromJson(JsonObject json) {
        String advancement = json.get("advancement").getAsString();
        return new AdvancementRequirement(advancement);
    }
}

