/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.quest.ChapterImage;
import org.texboobcat.questory.quest.QuestLink;

public class ChapterData {
    private String id;
    private String title;
    private boolean alwaysInvisible;
    private String defaultQuestShape;
    private double defaultQuestSize;
    private boolean defaultHideDependencyLines;
    private int defaultMinWidth;
    private List<ChapterImage> images;
    private List<QuestLink> questLinks;

    public ChapterData(String id, String title) {
        this.id = id;
        this.title = title;
        this.alwaysInvisible = false;
        this.defaultQuestShape = "";
        this.defaultQuestSize = 1.0;
        this.defaultHideDependencyLines = false;
        this.defaultMinWidth = 0;
        this.images = new ArrayList<ChapterImage>();
        this.questLinks = new ArrayList<QuestLink>();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAlwaysInvisible() {
        return this.alwaysInvisible;
    }

    public String getDefaultQuestShape() {
        return this.defaultQuestShape;
    }

    public double getDefaultQuestSize() {
        return this.defaultQuestSize;
    }

    public boolean isDefaultHideDependencyLines() {
        return this.defaultHideDependencyLines;
    }

    public int getDefaultMinWidth() {
        return this.defaultMinWidth;
    }

    public List<ChapterImage> getImages() {
        return this.images;
    }

    public List<QuestLink> getQuestLinks() {
        return this.questLinks;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAlwaysInvisible(boolean alwaysInvisible) {
        this.alwaysInvisible = alwaysInvisible;
    }

    public void setDefaultQuestShape(String defaultQuestShape) {
        this.defaultQuestShape = defaultQuestShape;
    }

    public void setDefaultQuestSize(double defaultQuestSize) {
        this.defaultQuestSize = defaultQuestSize;
    }

    public void setDefaultHideDependencyLines(boolean defaultHideDependencyLines) {
        this.defaultHideDependencyLines = defaultHideDependencyLines;
    }

    public void setDefaultMinWidth(int defaultMinWidth) {
        this.defaultMinWidth = defaultMinWidth;
    }

    public void addImage(ChapterImage image) {
        this.images.add(image);
    }

    public void addQuestLink(QuestLink link) {
        this.questLinks.add(link);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("title", this.title);
        if (this.alwaysInvisible) {
            json.addProperty("always_invisible", Boolean.valueOf(true));
        }
        if (!this.defaultQuestShape.isEmpty()) {
            json.addProperty("default_quest_shape", this.defaultQuestShape);
        }
        if (this.defaultQuestSize != 1.0) {
            json.addProperty("default_quest_size", (Number)this.defaultQuestSize);
        }
        if (this.defaultHideDependencyLines) {
            json.addProperty("default_hide_dependency_lines", Boolean.valueOf(true));
        }
        if (this.defaultMinWidth > 0) {
            json.addProperty("default_min_width", (Number)this.defaultMinWidth);
        }
        if (!this.images.isEmpty()) {
            JsonArray imagesArray = new JsonArray();
            this.images.forEach(img -> imagesArray.add((JsonElement)img.toJson()));
            json.add("images", (JsonElement)imagesArray);
        }
        if (!this.questLinks.isEmpty()) {
            JsonArray linksArray = new JsonArray();
            this.questLinks.forEach(link -> linksArray.add((JsonElement)link.toJson()));
            json.add("quest_links", (JsonElement)linksArray);
        }
        return json;
    }

    public static ChapterData fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        String title = json.get("title").getAsString();
        ChapterData chapter = new ChapterData(id, title);
        if (json.has("always_invisible")) {
            chapter.setAlwaysInvisible(json.get("always_invisible").getAsBoolean());
        }
        if (json.has("default_quest_shape")) {
            chapter.setDefaultQuestShape(json.get("default_quest_shape").getAsString());
        }
        if (json.has("default_quest_size")) {
            chapter.setDefaultQuestSize(json.get("default_quest_size").getAsDouble());
        }
        if (json.has("default_hide_dependency_lines")) {
            chapter.setDefaultHideDependencyLines(json.get("default_hide_dependency_lines").getAsBoolean());
        }
        if (json.has("default_min_width")) {
            chapter.setDefaultMinWidth(json.get("default_min_width").getAsInt());
        }
        if (json.has("images")) {
            JsonArray imagesArray = json.getAsJsonArray("images");
            imagesArray.forEach(elem -> chapter.addImage(ChapterImage.fromJson(elem.getAsJsonObject())));
        }
        if (json.has("quest_links")) {
            JsonArray linksArray = json.getAsJsonArray("quest_links");
            linksArray.forEach(elem -> chapter.addQuestLink(QuestLink.fromJson(elem.getAsJsonObject())));
        }
        return chapter;
    }
}

