/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class EnergyRequirement
extends Requirement {
    private long amount;

    public EnergyRequirement(long amount) {
        super("energy");
        this.amount = amount;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return (long)progress.getRequirementProgress(questId, this) >= this.amount;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        long current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.amount + " FE";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "energy");
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public static EnergyRequirement fromJson(JsonObject json) {
        long amount = json.get("amount").getAsLong();
        return new EnergyRequirement(amount);
    }
}

