/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.texboobcat.questory.quest.Reward;

public class ItemReward
extends Reward {
    private String item;
    private int count;
    private class_2487 nbt;

    public ItemReward(String item, int count) {
        super("item");
        this.item = item;
        this.count = count;
        this.nbt = null;
    }

    public String getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public void setNbt(class_2487 nbt) {
        this.nbt = nbt;
    }

    @Override
    public void grant(class_3222 player) {
        class_1792 itemType = (class_1792)class_7923.field_41178.method_10223(new class_2960(this.item));
        if (itemType != null) {
            class_1799 stack = new class_1799((class_1935)itemType, this.count);
            if (this.nbt != null) {
                stack.method_7980(this.nbt.method_10553());
            }
            if (!player.method_31548().method_7394(stack)) {
                player.method_7328(stack, false);
            }
        }
    }

    @Override
    public String getDisplayString() {
        return this.count + "x " + this.item;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("item", this.item);
        json.addProperty("count", (Number)this.count);
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
        }
        return json;
    }

    public static ItemReward fromJson(JsonObject json) {
        String item = json.get("item").getAsString();
        int count = json.get("count").getAsInt();
        ItemReward reward = new ItemReward(item, count);
        if (json.has("nbt")) {
            try {
                class_2487 nbt = class_2522.method_10718((String)json.get("nbt").getAsString());
                reward.setNbt(nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reward;
    }
}

