/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class RegionRequirement
extends Requirement {
    private String dimension;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;

    public RegionRequirement(String dimension, int x1, int y1, int z1, int x2, int y2, int z2) {
        super("region");
        this.dimension = dimension;
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
    }

    public String getDimension() {
        return this.dimension;
    }

    public int getMinX() {
        return this.x1;
    }

    public int getMinY() {
        return this.y1;
    }

    public int getMinZ() {
        return this.z1;
    }

    public int getMaxX() {
        return this.x2;
    }

    public int getMaxY() {
        return this.y2;
    }

    public int getMaxZ() {
        return this.z2;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean inside = progress.getRequirementProgress(questId, this) > 0;
        return (inside ? "\u2713" : "\u2717") + " Enter region in " + this.dimension + String.format(" [%d,%d,%d]-[%d,%d,%d]", this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "region");
        json.addProperty("dimension", this.dimension);
        json.addProperty("x1", (Number)this.x1);
        json.addProperty("y1", (Number)this.y1);
        json.addProperty("z1", (Number)this.z1);
        json.addProperty("x2", (Number)this.x2);
        json.addProperty("y2", (Number)this.y2);
        json.addProperty("z2", (Number)this.z2);
        return json;
    }

    public static RegionRequirement fromJson(JsonObject json) {
        String dim = json.has("dimension") ? json.get("dimension").getAsString() : "minecraft:overworld";
        int x1 = json.get("x1").getAsInt();
        int y1 = json.get("y1").getAsInt();
        int z1 = json.get("z1").getAsInt();
        int x2 = json.get("x2").getAsInt();
        int y2 = json.get("y2").getAsInt();
        int z2 = json.get("z2").getAsInt();
        return new RegionRequirement(dim, x1, y1, z1, x2, y2, z2);
    }
}

