/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_3222;
import org.texboobcat.questory.integration.GameStagesHelper;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class StageRequirement
extends Requirement {
    private String stage;

    public StageRequirement(String stage) {
        super("stage");
        this.stage = stage;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    public boolean checkStage(class_3222 player) {
        if (!GameStagesHelper.isAvailable()) {
            return false;
        }
        return GameStagesHelper.getInstance().hasStage(player, this.stage);
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean hasStage = progress.getRequirementProgress(questId, this) > 0;
        return (hasStage ? "\u2713" : "\u2717") + " Unlock stage: " + this.stage;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "stage");
        json.addProperty("stage", this.stage);
        return json;
    }

    public static StageRequirement fromJson(JsonObject json) {
        String stage = json.get("stage").getAsString();
        return new StageRequirement(stage);
    }
}

