/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class StatisticRequirement
extends Requirement {
    private String statistic;
    private int targetValue;

    public StatisticRequirement(String statistic, int targetValue) {
        super("statistic");
        this.statistic = statistic;
        this.targetValue = targetValue;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public int getTargetValue() {
        return this.targetValue;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.targetValue;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        String displayValue;
        int current = progress.getRequirementProgress(questId, this);
        if (this.statistic.contains("_cm")) {
            int currentBlocks = current / 100;
            int targetBlocks = this.targetValue / 100;
            displayValue = currentBlocks + "/" + targetBlocks + " blocks";
        } else {
            displayValue = current + "/" + this.targetValue;
        }
        String friendlyName = this.getFriendlyName(this.statistic);
        return displayValue + " " + friendlyName;
    }

    private String getFriendlyName(String stat) {
        String[] parts = stat.split(":");
        String key = parts.length > 1 ? parts[1] : parts[0];
        String[] words = key.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (result.length() > 0) {
                result.append(" ");
            }
            if (word.equals("cm")) continue;
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase());
        }
        return result.toString();
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("statistic", this.statistic);
        json.addProperty("value", (Number)this.targetValue);
        return json;
    }

    public static StatisticRequirement fromJson(JsonObject json) {
        String statistic = json.get("statistic").getAsString();
        int value = json.get("value").getAsInt();
        return new StatisticRequirement(statistic, value);
    }
}

