/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class StructureRequirement
extends Requirement {
    private String structureId;

    public StructureRequirement(String structureId) {
        super("structure");
        this.structureId = structureId;
    }

    public String getStructureId() {
        return this.structureId;
    }

    public void setStructureId(String structureId) {
        this.structureId = structureId;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean visited = progress.getRequirementProgress(questId, this) > 0;
        return (visited ? "\u2713" : "\u2717") + " Find structure: " + this.structureId;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "structure");
        json.addProperty("structure", this.structureId);
        return json;
    }

    public static StructureRequirement fromJson(JsonObject json) {
        String structureId = json.get("structure").getAsString();
        return new StructureRequirement(structureId);
    }
}

