/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.texboobcat.questory.quest.QuestProgress;

public class PlayerProgressStorage {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path progressPath;
    private final Map<UUID, QuestProgress> progressCache;

    public PlayerProgressStorage(Path dataPath) {
        this.progressPath = dataPath.resolve("questory_progress");
        this.progressCache = new HashMap<UUID, QuestProgress>();
        try {
            Files.createDirectories(this.progressPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create progress directory: " + e.getMessage());
        }
    }

    public QuestProgress getProgress(UUID playerId) {
        if (this.progressCache.containsKey(playerId)) {
            return this.progressCache.get(playerId);
        }
        QuestProgress progress = this.loadProgress(playerId);
        if (progress == null) {
            progress = new QuestProgress(playerId);
        }
        this.progressCache.put(playerId, progress);
        return progress;
    }

    private QuestProgress loadProgress(UUID playerId) {
        Path progressFile = this.getProgressFile(playerId);
        if (!Files.exists(progressFile, new LinkOption[0])) {
            return null;
        }
        try {
            String content = Files.readString(progressFile);
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            return QuestProgress.fromJson(json);
        }
        catch (Exception e) {
            System.err.println("Failed to load progress for player " + String.valueOf(playerId) + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveProgress(UUID playerId) {
        QuestProgress progress = this.progressCache.get(playerId);
        if (progress == null) {
            return false;
        }
        return this.saveProgress(progress);
    }

    public boolean saveProgress(QuestProgress progress) {
        try {
            Path progressFile = this.getProgressFile(progress.getPlayerId());
            Files.createDirectories(progressFile.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((JsonElement)progress.toJson());
            Files.writeString(progressFile, (CharSequence)json, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            System.err.println("Failed to save progress for player " + String.valueOf(progress.getPlayerId()) + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void saveAll() {
        for (QuestProgress progress : this.progressCache.values()) {
            this.saveProgress(progress);
        }
    }

    public void unloadPlayer(UUID playerId) {
        QuestProgress progress = this.progressCache.remove(playerId);
        if (progress != null) {
            this.saveProgress(progress);
        }
    }

    public void loadAll() {
        try {
            if (!Files.exists(this.progressPath, new LinkOption[0])) {
                return;
            }
            try (Stream<Path> paths = Files.list(this.progressPath);){
                paths.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                    try {
                        String fileName = path.getFileName().toString();
                        String uuidString = fileName.replace("player_", "").replace(".json", "");
                        UUID playerId = UUID.fromString(uuidString);
                        QuestProgress progress = this.loadProgress(playerId);
                        if (progress != null) {
                            this.progressCache.put(playerId, progress);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to load progress file " + String.valueOf(path) + ": " + e.getMessage());
                    }
                });
            }
            System.out.println("Loaded progress for " + this.progressCache.size() + " players");
        }
        catch (IOException e) {
            System.err.println("Error loading player progress: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Path getProgressFile(UUID playerId) {
        return this.progressPath.resolve("player_" + playerId.toString() + ".json");
    }

    public void clearCache() {
        this.saveAll();
        this.progressCache.clear();
    }
}

