/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import org.texboobcat.questory.quest.Reward;

public class PendingReward {
    private final UUID playerId;
    private final String questId;
    private final Reward reward;
    private final long timestamp;
    private final String questTitle;

    public PendingReward(UUID playerId, String questId, String questTitle, Reward reward) {
        this.playerId = playerId;
        this.questId = questId;
        this.questTitle = questTitle;
        this.reward = reward;
        this.timestamp = System.currentTimeMillis();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getQuestId() {
        return this.questId;
    }

    public String getQuestTitle() {
        return this.questTitle;
    }

    public Reward getReward() {
        return this.reward;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("playerId", this.playerId.toString());
        json.addProperty("questId", this.questId);
        json.addProperty("questTitle", this.questTitle);
        json.addProperty("timestamp", (Number)this.timestamp);
        json.add("reward", (JsonElement)this.reward.toJson());
        return json;
    }

    public static PendingReward fromJson(JsonObject json) {
        UUID playerId = UUID.fromString(json.get("playerId").getAsString());
        String questId = json.get("questId").getAsString();
        String questTitle = json.get("questTitle").getAsString();
        Reward reward = Reward.fromJson(json.getAsJsonObject("reward"));
        PendingReward pending = new PendingReward(playerId, questId, questTitle, reward);
        return pending;
    }
}

