/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme;

public class ThemeValidator {
    public static ValidationResult validate(String key, String value, Object currentValue) {
        if (value == null) {
            return ValidationResult.error("Value cannot be null");
        }
        if (value.trim().isEmpty()) {
            if (key.contains("icon") || key.contains("background") || key.contains("button") || key.contains("panel") || key.contains("texture") || key.contains("scroll_bar")) {
                return ValidationResult.valid();
            }
            return ValidationResult.error("Value cannot be empty");
        }
        if (currentValue instanceof Integer) {
            return ThemeValidator.validateColor(value);
        }
        if (key.contains("color") || key.contains("_color") || key.endsWith("_border") || key.equals("text_color") || key.equals("hover_text_color") || key.equals("disabled_text_color") || key.equals("tasks_text_color") || key.equals("rewards_text_color")) {
            return ThemeValidator.validateColor(value);
        }
        if (currentValue instanceof Integer && !key.contains("color")) {
            return ThemeValidator.validateInteger(value);
        }
        if (currentValue instanceof Double) {
            return ThemeValidator.validateDouble(value);
        }
        if (key.contains("icon")) {
            return ThemeValidator.validateIcon(value);
        }
        return ValidationResult.valid();
    }

    private static ValidationResult validateInteger(String value) {
        try {
            Integer.parseInt(value.trim());
            return ValidationResult.valid();
        }
        catch (NumberFormatException e) {
            return ValidationResult.error("Must be a valid integer");
        }
    }

    private static ValidationResult validateDouble(String value) {
        try {
            Double.parseDouble(value.trim());
            return ValidationResult.valid();
        }
        catch (NumberFormatException e) {
            return ValidationResult.error("Must be a valid number");
        }
    }

    private static ValidationResult validateColor(String value) {
        String trimmed = value.trim();
        String hex = trimmed;
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.startsWith("0x") || hex.startsWith("0X")) {
            hex = hex.substring(2);
        }
        if (hex.length() != 6 && hex.length() != 8) {
            return ValidationResult.warning("Color should be 6 or 8 hex digits (RRGGBB or AARRGGBB)");
        }
        try {
            Long.parseLong(hex, 16);
            return ValidationResult.valid();
        }
        catch (NumberFormatException e) {
            return ValidationResult.error("Invalid hex color format");
        }
    }

    private static ValidationResult validateIcon(String value) {
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return ValidationResult.warning("Icon path is empty");
        }
        if (!trimmed.contains(":") && !trimmed.startsWith("#")) {
            return ValidationResult.warning("Icon should be namespace:path or #tag format");
        }
        return ValidationResult.valid();
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String message;
        private final ValidationLevel level;

        private ValidationResult(boolean valid, String message, ValidationLevel level) {
            this.valid = valid;
            this.message = message;
            this.level = level;
        }

        public static ValidationResult valid() {
            return new ValidationResult(true, "", ValidationLevel.NONE);
        }

        public static ValidationResult error(String message) {
            return new ValidationResult(false, message, ValidationLevel.ERROR);
        }

        public static ValidationResult warning(String message) {
            return new ValidationResult(true, message, ValidationLevel.WARNING);
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }

        public ValidationLevel getLevel() {
            return this.level;
        }

        public boolean hasIssue() {
            return this.level != ValidationLevel.NONE;
        }
    }

    public static enum ValidationLevel {
        NONE,
        WARNING,
        ERROR;

    }
}

