/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.property;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.texboobcat.questory.theme.property.ColorProperty;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class IconProperty
extends ThemeProperty<IconData> {
    private static final ColorProperty COLOR_PARSER = new ColorProperty("temp");

    public IconProperty(String name) {
        super(name, new IconData("", new HashMap<String, String>()));
    }

    public IconProperty(String name, String defaultValue) {
        super(name, new IconData(defaultValue, new HashMap<String, String>()));
    }

    @Override
    public IconData parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if ((string = string.trim()).equals("none") || string.equals("builtin")) {
            return new IconData(string, new HashMap<String, String>());
        }
        if (string.startsWith("item:") || string.startsWith("tag:")) {
            return new IconData(string, new HashMap<String, String>());
        }
        HashMap<String, String> modifiers = new HashMap<String, String>();
        if (string.startsWith("#") || string.startsWith("0x") || string.startsWith("0X")) {
            modifiers.put("color", string);
            return new IconData("", modifiers);
        }
        String texturePath = string;
        if (string.startsWith("texture:")) {
            texturePath = string.substring("texture:".length()).trim();
        }
        String[] parts = texturePath.split(";");
        String path = parts[0].trim();
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i].trim();
            String[] keyValue = part.split("=", 2);
            if (keyValue.length != 2) continue;
            modifiers.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return new IconData(path, modifiers);
    }

    public String getTexturePath() {
        IconData data = (IconData)this.get();
        return data != null ? data.path : "";
    }

    public String getModifier(String key) {
        IconData data = (IconData)this.get();
        return data != null && data.modifiers != null ? data.modifiers.get(key) : null;
    }

    public Integer getColorModifier() {
        String colorStr = this.getModifier("color");
        if (colorStr != null) {
            return COLOR_PARSER.parse(colorStr);
        }
        return null;
    }

    public Integer getTileSize() {
        String sizeStr = this.getModifier("tile_size");
        if (sizeStr != null) {
            try {
                return Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Integer getPadding() {
        String paddingStr = this.getModifier("padding");
        if (paddingStr != null) {
            try {
                return Integer.parseInt(paddingStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public class_2960 getResourceLocation() {
        String value;
        block7: {
            value = this.getTexturePath();
            if (value == null || value.isEmpty() || value.equals("none") || value.equals("builtin")) {
                return null;
            }
            if (value.startsWith("item:") || value.startsWith("tag:")) {
                return null;
            }
            if (!value.contains(":")) break block7;
            String[] parts = value.split(":", 2);
            return new class_2960(parts[0], parts[1]);
            {
                catch (Exception e) {
                    System.err.println("Failed to parse icon ResourceLocation: " + value);
                    return null;
                }
            }
        }
        try {
            return new class_2960("ftbquests", value);
        }
        catch (Exception ignored) {
            return new class_2960("minecraft", value);
        }
    }

    public static class IconData {
        public final String path;
        public final Map<String, String> modifiers;

        public IconData(String path, Map<String, String> modifiers) {
            this.path = path;
            this.modifiers = modifiers;
        }

        public String toString() {
            if (this.modifiers.isEmpty()) {
                return this.path;
            }
            StringBuilder sb = new StringBuilder(this.path);
            for (Map.Entry<String, String> entry : this.modifiers.entrySet()) {
                sb.append("; ").append(entry.getKey()).append("=").append(entry.getValue());
            }
            return sb.toString();
        }
    }
}

