/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.selector;

import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.theme.selector.ThemeSelector;

public class AndSelector
implements ThemeSelector {
    public final List<ThemeSelector> selectors = new ArrayList<ThemeSelector>();

    @Override
    public boolean matches(Quest quest) {
        for (ThemeSelector selector : this.selectors) {
            if (selector.matches(quest)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getPriority() {
        int priority = 0;
        for (ThemeSelector selector : this.selectors) {
            priority += selector.getPriority();
        }
        return priority;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (i > 0) {
                sb.append(" & ");
            }
            sb.append(this.selectors.get(i));
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.selectors.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof AndSelector)) return false;
        AndSelector other = (AndSelector)obj;
        if (!this.selectors.equals(other.selectors)) return false;
        return true;
    }
}

