/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class DependenciesTabPanel
extends TabPanel {
    private List<Quest> availableQuests = new ArrayList<Quest>();
    private Set<String> selectedDeps = new HashSet<String>();
    private int availableScroll = 0;
    private String searchQuery = "";
    private EditBox searchBox;
    private Button addBtn;
    private Button removeBtn;
    private Button clearBtn;
    private Button modeAllBtn;
    private Button modeOneBtn;
    private Button modeStartedBtn;
    private String depMode = "all_completed";
    private int minRequired = 0;
    private int maxCompletable = 0;
    private boolean hideLines = false;
    private String lineStyle = "solid";

    public DependenciesTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox = new EditBox(this.editor.getMinecraft().f_91062_, this.x + 16, this.y + 32, searchW, 16, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search quests..."));
        this.searchBox.m_94151_(text -> {
            this.searchQuery = text.toLowerCase();
        });
        this.fields.add(this.searchBox);
        int btnY = this.y + this.h - 32;
        this.addBtn = Button.m_253074_((Component)Component.m_237113_((String)"Add Selected \u2192"), b -> this.addSelectedDeps()).m_252987_(this.x + 12, btnY, 120, 20).m_253136_();
        this.removeBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2190 Remove"), b -> this.removeSelectedDeps()).m_252987_(this.x + 140, btnY, 100, 20).m_253136_();
        this.clearBtn = Button.m_253074_((Component)Component.m_237113_((String)"Clear All"), b -> this.clearAllDeps()).m_252987_(this.x + 248, btnY, 80, 20).m_253136_();
        int modeX = this.x + this.w - 400;
        int modeY = this.y + 12;
        this.modeAllBtn = Button.m_253074_((Component)Component.m_237113_((String)"All Complete"), b -> this.setDepMode("all_completed")).m_252987_(modeX, modeY, 100, 18).m_253136_();
        this.modeOneBtn = Button.m_253074_((Component)Component.m_237113_((String)"One Complete"), b -> this.setDepMode("one_completed")).m_252987_(modeX + 104, modeY, 100, 18).m_253136_();
        this.modeStartedBtn = Button.m_253074_((Component)Component.m_237113_((String)"All Started"), b -> this.setDepMode("all_started")).m_252987_(modeX + 208, modeY, 90, 18).m_253136_();
    }

    private void setDepMode(String mode) {
        this.depMode = mode;
    }

    private void addSelectedDeps() {
    }

    private void removeSelectedDeps() {
    }

    private void clearAllDeps() {
        this.selectedDeps.clear();
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.availableQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        this.availableQuests.removeIf(q -> q.getId().equals(quest.getId()));
        this.selectedDeps.clear();
        this.selectedDeps.addAll(quest.getDependencies());
        this.depMode = quest.getDependencyRequirement();
        this.minRequired = quest.getMinRequiredDependencies();
        this.maxCompletable = quest.getMaxCompletableDeps();
        this.hideLines = quest.isHideDependencyLines();
        this.lineStyle = quest.getLineStyle();
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.getDependencies().clear();
        quest.getDependencies().addAll(this.selectedDeps);
        quest.setDependencyRequirement(this.depMode);
        quest.setMinRequiredDependencies(this.minRequired);
        quest.setMaxCompletableDeps(this.maxCompletable);
        quest.setHideDependencyLines(this.hideLines);
        quest.setLineStyle(this.lineStyle);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int leftW = this.w / 2 - 20;
        int rightW = this.w / 2 - 20;
        int leftX = this.x + 12;
        int rightX = this.x + this.w / 2 + 8;
        int listY = this.y + 54;
        int listH = this.h - 104;
        g.m_280509_(leftX, listY, leftX + leftW, listY + listH, -803200992);
        g.m_280488_(this.getFont(), "\u00a7lAvailable Quests", leftX, this.y + 12, -86);
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox.m_264152_(this.x + 16, this.y + 32);
        this.searchBox.m_88315_(g, mouseX, mouseY, partialTick);
        this.renderAvailableList(g, leftX, listY, leftW, listH, mouseX, mouseY);
        g.m_280509_(rightX, listY, rightX + rightW, listY + listH, -803200992);
        g.m_280488_(this.getFont(), "\u00a7lSelected Dependencies", rightX, this.y + 12, -86);
        this.renderSelectedList(g, rightX, listY, rightW, listH, mouseX, mouseY);
        int modeX = this.x + this.w - 400;
        int modeY = this.y + 12;
        g.m_280488_(this.getFont(), "Dependency Mode:", modeX - 120, modeY + 5, -1);
        this.modeAllBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.modeOneBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.modeStartedBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.addBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.removeBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.clearBtn.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderAvailableList(GuiGraphics g, int lx, int ly, int lw, int lh, int mx, int my) {
        g.m_280588_(lx, ly, lx + lw, ly + lh);
        int lineH = 16;
        int y = ly + 4;
        List<Quest> filteredQuests = this.availableQuests;
        if (!this.searchQuery.isEmpty()) {
            filteredQuests = this.availableQuests.stream().filter(q -> q.getTitle().toLowerCase().contains(this.searchQuery) || q.getId().toLowerCase().contains(this.searchQuery)).collect(Collectors.toList());
        }
        for (Quest q2 : filteredQuests) {
            if (y > ly + lh) break;
            boolean inDeps = this.selectedDeps.contains(q2.getId());
            String label = (inDeps ? "\u2713 " : "  ") + q2.getTitle();
            g.m_280488_(this.getFont(), label, lx + 4, y, inDeps ? -7798904 : -1);
            y += lineH;
        }
        g.m_280618_();
    }

    private void renderSelectedList(GuiGraphics g, int rx, int ry, int rw, int rh, int mx, int my) {
        g.m_280588_(rx, ry, rx + rw, ry + rh);
        int lineH = 16;
        int y = ry + 4;
        for (String depId : this.selectedDeps) {
            if (y > ry + rh) break;
            Quest dep = ClientQuestManager.getInstance().getQuest(depId);
            String label = dep != null ? dep.getTitle() : depId;
            g.m_280488_(this.getFont(), "\u2192 " + label, rx + 4, y, -1);
            y += lineH;
        }
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox.m_264152_(this.x + 16, this.y + 32);
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.addBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.clearBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeAllBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeOneBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeStartedBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int leftX = this.x + 12;
        int leftW = this.w / 2 - 20;
        int listY = this.y + 54;
        int listH = this.h - 104;
        if (mouseX >= (double)leftX && mouseX <= (double)(leftX + leftW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int index;
            List<Quest> filteredQuests = this.availableQuests;
            if (!this.searchQuery.isEmpty()) {
                filteredQuests = this.availableQuests.stream().filter(q -> q.getTitle().toLowerCase().contains(this.searchQuery) || q.getId().toLowerCase().contains(this.searchQuery)).collect(Collectors.toList());
            }
            if ((index = ((int)mouseY - listY - 4) / 16) >= 0 && index < filteredQuests.size()) {
                Quest q2 = filteredQuests.get(index);
                if (this.selectedDeps.contains(q2.getId())) {
                    this.selectedDeps.remove(q2.getId());
                } else {
                    this.selectedDeps.add(q2.getId());
                }
                return true;
            }
        }
        return false;
    }
}

