/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class QuestIconRenderer {
    public static void render(GuiGraphics graphics, String iconSpec, int x, int y, int size) {
        try {
            if ((Integer)ThemeProperties.FORCE_THEME_ICON.get() == 1) {
                ThemeIconRenderer.draw(graphics, ThemeProperties.ICON, x, y, size, size);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iconSpec == null || iconSpec.isEmpty()) {
            try {
                ThemeIconRenderer.draw(graphics, ThemeProperties.ICON, x, y, size, size);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        try {
            if (iconSpec.startsWith("texture:")) {
                String rlStr = iconSpec.substring("texture:".length());
                ResourceLocation rl = new ResourceLocation(rlStr);
                graphics.m_280163_(rl, x, y, 0.0f, 0.0f, size, size, size, size);
            } else {
                ResourceLocation itemId = new ResourceLocation(iconSpec);
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
                if (item != null) {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    float scale = Math.max(0.125f, (float)size / 16.0f);
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                    graphics.m_280168_().m_85841_(scale, scale, 1.0f);
                    graphics.m_280480_(stack, 0, 0);
                    graphics.m_280168_().m_85849_();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

