/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.QuestoryKeybindings;
import org.texboobcat.questory.quest.Quest;

public class QuestPositionPickerScreen
extends Screen {
    private final Screen parent;
    private final Quest questBeingPositioned;
    private final BiConsumer<Integer, Integer> onPositionSelected;
    private int questX;
    private int questY;
    private double zoom = 1.0;
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private boolean draggingQuest = false;
    private boolean panning = false;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private static final int QUEST_SIZE = 32;
    private static final int GRID_SIZE = 100;

    public QuestPositionPickerScreen(Screen parent, Quest quest, BiConsumer<Integer, Integer> onPositionSelected) {
        super((Component)Component.m_237113_((String)("Position Quest: " + quest.getTitle())));
        this.parent = parent;
        this.questBeingPositioned = quest;
        this.questX = quest.getX();
        this.questY = quest.getY();
        this.onPositionSelected = onPositionSelected;
    }

    protected void m_7856_() {
        super.m_7856_();
        int btnY = this.f_96544_ - 30;
        int btnX = this.f_96543_ / 2 - 110;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Apply"), b -> {
            this.onPositionSelected.accept(this.questX, this.questY);
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(btnX, btnY, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> {
            this.questX = this.questBeingPositioned.getX();
            this.questY = this.questBeingPositioned.getY();
        }).m_252987_(btnX + 65, btnY, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(btnX + 130, btnY, 60, 20).m_253136_());
        this.centerOnQuest();
    }

    private void centerOnQuest() {
        this.scrollX = (double)this.questX * this.zoom - (double)this.f_96543_ / 2.0;
        this.scrollY = (double)this.questY * this.zoom - (double)this.f_96544_ / 2.0;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        this.renderGrid(g);
        ArrayList<Quest> allQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        for (Quest q : allQuests) {
            if (q.getId().equals(this.questBeingPositioned.getId())) continue;
            this.renderQuestNode(g, q, q.getX(), q.getY(), false);
        }
        this.renderDependencyLines(g);
        this.renderQuestNode(g, this.questBeingPositioned, this.questX, this.questY, true);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.f_96547_, "Drag the highlighted quest to position it", 10, 10, -1);
        g.m_280488_(this.f_96547_, "Pan (" + QuestoryKeybindings.getPanViewDisplayName() + ") to move view, scroll to zoom", 10, 22, -5592406);
        g.m_280488_(this.f_96547_, String.format("Position: X=%d, Y=%d", this.questX, this.questY), 10, 34, -256);
    }

    private void renderGrid(GuiGraphics g) {
        int gridSpacing = (int)(100.0 * this.zoom);
        if (gridSpacing < 10) {
            return;
        }
        int startX = (int)(-this.scrollX % (double)gridSpacing);
        int startY = (int)(-this.scrollY % (double)gridSpacing);
        for (int x = startX; x < this.f_96543_; x += gridSpacing) {
            g.m_280509_(x, 0, x + 1, this.f_96544_ - 40, 0x20FFFFFF);
        }
        for (int y = startY; y < this.f_96544_ - 40; y += gridSpacing) {
            g.m_280509_(0, y, this.f_96543_, y + 1, 0x20FFFFFF);
        }
    }

    private void renderQuestNode(GuiGraphics g, Quest quest, int qx, int qy, boolean highlighted) {
        int screenX = (int)((double)qx * this.zoom - this.scrollX);
        int screenY = (int)((double)qy * this.zoom - this.scrollY);
        int size = (int)(32.0 * this.zoom);
        if (screenX + size < 0 || screenX > this.f_96543_ || screenY + size < 0 || screenY > this.f_96544_ - 40) {
            return;
        }
        boolean completed = ClientQuestManager.getInstance().isQuestCompleted(quest.getId());
        int color = highlighted ? -256 : (completed ? -16711936 : -7829368);
        int alpha = highlighted ? 255 : 128;
        g.m_280509_(screenX, screenY, screenX + size, screenY + size, alpha << 24 | color & 0xFFFFFF);
        int borderColor = highlighted ? -1 : -12303292;
        g.m_280509_(screenX, screenY, screenX + size, screenY + 1, borderColor);
        g.m_280509_(screenX, screenY + size - 1, screenX + size, screenY + size, borderColor);
        g.m_280509_(screenX, screenY, screenX + 1, screenY + size, borderColor);
        g.m_280509_(screenX + size - 1, screenY, screenX + size, screenY + size, borderColor);
        if (this.zoom > 0.5) {
            Object title = quest.getTitle();
            if (this.f_96547_.m_92895_((String)title) > size) {
                title = this.f_96547_.m_92834_((String)title, size - 4) + "...";
            }
            g.m_280488_(this.f_96547_, (String)title, screenX + 2, screenY + size + 2, highlighted ? -1 : -5592406);
        }
    }

    private void renderDependencyLines(GuiGraphics g) {
        ArrayList<Quest> allQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        for (String depId : this.questBeingPositioned.getDependencies()) {
            Quest dep = allQuests.stream().filter(q -> q.getId().equals(depId)).findFirst().orElse(null);
            if (dep == null) continue;
            this.renderLine(g, dep.getX(), dep.getY(), this.questX, this.questY, -16711681, "\u2192");
        }
        for (Quest q2 : allQuests) {
            if (!q2.getDependencies().contains(this.questBeingPositioned.getId())) continue;
            this.renderLine(g, this.questX, this.questY, q2.getX(), q2.getY(), -22016, "\u2192");
        }
    }

    private void renderLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color, String arrow) {
        int screenX1 = (int)((double)x1 * this.zoom - this.scrollX) + 16;
        int screenY1 = (int)((double)y1 * this.zoom - this.scrollY) + 16;
        int screenX2 = (int)((double)x2 * this.zoom - this.scrollX) + 16;
        int screenY2 = (int)((double)y2 * this.zoom - this.scrollY) + 16;
        this.drawLine(g, screenX1, screenY1, screenX2, screenY2, color);
    }

    private void drawLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            g.m_280509_(x1, y1, x1 + 2, y1 + 2, color);
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int screenX = (int)((double)this.questX * this.zoom - this.scrollX);
        int screenY = (int)((double)this.questY * this.zoom - this.scrollY);
        int size = (int)(32.0 * this.zoom);
        if (button == 0) {
            if (mouseX >= (double)screenX && mouseX <= (double)(screenX + size) && mouseY >= (double)screenY && mouseY <= (double)(screenY + size)) {
                this.draggingQuest = true;
                int questScreenCenterX = screenX + size / 2;
                int questScreenCenterY = screenY + size / 2;
                this.dragOffsetX = (int)(((double)questScreenCenterX - mouseX) / this.zoom);
                this.dragOffsetY = (int)(((double)questScreenCenterY - mouseY) / this.zoom);
                return true;
            }
        } else if (QuestoryKeybindings.isPanButton(button)) {
            this.panning = true;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingQuest) {
            int worldMouseX = (int)((mouseX + this.scrollX) / this.zoom);
            int worldMouseY = (int)((mouseY + this.scrollY) / this.zoom);
            this.questX = worldMouseX + this.dragOffsetX;
            this.questY = worldMouseY + this.dragOffsetY;
            this.questX = Math.round((float)this.questX / 10.0f) * 10;
            this.questY = Math.round((float)this.questY / 10.0f) * 10;
            return true;
        }
        if (this.panning) {
            this.scrollX -= mouseX - (double)this.prevMouseX;
            this.scrollY -= mouseY - (double)this.prevMouseY;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingQuest = false;
        this.panning = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double oldZoom = this.zoom;
        this.zoom *= 1.0 + delta * 0.1;
        this.zoom = Math.max(0.1, Math.min(3.0, this.zoom));
        double zoomChange = this.zoom / oldZoom;
        this.scrollX = mouseX + (this.scrollX - mouseX) * zoomChange;
        this.scrollY = mouseY + (this.scrollY - mouseY) * zoomChange;
        return true;
    }

    public boolean m_7043_() {
        return false;
    }
}

