/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.nio.file.Path;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.config.QuestoryConfig;

public class QuestoryConfigScreen
extends Screen {
    private final Screen parent;
    private ConfigTab currentTab = ConfigTab.HUD;
    private Button hudTabButton;
    private Button notificationsTabButton;
    private Button displayTabButton;
    private Button generalTabButton;
    private String hudPosition;
    private float hudScale;
    private int hudOpacity;
    private boolean hudCompactMode;
    private boolean hudShowIcons;
    private boolean hudShowProgressBars;
    private int hudOffsetX;
    private int hudOffsetY;
    private boolean enableNotifications;
    private boolean enableSounds;
    private boolean enableTitles;
    private boolean enableChatMessages;
    private boolean notifyOnUnlock;
    private boolean notifyOnReady;
    private boolean notifyOnComplete;
    private boolean showProgressPercentage;
    private boolean useColoredMessages;
    private boolean showQuestIDInList;
    private boolean mapIntegrationEnabled;
    private boolean journeyMapEnabled;
    private boolean clientEnableAdvancedEditor;
    private Button saveButton;
    private Button cancelButton;
    private Button resetButton;
    private boolean draggingHud = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int originalOffsetX = 0;
    private int originalOffsetY = 0;

    public QuestoryConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Questify Configuration"));
        this.parent = parent;
        this.loadConfig();
    }

    private void loadConfig() {
        this.hudPosition = ClientConfig.getHudPosition();
        this.hudScale = ClientConfig.getHudScale();
        this.hudOpacity = ClientConfig.getHudOpacity();
        this.hudCompactMode = ClientConfig.isHudCompactMode();
        this.hudShowIcons = ClientConfig.isHudShowIcons();
        this.hudShowProgressBars = ClientConfig.isHudShowProgressBars();
        this.hudOffsetX = ClientConfig.getHudOffsetX();
        this.hudOffsetY = ClientConfig.getHudOffsetY();
        QuestoryConfig config = QuestoryConfig.getInstance();
        this.enableNotifications = config.enableQuestNotifications;
        this.enableSounds = config.enableQuestSounds;
        this.enableTitles = config.enableQuestTitles;
        this.enableChatMessages = config.enableQuestChatMessages;
        this.notifyOnUnlock = config.notifyOnQuestUnlock;
        this.notifyOnReady = config.notifyOnQuestReady;
        this.notifyOnComplete = config.notifyOnQuestComplete;
        this.showProgressPercentage = config.showProgressPercentage;
        this.useColoredMessages = config.useColoredMessages;
        this.showQuestIDInList = config.showQuestIDInList;
        this.mapIntegrationEnabled = ClientConfig.isMapIntegrationEnabled();
        this.journeyMapEnabled = ClientConfig.isJourneyMapEnabled();
        this.clientEnableAdvancedEditor = ClientConfig.isClientEnableAdvancedEditor();
    }

    protected void m_7856_() {
        super.m_7856_();
        int tabWidth = 100;
        int tabHeight = 20;
        int tabY = 10;
        int tabSpacing = 5;
        int totalTabWidth = tabWidth * 4 + tabSpacing * 3;
        int startX = (this.f_96543_ - totalTabWidth) / 2;
        this.hudTabButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)ConfigTab.HUD.label), b -> {
            if (this.currentTab != ConfigTab.HUD) {
                this.switchTab(ConfigTab.HUD);
            }
        }).m_252987_(startX, tabY, tabWidth, tabHeight).m_253136_());
        this.notificationsTabButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)ConfigTab.NOTIFICATIONS.label), b -> {
            if (this.currentTab != ConfigTab.NOTIFICATIONS) {
                this.switchTab(ConfigTab.NOTIFICATIONS);
            }
        }).m_252987_(startX + tabWidth + tabSpacing, tabY, tabWidth, tabHeight).m_253136_());
        this.displayTabButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)ConfigTab.DISPLAY.label), b -> {
            if (this.currentTab != ConfigTab.DISPLAY) {
                this.switchTab(ConfigTab.DISPLAY);
            }
        }).m_252987_(startX + (tabWidth + tabSpacing) * 2, tabY, tabWidth, tabHeight).m_253136_());
        this.generalTabButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)ConfigTab.GENERAL.label), b -> {
            if (this.currentTab != ConfigTab.GENERAL) {
                this.switchTab(ConfigTab.GENERAL);
            }
        }).m_252987_(startX + (tabWidth + tabSpacing) * 3, tabY, tabWidth, tabHeight).m_253136_());
        int bottomY = this.f_96544_ - 30;
        int bottomButtonWidth = 70;
        int centerX = this.f_96543_ / 2;
        this.resetButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> this.resetCurrentTab()).m_252987_(centerX - bottomButtonWidth * 2 - 10, bottomY, bottomButtonWidth, 20).m_253136_());
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> {
            this.saveAllConfig();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX - bottomButtonWidth / 2, bottomY, bottomButtonWidth, 20).m_253136_());
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX + bottomButtonWidth + 10, bottomY, bottomButtonWidth, 20).m_253136_());
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.initHudTab();
                break;
            }
            case 1: {
                this.initNotificationsTab();
                break;
            }
            case 2: {
                this.initDisplayTab();
                break;
            }
            case 3: {
                this.initGeneralTab();
            }
        }
    }

    private void switchTab(ConfigTab tab) {
        this.currentTab = tab;
        this.m_169413_();
        this.m_7856_();
    }

    private void initHudTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Position: " + this.hudPosition)), b -> {
            this.hudPosition = switch (this.hudPosition) {
                case "TOP_LEFT" -> "TOP_RIGHT";
                case "TOP_RIGHT" -> "BOTTOM_RIGHT";
                case "BOTTOM_RIGHT" -> "BOTTOM_LEFT";
                default -> "TOP_LEFT";
            };
            b.m_93666_((Component)Component.m_237113_((String)("Position: " + this.hudPosition)));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        int scaleY = startY + spacing;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.hudScale = Math.max(0.5f, this.hudScale - 0.1f);
        }).m_252987_(centerX - 60, scaleY, 20, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.hudScale = Math.min(2.0f, this.hudScale + 0.1f);
        }).m_252987_(centerX + 40, scaleY, 20, buttonHeight).m_253136_());
        int opacityY = startY + spacing * 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.hudOpacity = Math.max(0, this.hudOpacity - 10);
        }).m_252987_(centerX - 60, opacityY, 20, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.hudOpacity = Math.min(100, this.hudOpacity + 10);
        }).m_252987_(centerX + 40, opacityY, 20, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))), b -> {
            this.hudCompactMode = !this.hudCompactMode;
            b.m_93666_((Component)Component.m_237113_((String)("Compact: " + (this.hudCompactMode ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))), b -> {
            this.hudShowIcons = !this.hudShowIcons;
            b.m_93666_((Component)Component.m_237113_((String)("Icons: " + (this.hudShowIcons ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))), b -> {
            this.hudShowProgressBars = !this.hudShowProgressBars;
            b.m_93666_((Component)Component.m_237113_((String)("Progress Bars: " + (this.hudShowProgressBars ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
    }

    private void initNotificationsTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))), b -> {
            this.enableNotifications = !this.enableNotifications;
            b.m_93666_((Component)Component.m_237113_((String)("Enable Notifications: " + (this.enableNotifications ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))), b -> {
            this.enableSounds = !this.enableSounds;
            b.m_93666_((Component)Component.m_237113_((String)("Sounds: " + (this.enableSounds ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))), b -> {
            this.enableTitles = !this.enableTitles;
            b.m_93666_((Component)Component.m_237113_((String)("Title Popups: " + (this.enableTitles ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))), b -> {
            this.enableChatMessages = !this.enableChatMessages;
            b.m_93666_((Component)Component.m_237113_((String)("Chat Messages: " + (this.enableChatMessages ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))), b -> {
            this.notifyOnUnlock = !this.notifyOnUnlock;
            b.m_93666_((Component)Component.m_237113_((String)("Notify on Unlock: " + (this.notifyOnUnlock ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))), b -> {
            this.notifyOnReady = !this.notifyOnReady;
            b.m_93666_((Component)Component.m_237113_((String)("Notify on Ready: " + (this.notifyOnReady ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))), b -> {
            this.notifyOnComplete = !this.notifyOnComplete;
            b.m_93666_((Component)Component.m_237113_((String)("Notify on Complete: " + (this.notifyOnComplete ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).m_253136_());
    }

    private void initDisplayTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))), b -> {
            this.showProgressPercentage = !this.showProgressPercentage;
            b.m_93666_((Component)Component.m_237113_((String)("Show Progress Percentage: " + (this.showProgressPercentage ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))), b -> {
            this.useColoredMessages = !this.useColoredMessages;
            b.m_93666_((Component)Component.m_237113_((String)("Colored Messages: " + (this.useColoredMessages ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))), b -> {
            this.showQuestIDInList = !this.showQuestIDInList;
            b.m_93666_((Component)Component.m_237113_((String)("Show Quest IDs: " + (this.showQuestIDInList ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
    }

    private void initGeneralTab() {
        int centerX = this.f_96543_ / 2;
        int startY = 60;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))), b -> {
            this.mapIntegrationEnabled = !this.mapIntegrationEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("Map Integration: " + (this.mapIntegrationEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))), b -> {
            this.journeyMapEnabled = !this.journeyMapEnabled;
            b.m_93666_((Component)Component.m_237113_((String)("JourneyMap Support: " + (this.journeyMapEnabled ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))), b -> {
            this.clientEnableAdvancedEditor = !this.clientEnableAdvancedEditor;
            b.m_93666_((Component)Component.m_237113_((String)("Advanced Editor: " + (this.clientEnableAdvancedEditor ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
    }

    private void resetCurrentTab() {
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.hudPosition = "TOP_LEFT";
                this.hudScale = 1.0f;
                this.hudOpacity = 80;
                this.hudCompactMode = false;
                this.hudShowIcons = true;
                this.hudShowProgressBars = true;
                this.hudOffsetX = 10;
                this.hudOffsetY = 10;
                break;
            }
            case 1: {
                this.enableNotifications = true;
                this.enableSounds = true;
                this.enableTitles = true;
                this.enableChatMessages = true;
                this.notifyOnUnlock = true;
                this.notifyOnReady = true;
                this.notifyOnComplete = true;
                break;
            }
            case 2: {
                this.showProgressPercentage = true;
                this.useColoredMessages = true;
                this.showQuestIDInList = false;
                break;
            }
            case 3: {
                this.mapIntegrationEnabled = true;
                this.journeyMapEnabled = true;
                this.clientEnableAdvancedEditor = true;
            }
        }
        this.m_169413_();
        this.m_7856_();
    }

    private void saveAllConfig() {
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestoryConfig config = QuestoryConfig.getInstance();
        config.enableQuestNotifications = this.enableNotifications;
        config.enableQuestSounds = this.enableSounds;
        config.enableQuestTitles = this.enableTitles;
        config.enableQuestChatMessages = this.enableChatMessages;
        config.notifyOnQuestUnlock = this.notifyOnUnlock;
        config.notifyOnQuestReady = this.notifyOnReady;
        config.notifyOnQuestComplete = this.notifyOnComplete;
        config.showProgressPercentage = this.showProgressPercentage;
        config.useColoredMessages = this.useColoredMessages;
        config.showQuestIDInList = this.showQuestIDInList;
        ClientConfig.setMapIntegrationEnabled(this.mapIntegrationEnabled);
        ClientConfig.setJourneyMapEnabled(this.journeyMapEnabled);
        ClientConfig.setClientEnableAdvancedEditor(this.clientEnableAdvancedEditor);
        try {
            Path configPath = this.f_96541_.f_91069_.toPath().resolve("config");
            QuestoryConfig.save(configPath);
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to save config: " + e.getMessage());
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1072689136);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        if (this.currentTab == ConfigTab.HUD) {
            this.renderHudTabContent(graphics, mouseX, mouseY, partialTick);
        } else if (this.currentTab == ConfigTab.GENERAL) {
            this.renderGeneralTabContent(graphics);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderHudTabContent(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.f_96543_ / 2;
        String instruction = "Click and drag the HUD preview to reposition it";
        graphics.m_280137_(this.f_96547_, instruction, centerX, this.f_96544_ - 50, 0xAAAAFF);
        String scaleText = String.format("Scale: %.1fx", Float.valueOf(this.hudScale));
        graphics.m_280137_(this.f_96547_, scaleText, centerX, 78, 0xFFFFFF);
        String opacityText = String.format("Opacity: %d%%", this.hudOpacity);
        graphics.m_280137_(this.f_96547_, opacityText, centerX, 103, 0xFFFFFF);
        this.renderHudPreview(graphics, partialTick);
    }

    private void renderGeneralTabContent(GuiGraphics graphics) {
        int centerX = this.f_96543_ / 2;
        int startY = 200;
        graphics.m_280137_(this.f_96547_, "Additional settings can be configured in:", centerX, startY, 0xCCCCCC);
        graphics.m_280137_(this.f_96547_, "config/questory-common.json", centerX, startY + 15, 0xFFAA00);
        graphics.m_280137_(this.f_96547_, "Use /quest reload to apply changes", centerX, startY + 35, 0x88FF88);
    }

    private void renderHudPreview(GuiGraphics graphics, float partialTick) {
        String oldPos = ClientConfig.getHudPosition();
        float oldScale = ClientConfig.getHudScale();
        int oldOpacity = ClientConfig.getHudOpacity();
        boolean oldCompact = ClientConfig.isHudCompactMode();
        boolean oldIcons = ClientConfig.isHudShowIcons();
        boolean oldBars = ClientConfig.isHudShowProgressBars();
        int oldOffsetX = ClientConfig.getHudOffsetX();
        int oldOffsetY = ClientConfig.getHudOffsetY();
        ClientConfig.setHudPosition(this.hudPosition);
        ClientConfig.setHudScale(this.hudScale);
        ClientConfig.setHudOpacity(this.hudOpacity);
        ClientConfig.setHudCompactMode(this.hudCompactMode);
        ClientConfig.setHudShowIcons(this.hudShowIcons);
        ClientConfig.setHudShowProgressBars(this.hudShowProgressBars);
        ClientConfig.setHudOffsetX(this.hudOffsetX);
        ClientConfig.setHudOffsetY(this.hudOffsetY);
        QuestHudOverlay.render(graphics, partialTick);
        ClientConfig.setHudPosition(oldPos);
        ClientConfig.setHudScale(oldScale);
        ClientConfig.setHudOpacity(oldOpacity);
        ClientConfig.setHudCompactMode(oldCompact);
        ClientConfig.setHudShowIcons(oldIcons);
        ClientConfig.setHudShowProgressBars(oldBars);
        ClientConfig.setHudOffsetX(oldOffsetX);
        ClientConfig.setHudOffsetY(oldOffsetY);
        if (this.draggingHud) {
            this.drawDragIndicator(graphics);
        }
    }

    private void drawDragIndicator(GuiGraphics graphics) {
        int hudX;
        int panelWidth = this.hudCompactMode ? 200 : 240;
        int panelHeight = 100;
        int hudY = switch (this.hudPosition) {
            case "TOP_RIGHT" -> {
                hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                yield this.hudOffsetY;
            }
            case "BOTTOM_LEFT" -> {
                hudX = this.hudOffsetX;
                yield this.f_96544_ - panelHeight - this.hudOffsetY;
            }
            case "BOTTOM_RIGHT" -> {
                hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                yield this.f_96544_ - panelHeight - this.hudOffsetY;
            }
            default -> {
                hudX = this.hudOffsetX;
                yield this.hudOffsetY;
            }
        };
        graphics.m_280509_(hudX - 2, hudY - 2, hudX + panelWidth + 2, hudY, -2013200640);
        graphics.m_280509_(hudX - 2, hudY + panelHeight, hudX + panelWidth + 2, hudY + panelHeight + 2, -2013200640);
        graphics.m_280509_(hudX - 2, hudY, hudX, hudY + panelHeight, -2013200640);
        graphics.m_280509_(hudX + panelWidth, hudY, hudX + panelWidth + 2, hudY + panelHeight, -2013200640);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.currentTab == ConfigTab.HUD && button == 0) {
            int hudX;
            int panelWidth = this.hudCompactMode ? 200 : 240;
            int panelHeight = 100;
            int hudY = switch (this.hudPosition) {
                case "TOP_RIGHT" -> {
                    hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                    yield this.hudOffsetY;
                }
                case "BOTTOM_LEFT" -> {
                    hudX = this.hudOffsetX;
                    yield this.f_96544_ - panelHeight - this.hudOffsetY;
                }
                case "BOTTOM_RIGHT" -> {
                    hudX = this.f_96543_ - panelWidth - this.hudOffsetX;
                    yield this.f_96544_ - panelHeight - this.hudOffsetY;
                }
                default -> {
                    hudX = this.hudOffsetX;
                    yield this.hudOffsetY;
                }
            };
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + panelWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + panelHeight)) {
                this.draggingHud = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.originalOffsetX = this.hudOffsetX;
                this.originalOffsetY = this.hudOffsetY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingHud) {
            this.draggingHud = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingHud) {
            int deltaX = (int)(mouseX - (double)this.dragStartX);
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            this.hudOffsetX = this.hudPosition.contains("RIGHT") ? Math.max(0, Math.min(this.f_96543_ / 2, this.originalOffsetX - deltaX)) : Math.max(0, Math.min(this.f_96543_ / 2, this.originalOffsetX + deltaX));
            this.hudOffsetY = this.hudPosition.contains("BOTTOM") ? Math.max(0, Math.min(this.f_96544_ / 2, this.originalOffsetY - deltaY)) : Math.max(0, Math.min(this.f_96544_ / 2, this.originalOffsetY + deltaY));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private static enum ConfigTab {
        HUD("HUD"),
        NOTIFICATIONS("Notifications"),
        DISPLAY("Display"),
        GENERAL("General");

        final String label;

        private ConfigTab(String label) {
            this.label = label;
        }
    }
}

