/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;
import org.texboobcat.questory.quest.XpRequirement;

public class RequirementEditorScreen
extends Screen {
    private static final int PANEL_WIDTH = 500;
    private static final int PANEL_HEIGHT = 250;
    private static final int FIELD_HEIGHT = 18;
    private static final int FIELD_SPACING = 24;
    private static final int LABEL_OFFSET = 12;
    private static final int BUTTON_HEIGHT = 20;
    private final Screen parent;
    private final Requirement requirement;
    private final Consumer<Requirement> onSave;
    private final List<EditBox> fields = new ArrayList<EditBox>();
    private Button saveBtn;
    private Button cancelBtn;
    private Button toggleBtn;
    private boolean toggleState = false;
    private String tempCycleValue = null;

    public RequirementEditorScreen(Screen parent, Requirement requirement, Consumer<Requirement> onSave) {
        super((Component)Component.m_237113_((String)("Edit " + requirement.getType().toUpperCase() + " Requirement")));
        this.parent = parent;
        this.requirement = requirement;
        this.onSave = onSave;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.fields.clear();
        int panelX = (this.f_96543_ - 500) / 2;
        int startY = (this.f_96544_ - 250) / 2 + 40;
        this.initFieldsForRequirement(panelX, startY);
        this.initControlButtons(panelX);
    }

    private void initFieldsForRequirement(int x, int y) {
        Requirement requirement = this.requirement;
        if (requirement instanceof ItemRequirement) {
            ItemRequirement ir = (ItemRequirement)requirement;
            this.initItemRequirement(ir, x, y);
        } else {
            requirement = this.requirement;
            if (requirement instanceof EntityKillRequirement) {
                EntityKillRequirement kr = (EntityKillRequirement)requirement;
                this.initEntityKillRequirement(kr, x, y);
            } else {
                requirement = this.requirement;
                if (requirement instanceof LocationRequirement) {
                    LocationRequirement lr = (LocationRequirement)requirement;
                    this.initLocationRequirement(lr, x, y);
                } else {
                    requirement = this.requirement;
                    if (requirement instanceof XpRequirement) {
                        XpRequirement xr = (XpRequirement)requirement;
                        this.initXpRequirement(xr, x, y);
                    } else {
                        requirement = this.requirement;
                        if (requirement instanceof CraftingRequirement) {
                            CraftingRequirement cr = (CraftingRequirement)requirement;
                            this.initCraftingRequirement(cr, x, y);
                        } else {
                            requirement = this.requirement;
                            if (requirement instanceof StageRequirement) {
                                StageRequirement sr = (StageRequirement)requirement;
                                this.initStageRequirement(sr, x, y);
                            } else {
                                requirement = this.requirement;
                                if (requirement instanceof ObservationRequirement) {
                                    ObservationRequirement or = (ObservationRequirement)requirement;
                                    this.initObservationRequirement(or, x, y);
                                } else {
                                    requirement = this.requirement;
                                    if (requirement instanceof StructureRequirement) {
                                        StructureRequirement sr = (StructureRequirement)requirement;
                                        this.initStructureRequirement(sr, x, y);
                                    } else {
                                        requirement = this.requirement;
                                        if (requirement instanceof RegionRequirement) {
                                            RegionRequirement rr = (RegionRequirement)requirement;
                                            this.initRegionRequirement(rr, x, y);
                                        } else {
                                            requirement = this.requirement;
                                            if (requirement instanceof ItemTagRequirement) {
                                                ItemTagRequirement tr = (ItemTagRequirement)requirement;
                                                this.initItemTagRequirement(tr, x, y);
                                            } else {
                                                requirement = this.requirement;
                                                if (requirement instanceof AdvancementRequirement) {
                                                    AdvancementRequirement ar = (AdvancementRequirement)requirement;
                                                    this.initAdvancementRequirement(ar, x, y);
                                                } else {
                                                    requirement = this.requirement;
                                                    if (requirement instanceof BiomeRequirement) {
                                                        BiomeRequirement br = (BiomeRequirement)requirement;
                                                        this.initBiomeRequirement(br, x, y);
                                                    } else {
                                                        requirement = this.requirement;
                                                        if (requirement instanceof DimensionRequirement) {
                                                            DimensionRequirement dr = (DimensionRequirement)requirement;
                                                            this.initDimensionRequirement(dr, x, y);
                                                        } else {
                                                            requirement = this.requirement;
                                                            if (requirement instanceof WeatherRequirement) {
                                                                WeatherRequirement wr = (WeatherRequirement)requirement;
                                                                this.initWeatherRequirement(wr, x, y);
                                                            } else {
                                                                requirement = this.requirement;
                                                                if (requirement instanceof TimeRequirement) {
                                                                    TimeRequirement tr = (TimeRequirement)requirement;
                                                                    this.initTimeRequirement(tr, x, y);
                                                                } else {
                                                                    requirement = this.requirement;
                                                                    if (requirement instanceof CommandRequirement) {
                                                                        CommandRequirement cr = (CommandRequirement)requirement;
                                                                        this.initCommandRequirement(cr, x, y);
                                                                    } else {
                                                                        requirement = this.requirement;
                                                                        if (requirement instanceof CustomRequirement) {
                                                                            CustomRequirement cur = (CustomRequirement)requirement;
                                                                            this.initCustomRequirement(cur, x, y);
                                                                        } else {
                                                                            requirement = this.requirement;
                                                                            if (requirement instanceof StatisticRequirement) {
                                                                                StatisticRequirement sr = (StatisticRequirement)requirement;
                                                                                this.initStatisticRequirement(sr, x, y);
                                                                            } else {
                                                                                requirement = this.requirement;
                                                                                if (requirement instanceof EnergyRequirement) {
                                                                                    EnergyRequirement er = (EnergyRequirement)requirement;
                                                                                    this.initEnergyRequirement(er, x, y);
                                                                                } else {
                                                                                    requirement = this.requirement;
                                                                                    if (requirement instanceof FluidRequirement) {
                                                                                        FluidRequirement fr = (FluidRequirement)requirement;
                                                                                        this.initFluidRequirement(fr, x, y);
                                                                                    } else {
                                                                                        requirement = this.requirement;
                                                                                        if (requirement instanceof CurrencyRequirement) {
                                                                                            CurrencyRequirement cr = (CurrencyRequirement)requirement;
                                                                                            this.initCurrencyRequirement(cr, x, y);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private EditBox createField(int x, int y, int width, String initialValue, String hint) {
        EditBox field = new EditBox(this.f_96547_, x, y, width, 18, (Component)Component.m_237113_((String)hint));
        field.m_94144_(initialValue);
        field.m_257771_((Component)Component.m_237113_((String)hint));
        this.m_142416_((GuiEventListener)field);
        this.fields.add(field);
        return field;
    }

    private void initItemRequirement(ItemRequirement ir, int x, int y) {
        this.createField(x + 100, y, 380, ir.getItem(), "minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(ir.getCount()), "Amount");
        this.toggleState = ir.shouldConsume();
        this.toggleBtn = this.createToggleButton("Consume", this.toggleState, x + 100, y + 48);
    }

    private void initEntityKillRequirement(EntityKillRequirement kr, int x, int y) {
        this.createField(x + 100, y, 380, kr.getEntity(), "minecraft:entity_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(kr.getCount()), "Amount to kill");
    }

    private void initLocationRequirement(LocationRequirement lr, int x, int y) {
        this.createField(x + 100, y, 100, String.valueOf(lr.getX()), "X");
        this.createField(x + 210, y, 100, String.valueOf(lr.getY()), "Y");
        this.createField(x + 320, y, 100, String.valueOf(lr.getZ()), "Z");
        this.createField(x + 100, y + 24, 100, String.valueOf(lr.getRange()), "Radius");
    }

    private void initXpRequirement(XpRequirement xr, int x, int y) {
        this.createField(x + 100, y, 150, String.valueOf(xr.getAmount()), "XP amount");
        this.toggleState = xr.isLevels();
        this.toggleBtn = this.createToggleButton("Type", this.toggleState, "Levels", "Points", x + 260, y);
    }

    private void initCraftingRequirement(CraftingRequirement cr, int x, int y) {
        this.createField(x + 100, y, 380, cr.getItem(), "minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(cr.getCount()), "Amount to craft");
    }

    private void initStageRequirement(StageRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStage(), "stage_name");
    }

    private void initObservationRequirement(ObservationRequirement or, int x, int y) {
        this.createField(x + 100, y, 380, or.getTargetId(), "minecraft:entity_id | minecraft:block_id | minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(or.getTimer()), "Ticks");
        this.tempCycleValue = or.getObserveType();
        if (this.tempCycleValue == null || this.tempCycleValue.isBlank()) {
            this.tempCycleValue = "entity";
        }
        this.toggleBtn = this.createCycleButton("Type", this.tempCycleValue, new String[]{"entity", "block", "item_hand", "item_entity"}, x + 210, y + 24);
    }

    private void initStructureRequirement(StructureRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStructureId(), "minecraft:structure_id or #namespace:tag");
    }

    private void initRegionRequirement(RegionRequirement rr, int x, int y) {
        this.createField(x + 100, y, 200, rr.getDimension(), "minecraft:overworld");
        this.createField(x + 100, y + 24, 60, String.valueOf(rr.getMinX()), "x1");
        this.createField(x + 164, y + 24, 60, String.valueOf(rr.getMinY()), "y1");
        this.createField(x + 228, y + 24, 60, String.valueOf(rr.getMinZ()), "z1");
        this.createField(x + 100, y + 48, 60, String.valueOf(rr.getMaxX()), "x2");
        this.createField(x + 164, y + 48, 60, String.valueOf(rr.getMaxY()), "y2");
        this.createField(x + 228, y + 48, 60, String.valueOf(rr.getMaxZ()), "z2");
    }

    private void initItemTagRequirement(ItemTagRequirement tr, int x, int y) {
        this.createField(x + 100, y, 380, "#" + tr.getTag(), "#namespace:path");
        this.createField(x + 100, y + 24, 100, String.valueOf(tr.getCount()), "Amount");
        this.toggleState = tr.shouldConsume();
        this.toggleBtn = this.createToggleButton("Consume", this.toggleState, x + 100, y + 48);
    }

    private void initAdvancementRequirement(AdvancementRequirement ar, int x, int y) {
        this.createField(x + 100, y, 380, ar.getAdvancement(), "minecraft:story/mine_stone");
    }

    private void initBiomeRequirement(BiomeRequirement br, int x, int y) {
        this.createField(x + 100, y, 380, br.getBiomeId(), "minecraft:plains or #namespace:tag");
    }

    private void initDimensionRequirement(DimensionRequirement dr, int x, int y) {
        this.createField(x + 100, y, 380, dr.getDimensionId(), "minecraft:the_nether");
    }

    private void initWeatherRequirement(WeatherRequirement wr, int x, int y) {
        String[] modes = new String[]{"CLEAR", "RAIN", "THUNDER"};
        String initial = wr.getMode().name();
        this.toggleBtn = this.createCycleButton("Mode", initial, modes, x + 100, y);
    }

    private void initTimeRequirement(TimeRequirement tr, int x, int y) {
        this.createField(x + 100, y, 100, String.valueOf(tr.getStart()), "0..23999");
        this.createField(x + 210, y, 100, String.valueOf(tr.getEnd()), "0..23999");
    }

    private void initCommandRequirement(CommandRequirement cr, int x, int y) {
        this.createField(x + 100, y, 260, cr.getRequirementId(), "unique_id");
        this.createField(x + 100, y + 24, 380, cr.getDescription(), "Shown in UI");
    }

    private void initCustomRequirement(CustomRequirement cur, int x, int y) {
        this.createField(x + 100, y, 260, cur.getTaskId(), "task_key");
        this.createField(x + 100, y + 24, 380, "", "Description");
        this.createField(x + 100, y + 48, 100, String.valueOf(cur.getMaxProgress()), "Max progress");
    }

    private void initStatisticRequirement(StatisticRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStatistic(), "minecraft:walk_one_cm");
        this.createField(x + 100, y + 24, 100, String.valueOf(sr.getTargetValue()), "Target value");
    }

    private void initEnergyRequirement(EnergyRequirement er, int x, int y) {
        this.createField(x + 100, y, 150, String.valueOf(er.getAmount()), "FE");
    }

    private void initFluidRequirement(FluidRequirement fr, int x, int y) {
        this.createField(x + 100, y, 280, fr.getFluidId(), "minecraft:water");
        this.createField(x + 100, y + 24, 100, String.valueOf(fr.getAmount()), "1000 = 1 bucket");
        this.createField(x + 100, y + 48, 380, fr.getNbt() != null ? fr.getNbt().toString() : "", "NBT (optional)");
    }

    private void initCurrencyRequirement(CurrencyRequirement cr, int x, int y) {
        this.createField(x + 100, y, 200, cr.getCurrencyId(), "coins");
        this.createField(x + 100, y + 24, 100, String.valueOf(cr.getAmount()), "Amount");
    }

    private Button createToggleButton(String label, boolean initialState, int x, int y) {
        return this.createToggleButton(label, initialState, "Yes", "No", x, y);
    }

    private Button createToggleButton(String label, boolean initialState, String trueText, String falseText, int x, int y) {
        Button btn = Button.m_253074_((Component)Component.m_237113_((String)(label + ": " + (initialState ? trueText : falseText))), b -> {
            this.toggleState = !this.toggleState;
            b.m_93666_((Component)Component.m_237113_((String)(label + ": " + (this.toggleState ? trueText : falseText))));
        }).m_252987_(x, y, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)btn);
        return btn;
    }

    private Button createCycleButton(String label, String initialValue, String[] options, int x, int y) {
        int[] indexRef = new int[]{this.findIndex(options, initialValue)};
        Button btn = Button.m_253074_((Component)Component.m_237113_((String)(label + ": " + options[indexRef[0]])), b -> {
            indexRef[0] = (indexRef[0] + 1) % options.length;
            this.tempCycleValue = options[indexRef[0]];
            b.m_93666_((Component)Component.m_237113_((String)(label + ": " + this.tempCycleValue)));
        }).m_252987_(x, y, 130, 20).m_253136_();
        this.m_142416_((GuiEventListener)btn);
        return btn;
    }

    private int findIndex(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        return 0;
    }

    private void initControlButtons(int panelX) {
        int btnY = this.f_96544_ / 2 + 100;
        this.saveBtn = Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(panelX + 500 - 140, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.cancelBtn = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(panelX + 500 - 70, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelBtn);
    }

    private void save() {
        try {
            Requirement updated = this.buildUpdatedRequirement();
            if (updated != null) {
                this.onSave.accept(updated);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Requirement buildUpdatedRequirement() {
        Requirement tr;
        if (this.requirement instanceof ItemRequirement) {
            ItemRequirement ir = new ItemRequirement(this.getFieldValue(0), this.parseInt(1));
            ir.setConsume(this.toggleState);
            return ir;
        }
        if (this.requirement instanceof EntityKillRequirement) {
            return new EntityKillRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        Requirement ir = this.requirement;
        if (ir instanceof LocationRequirement) {
            LocationRequirement lr = (LocationRequirement)ir;
            lr.setX(this.parseInt(0));
            lr.setY(this.parseInt(1));
            lr.setZ(this.parseInt(2));
            lr.setRange(this.parseInt(3));
            return lr;
        }
        ir = this.requirement;
        if (ir instanceof XpRequirement) {
            XpRequirement xr = (XpRequirement)ir;
            xr.setAmount(this.parseLong(0));
            xr.setLevels(this.toggleState);
            return xr;
        }
        if (this.requirement instanceof CraftingRequirement) {
            return new CraftingRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        ir = this.requirement;
        if (ir instanceof StageRequirement) {
            StageRequirement sr = (StageRequirement)ir;
            sr.setStage(this.getFieldValue(0));
            return sr;
        }
        ir = this.requirement;
        if (ir instanceof ObservationRequirement) {
            ObservationRequirement or = (ObservationRequirement)ir;
            or.setTargetId(this.getFieldValue(0));
            or.setTimer(this.parseInt(1));
            or.setObserveType(this.tempCycleValue != null ? this.tempCycleValue : "entity");
            return or;
        }
        ir = this.requirement;
        if (ir instanceof StructureRequirement) {
            StructureRequirement sr = (StructureRequirement)ir;
            sr.setStructureId(this.getFieldValue(0));
            return sr;
        }
        if (this.requirement instanceof RegionRequirement) {
            return new RegionRequirement(this.getFieldValue(0), this.parseInt(1), this.parseInt(2), this.parseInt(3), this.parseInt(4), this.parseInt(5), this.parseInt(6));
        }
        if (this.requirement instanceof ItemTagRequirement) {
            tr = new ItemTagRequirement(this.getFieldValue(0), this.parseInt(1));
            ((ItemTagRequirement)tr).setConsume(this.toggleState);
            return tr;
        }
        if (this.requirement instanceof AdvancementRequirement) {
            return new AdvancementRequirement(this.getFieldValue(0));
        }
        tr = this.requirement;
        if (tr instanceof BiomeRequirement) {
            BiomeRequirement br = (BiomeRequirement)tr;
            br.setBiomeId(this.getFieldValue(0));
            return br;
        }
        tr = this.requirement;
        if (tr instanceof DimensionRequirement) {
            DimensionRequirement dr = (DimensionRequirement)tr;
            dr.setDimensionId(this.getFieldValue(0));
            return dr;
        }
        if (this.requirement instanceof WeatherRequirement) {
            String modeStr = this.tempCycleValue != null ? this.tempCycleValue : "CLEAR";
            WeatherRequirement.Mode mode = WeatherRequirement.Mode.valueOf(modeStr);
            return new WeatherRequirement(mode);
        }
        if (this.requirement instanceof TimeRequirement) {
            return new TimeRequirement(this.parseLong(0), this.parseLong(1));
        }
        if (this.requirement instanceof CommandRequirement) {
            return new CommandRequirement(this.getFieldValue(0), this.getFieldValue(1));
        }
        if (this.requirement instanceof CustomRequirement) {
            return new CustomRequirement(this.getFieldValue(0), this.getFieldValue(1), this.parseLong(2));
        }
        if (this.requirement instanceof StatisticRequirement) {
            return new StatisticRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        if (this.requirement instanceof EnergyRequirement) {
            return new EnergyRequirement(this.parseLong(0));
        }
        if (this.requirement instanceof FluidRequirement) {
            FluidRequirement fr = new FluidRequirement(this.getFieldValue(0), this.parseLong(1));
            String nbt = this.getFieldValue(2);
            if (!nbt.isBlank()) {
                try {
                    fr.setNbt(TagParser.m_129359_((String)nbt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fr;
        }
        if (this.requirement instanceof CurrencyRequirement) {
            return new CurrencyRequirement(this.getFieldValue(0), this.parseLong(1));
        }
        return this.requirement;
    }

    private String getFieldValue(int index) {
        return this.fields.get(index).m_94155_().trim();
    }

    private int parseInt(int index) {
        return Integer.parseInt(this.getFieldValue(index));
    }

    private long parseLong(int index) {
        return Long.parseLong(this.getFieldValue(index));
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelX = (this.f_96543_ - 500) / 2;
        int panelY = (this.f_96544_ - 250) / 2;
        g.m_280509_(panelX, panelY, panelX + 500, panelY + 250, -535818224);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, panelY + 12, -1);
        this.renderLabels(g, panelX, panelY + 40);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderLabels(GuiGraphics g, int x, int y) {
        if (this.requirement instanceof ItemRequirement) {
            this.drawLabel(g, "Item ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Consume:", x, y + 48);
        } else if (this.requirement instanceof EntityKillRequirement) {
            this.drawLabel(g, "Entity ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
        } else if (this.requirement instanceof LocationRequirement) {
            this.drawLabel(g, "X:", x, y);
            this.drawLabel(g, "Y:", x + 110, y);
            this.drawLabel(g, "Z:", x + 220, y);
            this.drawLabel(g, "Radius:", x, y + 24);
        } else if (this.requirement instanceof XpRequirement) {
            this.drawLabel(g, "Amount:", x, y);
        } else if (this.requirement instanceof CraftingRequirement) {
            this.drawLabel(g, "Item ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
        } else if (this.requirement instanceof StageRequirement) {
            this.drawLabel(g, "Stage Name:", x, y);
        } else if (this.requirement instanceof ObservationRequirement) {
            this.drawLabel(g, "Target ID:", x, y);
            this.drawLabel(g, "Timer (ticks):", x, y + 24);
        } else if (this.requirement instanceof StructureRequirement) {
            this.drawLabel(g, "Structure:", x, y);
        } else if (this.requirement instanceof RegionRequirement) {
            this.drawLabel(g, "Dimension:", x, y);
            this.drawLabel(g, "x1:", x, y + 24);
            this.drawLabel(g, "y1:", x + 134, y + 24);
            this.drawLabel(g, "z1:", x + 198, y + 24);
            this.drawLabel(g, "x2:", x, y + 48);
            this.drawLabel(g, "y2:", x + 134, y + 48);
            this.drawLabel(g, "z2:", x + 198, y + 48);
        } else if (this.requirement instanceof ItemTagRequirement) {
            this.drawLabel(g, "Tag:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Consume:", x, y + 48);
        } else if (this.requirement instanceof AdvancementRequirement) {
            this.drawLabel(g, "Advancement ID:", x, y);
        } else if (this.requirement instanceof BiomeRequirement) {
            this.drawLabel(g, "Biome or Tag:", x, y);
        } else if (this.requirement instanceof DimensionRequirement) {
            this.drawLabel(g, "Dimension ID:", x, y);
        } else if (this.requirement instanceof WeatherRequirement) {
            this.drawLabel(g, "Weather Mode:", x, y);
        } else if (this.requirement instanceof TimeRequirement) {
            this.drawLabel(g, "Start:", x, y);
            this.drawLabel(g, "End:", x + 200, y);
        } else if (this.requirement instanceof CommandRequirement) {
            this.drawLabel(g, "Command ID:", x, y);
            this.drawLabel(g, "Description:", x, y + 24);
        } else if (this.requirement instanceof CustomRequirement) {
            this.drawLabel(g, "Task ID:", x, y);
            this.drawLabel(g, "Description:", x, y + 24);
            this.drawLabel(g, "Max:", x, y + 48);
        } else if (this.requirement instanceof StatisticRequirement) {
            this.drawLabel(g, "Statistic:", x, y);
            this.drawLabel(g, "Target:", x, y + 24);
        } else if (this.requirement instanceof EnergyRequirement) {
            this.drawLabel(g, "Amount (FE):", x, y);
        } else if (this.requirement instanceof FluidRequirement) {
            this.drawLabel(g, "Fluid ID:", x, y);
            this.drawLabel(g, "Amount (mB):", x, y + 24);
            this.drawLabel(g, "NBT:", x, y + 48);
        } else if (this.requirement instanceof CurrencyRequirement) {
            this.drawLabel(g, "Currency ID:", x, y);
            this.drawLabel(g, "Amount:", x, y + 24);
        }
    }

    private void drawLabel(GuiGraphics g, String text, int x, int y) {
        g.m_280488_(this.f_96547_, text, x + 12, y + 5, -1);
    }

    public boolean m_7043_() {
        return false;
    }
}

