/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RequirementTypePickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onSelect;
    private final String[] types = new String[]{"item", "kill", "location", "xp", "advancement", "biome", "dimension", "crafting", "fluid", "energy", "currency", "statistic", "custom", "command", "time", "weather", "structure", "stage", "region", "observation", "item_tag"};
    private final String[] typeLabels = new String[]{"Item Collection", "Kill Entity", "Location", "Experience", "Advancement", "Biome Visit", "Dimension", "Crafting", "Fluid Collection", "Energy", "Currency", "Statistic", "Custom", "Command Trigger", "Time of Day", "Weather", "Structure", "GameStage", "Region", "Observation", "Item Tag"};
    private int scroll = 0;
    private boolean draggingScrollbar = false;

    public RequirementTypePickerScreen(Screen parent, Consumer<String> onSelect) {
        super((Component)Component.m_237113_((String)"Select Requirement Type"));
        this.parent = parent;
        this.onSelect = onSelect;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        g.m_280509_(panelX, panelY, panelX + panelW, panelY + panelH, -535818224);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, panelY + 12, -1);
        int listY = panelY + 32;
        int listH = panelH - 64;
        int lineH = 20;
        g.m_280588_(panelX, listY, panelX + panelW, listY + listH);
        int maxVisible = listH / lineH;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.types.length - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.types.length - this.scroll); ++i) {
            boolean hover;
            int index = this.scroll + i;
            int itemY = listY + i * lineH;
            boolean bl = hover = mouseX >= panelX + 8 && mouseX <= panelX + panelW - 8 && mouseY >= itemY && mouseY < itemY + lineH;
            if (hover) {
                g.m_280509_(panelX + 8, itemY, panelX + panelW - 8, itemY + lineH, -12952966);
            }
            g.m_280488_(this.f_96547_, this.typeLabels[index], panelX + 12, itemY + 6, -1);
        }
        g.m_280618_();
        int total = this.types.length;
        if (total > maxVisible) {
            int barW = 6;
            int trackX = panelX + panelW - 8 - barW;
            int trackY = listY;
            int trackH = listH;
            g.m_280509_(trackX, trackY, trackX + barW, trackY + trackH, 0x40222222);
            int thumbH = Math.max(12, (int)((float)trackH * (float)maxVisible / (float)total));
            int maxScroll = total - maxVisible;
            int thumbMax = trackH - thumbH;
            int thumbY = trackY + (maxScroll == 0 ? 0 : (int)((float)this.scroll / (float)maxScroll * (float)thumbMax));
            g.m_280509_(trackX + 1, thumbY, trackX + barW - 1, thumbY + thumbH, this.draggingScrollbar ? -9787695 : -7829368);
        }
        int btnW = 80;
        int btnX = this.f_96543_ / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        g.m_280509_(btnX, btnY, btnX + btnW, btnY + 20, -12303292);
        g.m_280137_(this.f_96547_, "Cancel", this.f_96543_ / 2, btnY + 6, -1);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int total;
        int index;
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        int listY = panelY + 32;
        int listH = panelH - 64;
        int lineH = 20;
        int maxVisible = listH / lineH;
        if (mouseX >= (double)(panelX + 8) && mouseX <= (double)(panelX + panelW - 8) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (index = this.scroll + ((int)mouseY - listY) / lineH) >= 0 && index < this.types.length) {
            this.onSelect.accept(this.types[index]);
            return true;
        }
        int barW = 6;
        int trackX = panelX + panelW - 8 - barW;
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + barW) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (total = this.types.length) > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            this.draggingScrollbar = true;
            return true;
        }
        int btnW = 80;
        int btnX = this.f_96543_ / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnW) && mouseY >= (double)btnY && mouseY < (double)(btnY + 20)) {
            this.f_96541_.m_91152_(this.parent);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int panelW = 300;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - 200;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW)) {
            this.scroll = (int)Math.max(0.0, (double)this.scroll - Math.signum(delta));
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScrollbar) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        int listY = panelY + 32;
        int total = this.types.length;
        int listH = panelH - 64;
        int lineH = 20;
        int maxVisible = Math.max(1, listH / lineH);
        if (total > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }
}

