/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.gui.ConfirmationDialog;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSettingsPacket;
import org.texboobcat.questory.team.QuestTeam;

public class TransferOwnershipDialog
extends Screen {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 220;
    private static final int MAX_VISIBLE_MEMBERS = 5;
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private List<MemberEntry> memberEntries = new ArrayList<MemberEntry>();
    private int scrollOffset = 0;
    private Button closeButton;

    public TransferOwnershipDialog(Screen parent) {
        super((Component)Component.m_237113_((String)"Transfer Ownership"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 260) / 2;
        this.topPos = (this.f_96544_ - 220) / 2;
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.m_7379_()).m_252987_(this.leftPos + 260 - 75, this.topPos + 5, 70, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.buildMemberEntries();
    }

    private void buildMemberEntries() {
        this.memberEntries.clear();
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        QuestTeam team = clientMgr.getCurrentTeam();
        if (team == null) {
            return;
        }
        UUID currentPlayerId = Minecraft.m_91087_().f_91074_.m_20148_();
        for (UUID memberId : team.getMembers()) {
            if (memberId.equals(currentPlayerId)) continue;
            String name = this.getPlayerName(memberId);
            boolean isOnline = this.isPlayerOnline(memberId);
            MemberEntry entry = new MemberEntry(memberId, name, isOnline);
            int entryY = this.topPos + 40 + this.memberEntries.size() * 30 - this.scrollOffset * 30;
            entry.transferButton = Button.m_253074_((Component)Component.m_237113_((String)"Transfer"), btn -> this.transferToMember(memberId)).m_252987_(this.leftPos + 260 - 85, entryY, 75, 18).m_253136_();
            this.memberEntries.add(entry);
        }
        for (MemberEntry entry : this.memberEntries) {
            this.m_142416_((GuiEventListener)entry.transferButton);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 220, -872415232);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 28, -14540254);
        graphics.m_280488_(this.f_96547_, "Transfer Ownership", this.leftPos + 5, this.topPos + 10, 0xFFFFFF);
        if (this.memberEntries.isEmpty()) {
            graphics.m_280488_(this.f_96547_, "\u00a77No other team members", this.leftPos + 10, this.topPos + 50, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77Invite players to transfer", this.leftPos + 10, this.topPos + 65, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77ownership to them.", this.leftPos + 10, this.topPos + 80, 0x888888);
        } else {
            int i;
            graphics.m_280488_(this.f_96547_, "\u00a77Select a member to make them", this.leftPos + 10, this.topPos + 35, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77the new team owner:", this.leftPos + 10, this.topPos + 47, 0x888888);
            int entryY = this.topPos + 65;
            int visibleCount = 0;
            for (i = this.scrollOffset; i < this.memberEntries.size() && visibleCount < 5; ++visibleCount, ++i) {
                MemberEntry entry = this.memberEntries.get(i);
                if (visibleCount > 0) {
                    graphics.m_280509_(this.leftPos + 10, entryY - 2, this.leftPos + 260 - 10, entryY - 1, 0x44FFFFFF);
                }
                String status = entry.isOnline ? "\u00a7a\u25cf" : "\u00a77\u25cf";
                graphics.m_280488_(this.f_96547_, status + " \u00a7f" + entry.name, this.leftPos + 10, entryY + 4, 0xFFFFFF);
                entry.transferButton.m_253211_(entryY);
                entry.transferButton.f_93624_ = true;
                entryY += 30;
            }
            for (i = 0; i < this.memberEntries.size(); ++i) {
                if (i >= this.scrollOffset && i < this.scrollOffset + 5) continue;
                this.memberEntries.get((int)i).transferButton.f_93624_ = false;
            }
            if (this.memberEntries.size() > 5) {
                String scrollHint = "(" + (this.scrollOffset + 1) + "-" + Math.min(this.scrollOffset + 5, this.memberEntries.size()) + " of " + this.memberEntries.size() + ")";
                graphics.m_280488_(this.f_96547_, "\u00a77" + scrollHint, this.leftPos + 10, this.topPos + 220 - 15, 0x888888);
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.memberEntries.size() > 5) {
            if (scrollDelta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
                return true;
            }
            if (scrollDelta < 0.0 && this.scrollOffset < this.memberEntries.size() - 5) {
                ++this.scrollOffset;
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    private void transferToMember(UUID memberId) {
        String memberName = this.getPlayerName(memberId);
        String message = "Transfer team ownership to " + memberName + "? You will no longer be the owner.";
        this.f_96541_.m_91152_((Screen)new ConfirmationDialog(this.parent, "Confirm Transfer", message, "Transfer", "Cancel", () -> this.sendTransferPacket(memberId), false));
    }

    private void sendTransferPacket(UUID newOwnerId) {
        TeamSettingsPacket packet = TeamSettingsPacket.transferOwnership(newOwnerId);
        NetworkManager.sendToServer(packet);
    }

    private String getPlayerName(UUID playerId) {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(playerId);
        if (player != null) {
            return player.m_7755_().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    private boolean isPlayerOnline(UUID playerId) {
        return Minecraft.m_91087_().f_91073_.m_46003_(playerId) != null;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    static class MemberEntry {
        UUID playerId;
        String name;
        boolean isOnline;
        Button transferButton;

        MemberEntry(UUID playerId, String name, boolean isOnline) {
            this.playerId = playerId;
            this.name = name;
            this.isOnline = isOnline;
        }
    }
}

