/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.api;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.api.RequirementFactory;
import org.texboobcat.questory.api.RequirementRegistry;
import org.texboobcat.questory.api.RewardFactory;
import org.texboobcat.questory.api.RewardRegistry;
import org.texboobcat.questory.api.serialization.RequirementCodec;
import org.texboobcat.questory.api.serialization.RewardCodec;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.team.TeamManager;

public class QuestoryAPI {
    public static void registerRequirementType(String type, RequirementFactory factory) {
        RequirementRegistry.register(type, factory);
    }

    public static void registerRequirementType(ResourceLocation id, RequirementFactory factory) {
        RequirementRegistry.register(id, factory);
    }

    public static void registerRequirementType(ResourceLocation id, RequirementCodec<?> codec) {
        RequirementRegistry.register(id, codec);
    }

    public static void registerRewardType(String type, RewardFactory factory) {
        RewardRegistry.register(type, factory);
    }

    public static void registerRewardType(ResourceLocation id, RewardFactory factory) {
        RewardRegistry.register(id, factory);
    }

    public static void registerRewardType(ResourceLocation id, RewardCodec<?> codec) {
        RewardRegistry.register(id, codec);
    }

    public static Quest getQuest(String questId) {
        return QuestManager.getInstance().getQuest(questId);
    }

    public static Collection<Quest> getAllQuests() {
        return QuestManager.getInstance().getAllQuests();
    }

    public static QuestProgress getPlayerProgress(UUID playerId) {
        return QuestManager.getInstance().getProgress(playerId);
    }

    public static boolean hasCompletedQuest(UUID playerId, String questId) {
        QuestProgress progress = QuestoryAPI.getPlayerProgress(playerId);
        return progress != null && progress.isQuestCompleted(questId);
    }

    public static void trackCustomProgress(UUID playerId, String questId, String requirementId, int amount) {
        QuestManager.getInstance().trackCustomProgress(playerId, questId, requirementId, amount);
    }

    public static boolean completeQuest(ServerPlayer player, String questId) {
        return QuestManager.getInstance().completeQuest(player, questId);
    }

    public static List<Quest> getVisibleQuests(UUID playerId) {
        return QuestManager.getInstance().getVisibleQuests(playerId);
    }

    public static List<Quest> getCompletableQuests(UUID playerId) {
        return QuestManager.getInstance().getCompletableQuests(playerId);
    }

    public static void onDataReload() {
        try {
            Questory.getConfigManager().loadConfig();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        QuestManager.getInstance().reload();
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.teamSystemEnabled) {
                TeamManager.getInstance().saveAll();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void onCommonSetup() {
    }

    public static void onServerStarting() {
        Questory.LOGGER.info("Questify onServerStarting");
    }

    public static void onServerStopping() {
        Questory.LOGGER.info("Questify onServerStopping");
    }
}

