/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;

public class ClientTeamManager {
    private static ClientTeamManager instance;
    private QuestTeam currentTeam;
    private UUID currentPlayerId;
    private List<TeamInviteInfo> pendingInvites = new ArrayList<TeamInviteInfo>();
    private int pendingRewardCount = 0;

    private ClientTeamManager() {
    }

    public static ClientTeamManager getInstance() {
        if (instance == null) {
            instance = new ClientTeamManager();
        }
        return instance;
    }

    public void setCurrentTeam(QuestTeam team) {
        this.currentTeam = team;
    }

    public QuestTeam getCurrentTeam() {
        return this.currentTeam;
    }

    public boolean isInTeam() {
        return this.currentTeam != null;
    }

    public String getTeamName() {
        return this.currentTeam != null ? this.currentTeam.getTeamName() : null;
    }

    public boolean isTeamOwner() {
        if (this.currentTeam == null || this.currentPlayerId == null) {
            return false;
        }
        return this.currentTeam.isOwner(this.currentPlayerId);
    }

    public void setCurrentPlayerId(UUID playerId) {
        this.currentPlayerId = playerId;
    }

    public void setPendingInvites(List<TeamInviteInfo> invites) {
        this.pendingInvites = new ArrayList<TeamInviteInfo>(invites);
    }

    public int getPendingInviteCount() {
        return this.pendingInvites.size();
    }

    public boolean hasPendingInvites() {
        return !this.pendingInvites.isEmpty();
    }

    public void setPendingRewardCount(int count) {
        this.pendingRewardCount = count;
    }

    public int getPendingRewardCount() {
        return this.pendingRewardCount;
    }

    public void clear() {
        this.currentTeam = null;
        this.currentPlayerId = null;
        this.pendingInvites.clear();
        this.pendingRewardCount = 0;
    }

    public void addPendingInvite(TeamInviteInfo invite) {
        this.pendingInvites.add(invite);
    }

    public void removePendingInvite(UUID teamId) {
        this.pendingInvites.removeIf(invite -> invite.getTeamId().equals(teamId));
    }

    public List<TeamInviteInfo> getPendingInvites() {
        return new ArrayList<TeamInviteInfo>(this.pendingInvites);
    }
}

