/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.compat.map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;

public final class MapCompatManager {
    private static final String WAYPOINT_PREFIX = "questory__";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private MapCompatManager() {
    }

    public static void onClientDataChanged() {
        try {
            if (!ClientConfig.isMapIntegrationEnabled()) {
                return;
            }
            if (ClientConfig.isJourneyMapEnabled()) {
                JourneyMapCompat.refreshWaypoints();
            }
        }
        catch (Throwable t) {
            System.err.println("[Questory] MapCompatManager error: " + t.getMessage());
        }
    }

    private static long lastModifiedMillis(Path p) {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private static final class JourneyMapCompat {
        private JourneyMapCompat() {
        }

        static void refreshWaypoints() {
            try {
                Path jmDataWorld = JourneyMapCompat.detectCurrentJMDataWorld();
                if (jmDataWorld == null) {
                    return;
                }
                Path waypointsDir = jmDataWorld.resolve("waypoints");
                Files.createDirectories(waypointsDir, new FileAttribute[0]);
                ClientQuestManager cqm = ClientQuestManager.getInstance();
                QuestProgress progress = cqm.getProgress();
                if (progress == null) {
                    return;
                }
                List<Quest> visible = cqm.getVisibleQuests();
                Set<String> tracked = ClientConfig.getTrackedQuests();
                HashSet<String> desiredIds = new HashSet<String>();
                for (Quest q : visible) {
                    if (!tracked.isEmpty() && !tracked.contains(q.getId()) || cqm.isQuestCompleted(q.getId())) continue;
                    List<Requirement> reqs = q.getRequirements();
                    for (int i = 0; i < reqs.size(); ++i) {
                        Requirement req = reqs.get(i);
                        if (req instanceof LocationRequirement) {
                            LocationRequirement loc = (LocationRequirement)req;
                            if (progress.getRequirementProgress(q.getId(), req) > 0) continue;
                            String id = JourneyMapCompat.waypointId(q.getId(), "loc", i);
                            desiredIds.add(id);
                            JourneyMapCompat.writeJMWaypoint(waypointsDir, id, q.getTitle(), loc.getX(), loc.getY(), loc.getZ(), loc.getDimension());
                            continue;
                        }
                        if (!(req instanceof RegionRequirement)) continue;
                        RegionRequirement reg = (RegionRequirement)req;
                        if (progress.getRequirementProgress(q.getId(), req) > 0) continue;
                        int cx = (reg.getMinX() + reg.getMaxX()) / 2;
                        int cy = (reg.getMinY() + reg.getMaxY()) / 2;
                        int cz = (reg.getMinZ() + reg.getMaxZ()) / 2;
                        String id = JourneyMapCompat.waypointId(q.getId(), "reg", i);
                        desiredIds.add(id);
                        JourneyMapCompat.writeJMWaypoint(waypointsDir, id, q.getTitle() + " (Region)", cx, cy, cz, reg.getDimension());
                    }
                }
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(waypointsDir, "questory__*.json");){
                    for (Path f : ds) {
                        String fname = f.getFileName().toString();
                        String id = fname.substring(0, fname.length() - 5);
                        if (desiredIds.contains(id)) continue;
                        JourneyMapCompat.safeDelete(f);
                    }
                }
            }
            catch (Throwable t) {
                System.err.println("[Questory] JourneyMapCompat.refreshWaypoints error: " + t.getMessage());
            }
        }

        private static void safeDelete(Path f) {
            try {
                Files.deleteIfExists(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static String waypointId(String questId, String kind, int idx) {
            String safeQuest = questId.replaceAll("[^a-zA-Z0-9_-]", "_");
            return MapCompatManager.WAYPOINT_PREFIX + safeQuest + "__" + kind + "__" + idx;
        }

        private static void writeJMWaypoint(Path waypointsDir, String id, String name, int x, int y, int z, String dimension) {
            try {
                LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                json.put("id", id);
                json.put("name", name);
                json.put("icon", "default");
                json.put("x", x);
                json.put("y", y);
                json.put("z", z);
                json.put("enable", true);
                json.put("type", "Normal");
                json.put("color", 0xFF8800);
                json.put("dimensions", Collections.singletonList(dimension));
                Path file = waypointsDir.resolve(id + ".json");
                String pretty = GSON.toJson(json);
                Files.writeString(file, (CharSequence)pretty, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                System.err.println("[Questory] Failed writing JM waypoint '" + id + "': " + e.getMessage());
            }
        }

        private static Path detectCurrentJMDataWorld() {
            try {
                Path gameDir = Minecraft.m_91087_().f_91069_.toPath();
                Path jmData = gameDir.resolve("journeymap").resolve("data");
                if (!Files.isDirectory(jmData, new LinkOption[0])) {
                    return null;
                }
                List candidates = Files.list(jmData).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> Files.isDirectory(p.resolve("waypoints"), new LinkOption[0])).collect(Collectors.toList());
                if (candidates.isEmpty()) {
                    return null;
                }
                candidates.sort(Comparator.comparingLong(MapCompatManager::lastModifiedMillis).reversed());
                return (Path)candidates.get(0);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

