/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.gui.QuestHudOverlay;

public class QuestHudConfigScreen
extends Screen {
    private final Screen parent;
    private String position;
    private float scale;
    private int opacity;
    private boolean compactMode;
    private boolean showIcons;
    private boolean showProgressBars;
    private int offsetX;
    private int offsetY;
    private Button positionButton;
    private Button scaleDownButton;
    private Button scaleUpButton;
    private Button opacityDownButton;
    private Button opacityUpButton;
    private Button compactToggleButton;
    private Button iconsToggleButton;
    private Button progressBarsToggleButton;
    private Button resetButton;
    private Button saveButton;
    private Button cancelButton;
    private boolean draggingHud = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int originalOffsetX = 0;
    private int originalOffsetY = 0;

    public QuestHudConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"HUD Configuration"));
        this.parent = parent;
        this.position = ClientConfig.getHudPosition();
        this.scale = ClientConfig.getHudScale();
        this.opacity = ClientConfig.getHudOpacity();
        this.compactMode = ClientConfig.isHudCompactMode();
        this.showIcons = ClientConfig.isHudShowIcons();
        this.showProgressBars = ClientConfig.isHudShowProgressBars();
        this.offsetX = ClientConfig.getHudOffsetX();
        this.offsetY = ClientConfig.getHudOffsetY();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = 50;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 25;
        this.positionButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Position: " + this.position)), b -> {
            this.position = switch (this.position) {
                case "TOP_LEFT" -> "TOP_RIGHT";
                case "TOP_RIGHT" -> "BOTTOM_RIGHT";
                case "BOTTOM_RIGHT" -> "BOTTOM_LEFT";
                default -> "TOP_LEFT";
            };
            b.m_93666_((Component)Component.m_237113_((String)("Position: " + this.position)));
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_());
        int scaleY = startY + spacing;
        this.scaleDownButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.scale = Math.max(0.5f, this.scale - 0.1f);
            this.updateScaleLabel();
        }).m_252987_(centerX - 60, scaleY, 20, buttonHeight).m_253136_());
        this.scaleUpButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.scale = Math.min(2.0f, this.scale + 0.1f);
            this.updateScaleLabel();
        }).m_252987_(centerX + 40, scaleY, 20, buttonHeight).m_253136_());
        int opacityY = startY + spacing * 2;
        this.opacityDownButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.opacity = Math.max(0, this.opacity - 10);
            this.updateOpacityLabel();
        }).m_252987_(centerX - 60, opacityY, 20, buttonHeight).m_253136_());
        this.opacityUpButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.opacity = Math.min(100, this.opacity + 10);
            this.updateOpacityLabel();
        }).m_252987_(centerX + 40, opacityY, 20, buttonHeight).m_253136_());
        int compactY = startY + spacing * 3;
        this.compactToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Compact: " + (this.compactMode ? "ON" : "OFF"))), b -> {
            this.compactMode = !this.compactMode;
            b.m_93666_((Component)Component.m_237113_((String)("Compact: " + (this.compactMode ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, compactY, buttonWidth, buttonHeight).m_253136_());
        int iconsY = startY + spacing * 4;
        this.iconsToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Icons: " + (this.showIcons ? "ON" : "OFF"))), b -> {
            this.showIcons = !this.showIcons;
            b.m_93666_((Component)Component.m_237113_((String)("Icons: " + (this.showIcons ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, iconsY, buttonWidth, buttonHeight).m_253136_());
        int barsY = startY + spacing * 5;
        this.progressBarsToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Progress Bars: " + (this.showProgressBars ? "ON" : "OFF"))), b -> {
            this.showProgressBars = !this.showProgressBars;
            b.m_93666_((Component)Component.m_237113_((String)("Progress Bars: " + (this.showProgressBars ? "ON" : "OFF"))));
        }).m_252987_(centerX - buttonWidth / 2, barsY, buttonWidth, buttonHeight).m_253136_());
        int bottomY = this.f_96544_ - 30;
        int bottomButtonWidth = 70;
        this.resetButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> this.resetToDefaults()).m_252987_(centerX - bottomButtonWidth * 2 - 10, bottomY, bottomButtonWidth, buttonHeight).m_253136_());
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> {
            this.saveConfig();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX - bottomButtonWidth / 2, bottomY, bottomButtonWidth, buttonHeight).m_253136_());
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX + bottomButtonWidth + 10, bottomY, bottomButtonWidth, buttonHeight).m_253136_());
    }

    private void updateScaleLabel() {
    }

    private void updateOpacityLabel() {
    }

    private void resetToDefaults() {
        this.position = "TOP_LEFT";
        this.scale = 1.0f;
        this.opacity = 80;
        this.compactMode = false;
        this.showIcons = true;
        this.showProgressBars = true;
        this.offsetX = 10;
        this.offsetY = 10;
        this.positionButton.m_93666_((Component)Component.m_237113_((String)("Position: " + this.position)));
        this.compactToggleButton.m_93666_((Component)Component.m_237113_((String)"Compact: OFF"));
        this.iconsToggleButton.m_93666_((Component)Component.m_237113_((String)"Icons: ON"));
        this.progressBarsToggleButton.m_93666_((Component)Component.m_237113_((String)"Progress Bars: ON"));
    }

    private void saveConfig() {
        ClientConfig.setHudPosition(this.position);
        ClientConfig.setHudScale(this.scale);
        ClientConfig.setHudOpacity(this.opacity);
        ClientConfig.setHudCompactMode(this.compactMode);
        ClientConfig.setHudShowIcons(this.showIcons);
        ClientConfig.setHudShowProgressBars(this.showProgressBars);
        ClientConfig.setHudOffsetX(this.offsetX);
        ClientConfig.setHudOffsetY(this.offsetY);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1072689136);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        String instruction = "Click and drag the HUD preview to reposition it";
        graphics.m_280137_(this.f_96547_, instruction, this.f_96543_ / 2, this.f_96544_ - 50, 0xAAAAFF);
        int centerX = this.f_96543_ / 2;
        String scaleText = String.format("Scale: %.1fx", Float.valueOf(this.scale));
        graphics.m_280137_(this.f_96547_, scaleText, centerX, 78, 0xFFFFFF);
        String opacityText = String.format("Opacity: %d%%", this.opacity);
        graphics.m_280137_(this.f_96547_, opacityText, centerX, 103, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderLivePreview(graphics, partialTick);
    }

    private void renderLivePreview(GuiGraphics graphics, float partialTick) {
        String oldPos = ClientConfig.getHudPosition();
        float oldScale = ClientConfig.getHudScale();
        int oldOpacity = ClientConfig.getHudOpacity();
        boolean oldCompact = ClientConfig.isHudCompactMode();
        boolean oldIcons = ClientConfig.isHudShowIcons();
        boolean oldBars = ClientConfig.isHudShowProgressBars();
        int oldOffsetX = ClientConfig.getHudOffsetX();
        int oldOffsetY = ClientConfig.getHudOffsetY();
        ClientConfig.setHudPosition(this.position);
        ClientConfig.setHudScale(this.scale);
        ClientConfig.setHudOpacity(this.opacity);
        ClientConfig.setHudCompactMode(this.compactMode);
        ClientConfig.setHudShowIcons(this.showIcons);
        ClientConfig.setHudShowProgressBars(this.showProgressBars);
        ClientConfig.setHudOffsetX(this.offsetX);
        ClientConfig.setHudOffsetY(this.offsetY);
        QuestHudOverlay.render(graphics, partialTick);
        ClientConfig.setHudPosition(oldPos);
        ClientConfig.setHudScale(oldScale);
        ClientConfig.setHudOpacity(oldOpacity);
        ClientConfig.setHudCompactMode(oldCompact);
        ClientConfig.setHudShowIcons(oldIcons);
        ClientConfig.setHudShowProgressBars(oldBars);
        ClientConfig.setHudOffsetX(oldOffsetX);
        ClientConfig.setHudOffsetY(oldOffsetY);
        this.drawDragIndicator(graphics);
    }

    private void drawDragIndicator(GuiGraphics graphics) {
        int hudX;
        int panelWidth = this.compactMode ? 200 : 240;
        int panelHeight = 100;
        int hudY = switch (this.position) {
            case "TOP_RIGHT" -> {
                hudX = this.f_96543_ - panelWidth - this.offsetX;
                yield this.offsetY;
            }
            case "BOTTOM_LEFT" -> {
                hudX = this.offsetX;
                yield this.f_96544_ - panelHeight - this.offsetY;
            }
            case "BOTTOM_RIGHT" -> {
                hudX = this.f_96543_ - panelWidth - this.offsetX;
                yield this.f_96544_ - panelHeight - this.offsetY;
            }
            default -> {
                hudX = this.offsetX;
                yield this.offsetY;
            }
        };
        if (this.draggingHud) {
            graphics.m_280509_(hudX - 2, hudY - 2, hudX + panelWidth + 2, hudY, -2013200640);
            graphics.m_280509_(hudX - 2, hudY + panelHeight, hudX + panelWidth + 2, hudY + panelHeight + 2, -2013200640);
            graphics.m_280509_(hudX - 2, hudY, hudX, hudY + panelHeight, -2013200640);
            graphics.m_280509_(hudX + panelWidth, hudY, hudX + panelWidth + 2, hudY + panelHeight, -2013200640);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int hudX;
            int panelWidth = this.compactMode ? 200 : 240;
            int panelHeight = 100;
            int hudY = switch (this.position) {
                case "TOP_RIGHT" -> {
                    hudX = this.f_96543_ - panelWidth - this.offsetX;
                    yield this.offsetY;
                }
                case "BOTTOM_LEFT" -> {
                    hudX = this.offsetX;
                    yield this.f_96544_ - panelHeight - this.offsetY;
                }
                case "BOTTOM_RIGHT" -> {
                    hudX = this.f_96543_ - panelWidth - this.offsetX;
                    yield this.f_96544_ - panelHeight - this.offsetY;
                }
                default -> {
                    hudX = this.offsetX;
                    yield this.offsetY;
                }
            };
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + panelWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + panelHeight)) {
                this.draggingHud = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.originalOffsetX = this.offsetX;
                this.originalOffsetY = this.offsetY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingHud) {
            this.draggingHud = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingHud) {
            int deltaX = (int)(mouseX - (double)this.dragStartX);
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            this.offsetX = this.position.contains("RIGHT") ? Math.max(0, Math.min(this.f_96543_ / 2, this.originalOffsetX - deltaX)) : Math.max(0, Math.min(this.f_96543_ / 2, this.originalOffsetX + deltaX));
            this.offsetY = this.position.contains("BOTTOM") ? Math.max(0, Math.min(this.f_96544_ / 2, this.originalOffsetY - deltaY)) : Math.max(0, Math.min(this.f_96544_ / 2, this.originalOffsetY + deltaY));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }
}

