/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.client.gui.ExamplePickerScreen;
import org.texboobcat.questory.client.gui.GenericTriggerHelpScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.TriggerPickerScreen;
import org.texboobcat.questory.manager.TriggerListenerManager;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.EquipItemRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GenericTriggerRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;
import org.texboobcat.questory.quest.XpRequirement;

public class RequirementEditorScreen
extends Screen {
    private static final int PANEL_WIDTH = 500;
    private static final int PANEL_HEIGHT = 250;
    private static final int FIELD_HEIGHT = 18;
    private static final int FIELD_SPACING = 24;
    private static final int LABEL_OFFSET = 12;
    private static final int BUTTON_HEIGHT = 20;
    private final Screen parent;
    private final Requirement requirement;
    private final Consumer<Requirement> onSave;
    private final List<EditBox> fields = new ArrayList<EditBox>();
    private Button saveBtn;
    private Button cancelBtn;
    private Button toggleBtn;
    private boolean toggleState = false;
    private String tempCycleValue = null;
    private String hoveredTooltip = null;
    private int tooltipX = 0;
    private int tooltipY = 0;
    private final List<EquipmentSlotEntry> equipmentEntries = new ArrayList<EquipmentSlotEntry>();
    private Button addEquipmentBtn;
    private float equipmentScrollOffset = 0.0f;
    private int totalEquipmentEntries = 0;
    private static final int MAX_VISIBLE_EQUIPMENT_ENTRIES = 3;
    private boolean isAdvancedMode = false;
    private final List<ConditionEntry> conditionEntries = new ArrayList<ConditionEntry>();
    private Button addConditionBtn;

    public RequirementEditorScreen(Screen parent, Requirement requirement, Consumer<Requirement> onSave) {
        super((Component)Component.m_237113_((String)("Edit " + requirement.getType().toUpperCase() + " Requirement")));
        this.parent = parent;
        this.requirement = requirement;
        this.onSave = onSave;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.fields.clear();
        int panelX = (this.f_96543_ - 500) / 2;
        int startY = (this.f_96544_ - 250) / 2 + 40;
        this.initFieldsForRequirement(panelX, startY);
        this.initControlButtons(panelX);
    }

    private void initFieldsForRequirement(int x, int y) {
        Requirement requirement = this.requirement;
        if (requirement instanceof ItemRequirement) {
            ItemRequirement ir = (ItemRequirement)requirement;
            this.initItemRequirement(ir, x, y);
        } else {
            requirement = this.requirement;
            if (requirement instanceof EntityKillRequirement) {
                EntityKillRequirement kr = (EntityKillRequirement)requirement;
                this.initEntityKillRequirement(kr, x, y);
            } else {
                requirement = this.requirement;
                if (requirement instanceof LocationRequirement) {
                    LocationRequirement lr = (LocationRequirement)requirement;
                    this.initLocationRequirement(lr, x, y);
                } else {
                    requirement = this.requirement;
                    if (requirement instanceof XpRequirement) {
                        XpRequirement xr = (XpRequirement)requirement;
                        this.initXpRequirement(xr, x, y);
                    } else {
                        requirement = this.requirement;
                        if (requirement instanceof CraftingRequirement) {
                            CraftingRequirement cr = (CraftingRequirement)requirement;
                            this.initCraftingRequirement(cr, x, y);
                        } else {
                            requirement = this.requirement;
                            if (requirement instanceof StageRequirement) {
                                StageRequirement sr = (StageRequirement)requirement;
                                this.initStageRequirement(sr, x, y);
                            } else {
                                requirement = this.requirement;
                                if (requirement instanceof ObservationRequirement) {
                                    ObservationRequirement or = (ObservationRequirement)requirement;
                                    this.initObservationRequirement(or, x, y);
                                } else {
                                    requirement = this.requirement;
                                    if (requirement instanceof StructureRequirement) {
                                        StructureRequirement sr = (StructureRequirement)requirement;
                                        this.initStructureRequirement(sr, x, y);
                                    } else {
                                        requirement = this.requirement;
                                        if (requirement instanceof RegionRequirement) {
                                            RegionRequirement rr = (RegionRequirement)requirement;
                                            this.initRegionRequirement(rr, x, y);
                                        } else {
                                            requirement = this.requirement;
                                            if (requirement instanceof ItemTagRequirement) {
                                                ItemTagRequirement tr = (ItemTagRequirement)requirement;
                                                this.initItemTagRequirement(tr, x, y);
                                            } else {
                                                requirement = this.requirement;
                                                if (requirement instanceof AdvancementRequirement) {
                                                    AdvancementRequirement ar = (AdvancementRequirement)requirement;
                                                    this.initAdvancementRequirement(ar, x, y);
                                                } else {
                                                    requirement = this.requirement;
                                                    if (requirement instanceof BiomeRequirement) {
                                                        BiomeRequirement br = (BiomeRequirement)requirement;
                                                        this.initBiomeRequirement(br, x, y);
                                                    } else {
                                                        requirement = this.requirement;
                                                        if (requirement instanceof DimensionRequirement) {
                                                            DimensionRequirement dr = (DimensionRequirement)requirement;
                                                            this.initDimensionRequirement(dr, x, y);
                                                        } else {
                                                            requirement = this.requirement;
                                                            if (requirement instanceof WeatherRequirement) {
                                                                WeatherRequirement wr = (WeatherRequirement)requirement;
                                                                this.initWeatherRequirement(wr, x, y);
                                                            } else {
                                                                requirement = this.requirement;
                                                                if (requirement instanceof TimeRequirement) {
                                                                    TimeRequirement tr = (TimeRequirement)requirement;
                                                                    this.initTimeRequirement(tr, x, y);
                                                                } else {
                                                                    requirement = this.requirement;
                                                                    if (requirement instanceof CommandRequirement) {
                                                                        CommandRequirement cr = (CommandRequirement)requirement;
                                                                        this.initCommandRequirement(cr, x, y);
                                                                    } else {
                                                                        requirement = this.requirement;
                                                                        if (requirement instanceof CheckmarkRequirement) {
                                                                            CheckmarkRequirement ckr = (CheckmarkRequirement)requirement;
                                                                            this.initCheckmarkRequirement(ckr, x, y);
                                                                        } else {
                                                                            requirement = this.requirement;
                                                                            if (requirement instanceof CustomRequirement) {
                                                                                CustomRequirement cur = (CustomRequirement)requirement;
                                                                                this.initCustomRequirement(cur, x, y);
                                                                            } else {
                                                                                requirement = this.requirement;
                                                                                if (requirement instanceof StatisticRequirement) {
                                                                                    StatisticRequirement sr = (StatisticRequirement)requirement;
                                                                                    this.initStatisticRequirement(sr, x, y);
                                                                                } else {
                                                                                    requirement = this.requirement;
                                                                                    if (requirement instanceof EnergyRequirement) {
                                                                                        EnergyRequirement er = (EnergyRequirement)requirement;
                                                                                        this.initEnergyRequirement(er, x, y);
                                                                                    } else {
                                                                                        requirement = this.requirement;
                                                                                        if (requirement instanceof FluidRequirement) {
                                                                                            FluidRequirement fr = (FluidRequirement)requirement;
                                                                                            this.initFluidRequirement(fr, x, y);
                                                                                        } else {
                                                                                            requirement = this.requirement;
                                                                                            if (requirement instanceof CurrencyRequirement) {
                                                                                                CurrencyRequirement cr = (CurrencyRequirement)requirement;
                                                                                                this.initCurrencyRequirement(cr, x, y);
                                                                                            } else {
                                                                                                requirement = this.requirement;
                                                                                                if (requirement instanceof GenericTriggerRequirement) {
                                                                                                    GenericTriggerRequirement gtr = (GenericTriggerRequirement)requirement;
                                                                                                    this.initGenericTriggerRequirement(gtr, x, y);
                                                                                                } else {
                                                                                                    requirement = this.requirement;
                                                                                                    if (requirement instanceof EquipItemRequirement) {
                                                                                                        EquipItemRequirement eir = (EquipItemRequirement)requirement;
                                                                                                        this.initEquipItemRequirement(eir, x, y);
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private EditBox createField(int x, int y, int width, String initialValue, String hint) {
        EditBox field = new EditBox(this.f_96547_, x, y, width, 18, (Component)Component.m_237113_((String)hint));
        field.m_94144_(initialValue);
        field.m_257771_((Component)Component.m_237113_((String)hint));
        field.m_94199_(500);
        this.m_142416_((GuiEventListener)field);
        this.fields.add(field);
        return field;
    }

    private void initItemRequirement(ItemRequirement ir, int x, int y) {
        this.createField(x + 100, y, 380, ir.getItem(), "minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(ir.getCount()), "Amount");
        this.toggleState = ir.shouldConsume();
        this.toggleBtn = this.createToggleButton("Consume", this.toggleState, x + 100, y + 48);
    }

    private void initEntityKillRequirement(EntityKillRequirement kr, int x, int y) {
        this.createField(x + 100, y, 380, kr.getEntity(), "minecraft:entity_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(kr.getCount()), "Amount to kill");
    }

    private void initLocationRequirement(LocationRequirement lr, int x, int y) {
        this.createField(x + 100, y, 100, String.valueOf(lr.getX()), "X");
        this.createField(x + 210, y, 100, String.valueOf(lr.getY()), "Y");
        this.createField(x + 320, y, 100, String.valueOf(lr.getZ()), "Z");
        this.createField(x + 100, y + 24, 100, String.valueOf(lr.getRange()), "Radius");
    }

    private void initXpRequirement(XpRequirement xr, int x, int y) {
        this.createField(x + 100, y, 150, String.valueOf(xr.getAmount()), "XP amount");
        this.toggleState = xr.isLevels();
        this.toggleBtn = this.createToggleButton("Type", this.toggleState, "Levels", "Points", x + 260, y);
    }

    private void initCraftingRequirement(CraftingRequirement cr, int x, int y) {
        this.createField(x + 100, y, 380, cr.getItem(), "minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(cr.getCount()), "Amount to craft");
    }

    private void initStageRequirement(StageRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStage(), "stage_name");
    }

    private void initObservationRequirement(ObservationRequirement or, int x, int y) {
        this.createField(x + 100, y, 380, or.getTargetId(), "minecraft:entity_id | minecraft:block_id | minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(or.getTimer()), "Ticks");
        this.tempCycleValue = or.getObserveType();
        if (this.tempCycleValue == null || this.tempCycleValue.isBlank()) {
            this.tempCycleValue = "entity";
        }
        this.toggleBtn = this.createCycleButton("Type", this.tempCycleValue, new String[]{"entity", "block", "item_hand", "item_entity"}, x + 210, y + 24);
    }

    private void initStructureRequirement(StructureRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStructureId(), "minecraft:structure_id or #namespace:tag");
    }

    private void initRegionRequirement(RegionRequirement rr, int x, int y) {
        this.createField(x + 100, y, 200, rr.getDimension(), "minecraft:overworld");
        this.createField(x + 100, y + 24, 60, String.valueOf(rr.getMinX()), "x1");
        this.createField(x + 164, y + 24, 60, String.valueOf(rr.getMinY()), "y1");
        this.createField(x + 228, y + 24, 60, String.valueOf(rr.getMinZ()), "z1");
        this.createField(x + 100, y + 48, 60, String.valueOf(rr.getMaxX()), "x2");
        this.createField(x + 164, y + 48, 60, String.valueOf(rr.getMaxY()), "y2");
        this.createField(x + 228, y + 48, 60, String.valueOf(rr.getMaxZ()), "z2");
    }

    private void initItemTagRequirement(ItemTagRequirement tr, int x, int y) {
        this.createField(x + 100, y, 380, "#" + tr.getTag(), "#namespace:path");
        this.createField(x + 100, y + 24, 100, String.valueOf(tr.getCount()), "Amount");
        this.toggleState = tr.shouldConsume();
        this.toggleBtn = this.createToggleButton("Consume", this.toggleState, x + 100, y + 48);
    }

    private void initAdvancementRequirement(AdvancementRequirement ar, int x, int y) {
        this.createField(x + 100, y, 380, ar.getAdvancement(), "minecraft:story/mine_stone");
    }

    private void initBiomeRequirement(BiomeRequirement br, int x, int y) {
        this.createField(x + 100, y, 380, br.getBiomeId(), "minecraft:plains or #namespace:tag");
    }

    private void initDimensionRequirement(DimensionRequirement dr, int x, int y) {
        this.createField(x + 100, y, 380, dr.getDimensionId(), "minecraft:the_nether");
    }

    private void initWeatherRequirement(WeatherRequirement wr, int x, int y) {
        String[] modes = new String[]{"CLEAR", "RAIN", "THUNDER"};
        String initial = wr.getMode().name();
        this.toggleBtn = this.createCycleButton("Mode", initial, modes, x + 100, y);
    }

    private void initTimeRequirement(TimeRequirement tr, int x, int y) {
        this.createField(x + 100, y, 100, String.valueOf(tr.getStart()), "0..23999");
        this.createField(x + 210, y, 100, String.valueOf(tr.getEnd()), "0..23999");
    }

    private void initCommandRequirement(CommandRequirement cr, int x, int y) {
        this.createField(x + 100, y, 260, cr.getRequirementId(), "unique_id");
        this.createField(x + 100, y + 24, 380, cr.getDescription(), "Shown in UI");
    }

    private void initCheckmarkRequirement(CheckmarkRequirement ckr, int x, int y) {
        this.createField(x + 100, y, 260, ckr.getRequirementId(), "unique_id");
        this.createField(x + 100, y + 24, 380, ckr.getDescription(), "Shown in UI");
    }

    private void initCustomRequirement(CustomRequirement cur, int x, int y) {
        this.createField(x + 100, y, 260, cur.getTaskId(), "task_key");
        this.createField(x + 100, y + 24, 380, "", "Description");
        this.createField(x + 100, y + 48, 100, String.valueOf(cur.getMaxProgress()), "Max progress");
    }

    private void initStatisticRequirement(StatisticRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStatistic(), "minecraft:walk_one_cm");
        this.createField(x + 100, y + 24, 100, String.valueOf(sr.getTargetValue()), "Target value");
    }

    private void initEnergyRequirement(EnergyRequirement er, int x, int y) {
        this.createField(x + 100, y, 150, String.valueOf(er.getAmount()), "FE");
    }

    private void initFluidRequirement(FluidRequirement fr, int x, int y) {
        this.createField(x + 100, y, 280, fr.getFluidId(), "minecraft:water");
        this.createField(x + 100, y + 24, 100, String.valueOf(fr.getAmount()), "1000 = 1 bucket");
        this.createField(x + 100, y + 48, 380, fr.getNbt() != null ? fr.getNbt().toString() : "", "NBT (optional)");
    }

    private void initCurrencyRequirement(CurrencyRequirement cr, int x, int y) {
        this.createField(x + 100, y, 200, cr.getCurrencyId(), "coins");
        this.createField(x + 100, y + 24, 100, String.valueOf(cr.getAmount()), "Amount");
    }

    private void initEquipItemRequirement(EquipItemRequirement eir, int x, int y) {
        ArrayList<TempEquipmentData> tempData = new ArrayList<TempEquipmentData>();
        for (EquipmentSlotEntry entry : this.equipmentEntries) {
            tempData.add(new TempEquipmentData(entry.currentSlot, entry.itemField.m_94155_(), entry.nbtField.m_94155_(), entry.showNbt));
        }
        this.equipmentEntries.clear();
        int startY = y + 24;
        this.totalEquipmentEntries = tempData.isEmpty() ? eir.getEntries().size() : tempData.size();
        int scrollStartEntry = (int)(this.equipmentScrollOffset * (float)Math.max(0, tempData.isEmpty() ? eir.getEntries().size() : tempData.size()));
        if (!tempData.isEmpty()) {
            currentY = startY;
            int entryIndex = 0;
            for (TempEquipmentData data : tempData) {
                if (entryIndex >= scrollStartEntry && entryIndex < scrollStartEntry + 3) {
                    this.addEquipmentSlotEntry(x, currentY, data.slot, data.itemId, data.nbt, data.showNbt);
                    boolean isCustom = !Arrays.asList("HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND").contains(data.slot.toUpperCase());
                    int linesNeeded = isCustom && data.showNbt ? 3 : 2;
                    currentY += 24 * linesNeeded;
                }
                ++entryIndex;
            }
        } else {
            currentY = startY;
            int entryIndex = 0;
            for (EquipItemRequirement.EquipmentEntry entry : eir.getEntries()) {
                if (entryIndex >= scrollStartEntry && entryIndex < scrollStartEntry + 3) {
                    this.addEquipmentSlotEntry(x, currentY, entry.getSlotName(), entry.getItemId(), entry.getNbt() != null ? entry.getNbt().toString() : "", false);
                    boolean isCustom = !Arrays.asList("HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND").contains(entry.getSlotName().toUpperCase());
                    int linesNeeded = isCustom && entry.getNbt() != null ? 3 : 2;
                    currentY += 24 * linesNeeded;
                }
                ++entryIndex;
            }
        }
        if (this.equipmentEntries.isEmpty() && scrollStartEntry == 0) {
            this.addEquipmentSlotEntry(x, startY, "HEAD", "minecraft:", "", false);
        }
        int btnY = startY + Math.min(3, this.equipmentEntries.size()) * 24 * 2;
        this.addEquipmentBtn = Button.m_253074_((Component)Component.m_237113_((String)"+ Add Slot"), b -> {
            String newSlot = this.equipmentEntries.isEmpty() ? "HEAD" : "CHEST";
            this.addEquipmentSlotEntry(x, startY + this.equipmentEntries.size() * 24 * 2, newSlot, "minecraft:", "", false);
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }).m_252987_(x + 100, btnY, 80, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addEquipmentBtn);
    }

    private void addEquipmentSlotEntry(int x, int y, String initialSlot, String itemId, String nbtStr, boolean initialShowNbt) {
        int slotIndex;
        String[] slots = new String[]{"HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND", "CUSTOM"};
        boolean isCustom = !Arrays.asList("HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND").contains(initialSlot.toUpperCase());
        int n = slotIndex = isCustom ? 6 : Arrays.asList(slots).indexOf(initialSlot.toUpperCase());
        if (slotIndex == -1) {
            slotIndex = 0;
        }
        int[] currentIndex = new int[]{slotIndex};
        String[] customSlotValue = new String[]{isCustom ? initialSlot : ""};
        Button slotBtn = Button.m_253074_((Component)Component.m_237113_((String)this.formatSlotLabel(slots[currentIndex[0]])), b -> {
            currentIndex[0] = (currentIndex[0] + 1) % slots.length;
            b.m_93666_((Component)Component.m_237113_((String)this.formatSlotLabel(slots[currentIndex[0]])));
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                if (entry.slotBtn != b) continue;
                if (currentIndex[0] == 6) {
                    entry.isCustomSlot = true;
                    entry.currentSlot = entry.customSlotField.m_94155_().isEmpty() ? "CUSTOM" : entry.customSlotField.m_94155_();
                } else {
                    entry.isCustomSlot = false;
                    entry.currentSlot = slots[currentIndex[0]];
                }
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                break;
            }
        }).m_252987_(x + 100, y, 80, 18).m_253136_();
        EditBox customSlotField = new EditBox(this.f_96547_, x + 100, y + 24, 80, 18, (Component)Component.m_237113_((String)"Slot ID"));
        customSlotField.m_94144_(isCustom ? initialSlot : "");
        customSlotField.m_257771_((Component)Component.m_237113_((String)"curios:ring"));
        customSlotField.m_94199_(100);
        customSlotField.m_94194_(isCustom);
        customSlotField.m_94151_(val -> {
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                if (entry.customSlotField != customSlotField) continue;
                entry.currentSlot = val.isEmpty() ? "CUSTOM" : val;
                customSlotValue[0] = val;
                break;
            }
        });
        EditBox itemField = new EditBox(this.f_96547_, x + 185, y, 175, 18, (Component)Component.m_237113_((String)"Item ID"));
        itemField.m_94144_(itemId);
        itemField.m_257771_((Component)Component.m_237113_((String)"minecraft:diamond_helmet"));
        itemField.m_94199_(500);
        Button browseBtn = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udd0d"), b -> {
            String currentValue = itemField.m_94155_();
            this.f_96541_.m_91152_((Screen)new IconPickerScreen(this, currentValue.isEmpty() ? "minecraft:" : currentValue, newValue -> {
                itemField.m_94144_(newValue);
                this.f_96541_.m_91152_((Screen)this);
            }));
        }).m_252987_(x + 365, y, 20, 18).m_253136_();
        int nbtY = isCustom ? y + 48 : y + 24;
        EditBox nbtField = new EditBox(this.f_96547_, x + 185, nbtY, 200, 18, (Component)Component.m_237113_((String)"NBT"));
        nbtField.m_94144_(nbtStr);
        nbtField.m_257771_((Component)Component.m_237113_((String)"{Enchantments:[...]} (optional)"));
        nbtField.m_94199_(500);
        nbtField.m_94194_(initialShowNbt);
        Button toggleNbtBtn = Button.m_253074_((Component)Component.m_237113_((String)"NBT"), b -> {
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                if (entry.toggleNbtBtn != b) continue;
                entry.showNbt = !entry.showNbt;
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                break;
            }
        }).m_252987_(x + 390, y, 35, 18).m_253136_();
        Button removeBtn = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
            for (int i = 0; i < this.equipmentEntries.size(); ++i) {
                if (this.equipmentEntries.get((int)i).removeBtn != b) continue;
                this.equipmentEntries.remove(i);
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                break;
            }
        }).m_252987_(x + 430, y, 20, 18).m_253136_();
        EquipmentSlotEntry entry = new EquipmentSlotEntry(itemField, nbtField, customSlotField, slotBtn, removeBtn, toggleNbtBtn, isCustom ? initialSlot : slots[currentIndex[0]], isCustom);
        entry.showNbt = initialShowNbt;
        this.equipmentEntries.add(entry);
        this.m_142416_((GuiEventListener)slotBtn);
        this.m_142416_((GuiEventListener)customSlotField);
        this.m_142416_((GuiEventListener)itemField);
        this.m_142416_((GuiEventListener)browseBtn);
        this.m_142416_((GuiEventListener)nbtField);
        this.m_142416_((GuiEventListener)toggleNbtBtn);
        this.m_142416_((GuiEventListener)removeBtn);
    }

    private String formatSlotLabel(String slot) {
        return switch (slot) {
            case "HEAD" -> "\u26d1 Head";
            case "CHEST" -> "\ud83d\udee1 Chest";
            case "LEGS" -> "\ud83d\udc56 Legs";
            case "FEET" -> "\ud83d\udc62 Feet";
            case "MAINHAND" -> "\u2694 Main";
            case "OFFHAND" -> "\ud83d\udee1 Off";
            case "CUSTOM" -> "\u270f Custom";
            default -> slot;
        };
    }

    private void initGenericTriggerRequirement(GenericTriggerRequirement gtr, int x, int y) {
        int panelY = (this.f_96544_ - 250) / 2;
        Button helpBtn = Button.m_253074_((Component)Component.m_237113_((String)"?"), b -> this.f_96541_.m_91152_((Screen)new GenericTriggerHelpScreen(this))).m_252987_(x + 500 - 25, panelY + 10, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)helpBtn);
        Button loadExampleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Examples"), b -> this.f_96541_.m_91152_((Screen)new ExamplePickerScreen(this, example -> {
            this.applyExample(gtr, (String)example);
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }))).m_252987_(x + 500 - 105, panelY + 10, 75, 20).m_253136_();
        this.m_142416_((GuiEventListener)loadExampleBtn);
        EditBox triggerIdField = this.createField(x + 100, y, 260, gtr.getTriggerId(), "e.g., minecraft:placed_block");
        List<ResourceLocation> knownTriggers = TriggerListenerManager.getInstance().getKnownTriggerIds();
        if (!knownTriggers.isEmpty()) {
            Button pickBtn = Button.m_253074_((Component)Component.m_237113_((String)"Pick"), b -> this.f_96541_.m_91152_((Screen)new TriggerPickerScreen(this, selected -> {
                try {
                    Field triggerIdFieldRef = GenericTriggerRequirement.class.getDeclaredField("triggerId");
                    triggerIdFieldRef.setAccessible(true);
                    triggerIdFieldRef.set(gtr, selected);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }))).m_252987_(x + 370, y, 50, 20).m_253136_();
            this.m_142416_((GuiEventListener)pickBtn);
        }
        Button modeBtn = Button.m_253074_((Component)Component.m_237113_((String)("Mode: " + (this.isAdvancedMode ? "JSON" : "Simple"))), b -> {
            boolean bl = this.isAdvancedMode = !this.isAdvancedMode;
            if (this.isAdvancedMode) {
                String json = this.buildJsonFromEntries();
                try {
                    Field conditionsField = GenericTriggerRequirement.class.getDeclaredField("conditions");
                    conditionsField.setAccessible(true);
                    conditionsField.set(gtr, JsonParser.parseString((String)json).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            } else {
                String jsonStr = this.getFieldValue(1);
                if (this.canParseToSimple(jsonStr)) {
                    try {
                        Field conditionsField = GenericTriggerRequirement.class.getDeclaredField("conditions");
                        conditionsField.setAccessible(true);
                        conditionsField.set(gtr, JsonParser.parseString((String)jsonStr).getAsJsonObject());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                } else {
                    this.isAdvancedMode = true;
                }
            }
        }).m_252987_(x + 100, y + 24, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)modeBtn);
        if (this.isAdvancedMode) {
            EditBox editBox = this.createField(x + 100, y + 24, 380, gtr.getConditions().toString(), "{\"block\": \"minecraft:stone\"}");
        } else {
            int startY;
            if (this.conditionEntries.isEmpty() && !gtr.getConditions().entrySet().isEmpty()) {
                this.parseJsonToEntries(gtr.getConditions(), x, y);
            }
            int currentY = startY = y + 48;
            if (this.conditionEntries.isEmpty()) {
                // empty if block
            }
            for (ConditionEntry entry : this.conditionEntries) {
                entry.keyField.m_257771_((Component)Component.m_237113_((String)"property (e.g., block, item)"));
                entry.valueField.m_257771_((Component)Component.m_237113_((String)"expected value"));
                this.m_142416_((GuiEventListener)entry.keyField);
                this.m_142416_((GuiEventListener)entry.valueField);
                this.m_142416_((GuiEventListener)entry.removeBtn);
                entry.keyField.m_252865_(x + 100);
                entry.keyField.m_253211_(currentY);
                entry.valueField.m_252865_(x + 230);
                entry.valueField.m_253211_(currentY);
                entry.removeBtn.m_252865_(x + 360);
                entry.removeBtn.m_253211_(currentY);
                currentY += 24;
            }
            this.addConditionBtn = Button.m_253074_((Component)Component.m_237113_((String)"+ Add"), b -> {
                int newY = startY + this.conditionEntries.size() * 24;
                this.addConditionEntry(x, newY);
            }).m_252987_(x + 100, currentY, 60, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.addConditionBtn);
        }
    }

    private void applyExample(GenericTriggerRequirement gtr, String exampleType) {
        try {
            Field triggerField = GenericTriggerRequirement.class.getDeclaredField("triggerId");
            Field conditionsField = GenericTriggerRequirement.class.getDeclaredField("conditions");
            triggerField.setAccessible(true);
            conditionsField.setAccessible(true);
            JsonObject conditions = new JsonObject();
            switch (exampleType) {
                case "Place Block": {
                    triggerField.set(gtr, "minecraft:placed_block");
                    conditions.addProperty("block", "minecraft:stone");
                    break;
                }
                case "Use Item": {
                    triggerField.set(gtr, "minecraft:item_used_on_block");
                    conditions.addProperty("item", "minecraft:diamond_pickaxe");
                    break;
                }
                case "Kill Entity": {
                    triggerField.set(gtr, "minecraft:player_killed_entity");
                    JsonObject entity = new JsonObject();
                    entity.addProperty("type", "minecraft:zombie");
                    conditions.add("entity", (JsonElement)entity);
                    break;
                }
                case "Enter Structure": {
                    triggerField.set(gtr, "minecraft:location");
                    JsonObject location = new JsonObject();
                    location.addProperty("structure", "minecraft:village");
                    conditions.add("location", (JsonElement)location);
                    break;
                }
                case "Clear": {
                    conditions = new JsonObject();
                }
            }
            conditionsField.set(gtr, conditions);
            this.conditionEntries.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConditionEntry(int x, int y) {
        EditBox key = new EditBox(this.f_96547_, x + 100, y, 120, 18, (Component)Component.m_237113_((String)"Property"));
        key.m_257771_((Component)Component.m_237113_((String)"block, item, entity..."));
        EditBox value = new EditBox(this.f_96547_, x + 230, y, 120, 18, (Component)Component.m_237113_((String)"Value"));
        value.m_257771_((Component)Component.m_237113_((String)"expected value"));
        Button remove = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
            this.conditionEntries.removeIf(e -> e.removeBtn == b);
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }).m_252987_(x + 360, y, 20, 18).m_253136_();
        this.conditionEntries.add(new ConditionEntry(key, value, remove));
        this.m_142416_((GuiEventListener)key);
        this.m_142416_((GuiEventListener)value);
        this.m_142416_((GuiEventListener)remove);
        if (this.addConditionBtn != null) {
            this.addConditionBtn.m_253211_(y + 24);
        }
    }

    private void parseJsonToEntries(JsonObject json, int x, int y) {
        this.conditionEntries.clear();
        for (String key : json.keySet()) {
            Button r;
            EditBox v;
            EditBox k;
            JsonElement el = json.get(key);
            if (el.isJsonPrimitive()) {
                k = new EditBox(this.f_96547_, 0, 0, 120, 18, (Component)Component.m_237113_((String)"Property"));
                k.m_94144_(key);
                k.m_257771_((Component)Component.m_237113_((String)"block, item, entity..."));
                v = new EditBox(this.f_96547_, 0, 0, 120, 18, (Component)Component.m_237113_((String)"Value"));
                v.m_94144_(el.getAsString());
                v.m_257771_((Component)Component.m_237113_((String)"expected value"));
                r = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
                    this.conditionEntries.removeIf(e -> e.removeBtn == b);
                    this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                }).m_252987_(0, 0, 20, 18).m_253136_();
                this.conditionEntries.add(new ConditionEntry(k, v, r));
                continue;
            }
            k = new EditBox(this.f_96547_, 0, 0, 120, 18, (Component)Component.m_237113_((String)"Property"));
            k.m_94144_(key);
            k.m_257771_((Component)Component.m_237113_((String)"block, item, entity..."));
            v = new EditBox(this.f_96547_, 0, 0, 120, 18, (Component)Component.m_237113_((String)"Value"));
            v.m_94144_(el.toString());
            v.m_257771_((Component)Component.m_237113_((String)"expected value"));
            r = Button.m_253074_((Component)Component.m_237113_((String)"X"), b -> {
                this.conditionEntries.removeIf(e -> e.removeBtn == b);
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }).m_252987_(0, 0, 20, 18).m_253136_();
            this.conditionEntries.add(new ConditionEntry(k, v, r));
        }
    }

    private String buildJsonFromEntries() {
        JsonObject json = new JsonObject();
        for (ConditionEntry entry : this.conditionEntries) {
            String k = entry.keyField.m_94155_();
            String v = entry.valueField.m_94155_();
            if (k.isBlank()) continue;
            if (v.equalsIgnoreCase("true")) {
                json.addProperty(k, Boolean.valueOf(true));
                continue;
            }
            if (v.equalsIgnoreCase("false")) {
                json.addProperty(k, Boolean.valueOf(false));
                continue;
            }
            try {
                if (v.contains(".")) {
                    json.addProperty(k, (Number)Double.parseDouble(v));
                    continue;
                }
                json.addProperty(k, (Number)Long.parseLong(v));
            }
            catch (NumberFormatException e) {
                json.addProperty(k, v);
            }
        }
        return json.toString();
    }

    private boolean canParseToSimple(String jsonStr) {
        try {
            JsonObject json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Button createToggleButton(String label, boolean initialState, int x, int y) {
        return this.createToggleButton(label, initialState, "Yes", "No", x, y);
    }

    private Button createToggleButton(String label, boolean initialState, String trueText, String falseText, int x, int y) {
        Button btn = Button.m_253074_((Component)Component.m_237113_((String)(label + ": " + (initialState ? trueText : falseText))), b -> {
            this.toggleState = !this.toggleState;
            b.m_93666_((Component)Component.m_237113_((String)(label + ": " + (this.toggleState ? trueText : falseText))));
        }).m_252987_(x, y, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)btn);
        return btn;
    }

    private Button createCycleButton(String label, String initialValue, String[] options, int x, int y) {
        int[] indexRef = new int[]{this.findIndex(options, initialValue)};
        Button btn = Button.m_253074_((Component)Component.m_237113_((String)(label + ": " + options[indexRef[0]])), b -> {
            indexRef[0] = (indexRef[0] + 1) % options.length;
            this.tempCycleValue = options[indexRef[0]];
            b.m_93666_((Component)Component.m_237113_((String)(label + ": " + this.tempCycleValue)));
        }).m_252987_(x, y, 130, 20).m_253136_();
        this.m_142416_((GuiEventListener)btn);
        return btn;
    }

    private int findIndex(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        return 0;
    }

    private void initControlButtons(int panelX) {
        int btnY = this.f_96544_ / 2 + 100;
        this.saveBtn = Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(panelX + 500 - 140, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.cancelBtn = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(panelX + 500 - 70, btnY, 60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelBtn);
    }

    private void save() {
        try {
            Requirement updated = this.buildUpdatedRequirement();
            if (updated != null) {
                this.onSave.accept(updated);
                this.m_7522_(null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Requirement buildUpdatedRequirement() {
        Requirement tr;
        if (this.requirement instanceof ItemRequirement) {
            ItemRequirement ir = new ItemRequirement(this.getFieldValue(0), this.parseInt(1));
            ir.setConsume(this.toggleState);
            return ir;
        }
        if (this.requirement instanceof EntityKillRequirement) {
            return new EntityKillRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        Requirement ir = this.requirement;
        if (ir instanceof LocationRequirement) {
            LocationRequirement lr = (LocationRequirement)ir;
            lr.setX(this.parseInt(0));
            lr.setY(this.parseInt(1));
            lr.setZ(this.parseInt(2));
            lr.setRange(this.parseInt(3));
            return lr;
        }
        ir = this.requirement;
        if (ir instanceof XpRequirement) {
            XpRequirement xr = (XpRequirement)ir;
            xr.setAmount(this.parseLong(0));
            xr.setLevels(this.toggleState);
            return xr;
        }
        if (this.requirement instanceof CraftingRequirement) {
            return new CraftingRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        ir = this.requirement;
        if (ir instanceof StageRequirement) {
            StageRequirement sr = (StageRequirement)ir;
            sr.setStage(this.getFieldValue(0));
            return sr;
        }
        ir = this.requirement;
        if (ir instanceof ObservationRequirement) {
            ObservationRequirement or = (ObservationRequirement)ir;
            or.setTargetId(this.getFieldValue(0));
            or.setTimer(this.parseInt(1));
            or.setObserveType(this.tempCycleValue != null ? this.tempCycleValue : "entity");
            return or;
        }
        ir = this.requirement;
        if (ir instanceof StructureRequirement) {
            StructureRequirement sr = (StructureRequirement)ir;
            sr.setStructureId(this.getFieldValue(0));
            return sr;
        }
        if (this.requirement instanceof RegionRequirement) {
            return new RegionRequirement(this.getFieldValue(0), this.parseInt(1), this.parseInt(2), this.parseInt(3), this.parseInt(4), this.parseInt(5), this.parseInt(6));
        }
        if (this.requirement instanceof ItemTagRequirement) {
            tr = new ItemTagRequirement(this.getFieldValue(0), this.parseInt(1));
            ((ItemTagRequirement)tr).setConsume(this.toggleState);
            return tr;
        }
        if (this.requirement instanceof AdvancementRequirement) {
            return new AdvancementRequirement(this.getFieldValue(0));
        }
        tr = this.requirement;
        if (tr instanceof BiomeRequirement) {
            BiomeRequirement br = (BiomeRequirement)tr;
            br.setBiomeId(this.getFieldValue(0));
            return br;
        }
        tr = this.requirement;
        if (tr instanceof DimensionRequirement) {
            DimensionRequirement dr = (DimensionRequirement)tr;
            dr.setDimensionId(this.getFieldValue(0));
            return dr;
        }
        if (this.requirement instanceof WeatherRequirement) {
            String modeStr = this.tempCycleValue != null ? this.tempCycleValue : "CLEAR";
            WeatherRequirement.Mode mode = WeatherRequirement.Mode.valueOf(modeStr);
            return new WeatherRequirement(mode);
        }
        if (this.requirement instanceof TimeRequirement) {
            return new TimeRequirement(this.parseLong(0), this.parseLong(1));
        }
        if (this.requirement instanceof CommandRequirement) {
            return new CommandRequirement(this.getFieldValue(0), this.getFieldValue(1));
        }
        if (this.requirement instanceof CheckmarkRequirement) {
            return new CheckmarkRequirement(this.getFieldValue(0), this.getFieldValue(1));
        }
        if (this.requirement instanceof CustomRequirement) {
            return new CustomRequirement(this.getFieldValue(0), this.getFieldValue(1), this.parseLong(2));
        }
        if (this.requirement instanceof StatisticRequirement) {
            return new StatisticRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        if (this.requirement instanceof EnergyRequirement) {
            return new EnergyRequirement(this.parseLong(0));
        }
        if (this.requirement instanceof FluidRequirement) {
            FluidRequirement fr = new FluidRequirement(this.getFieldValue(0), this.parseLong(1));
            String nbt = this.getFieldValue(2);
            if (!nbt.isBlank()) {
                try {
                    fr.setNbt(TagParser.m_129359_((String)nbt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fr;
        }
        if (this.requirement instanceof CurrencyRequirement) {
            return new CurrencyRequirement(this.getFieldValue(0), this.parseLong(1));
        }
        if (this.requirement instanceof GenericTriggerRequirement) {
            JsonObject conditions;
            String triggerId = this.getFieldValue(0);
            if (this.isAdvancedMode) {
                String jsonStr = this.getFieldValue(1);
                try {
                    conditions = JsonParser.parseString((String)jsonStr).getAsJsonObject();
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                conditions = new JsonObject();
                for (ConditionEntry entry : this.conditionEntries) {
                    String k = entry.keyField.m_94155_();
                    String v = entry.valueField.m_94155_();
                    if (k.isBlank()) continue;
                    if (v.equalsIgnoreCase("true")) {
                        conditions.addProperty(k, Boolean.valueOf(true));
                        continue;
                    }
                    if (v.equalsIgnoreCase("false")) {
                        conditions.addProperty(k, Boolean.valueOf(false));
                        continue;
                    }
                    try {
                        if (v.contains(".")) {
                            conditions.addProperty(k, (Number)Double.parseDouble(v));
                            continue;
                        }
                        conditions.addProperty(k, (Number)Long.parseLong(v));
                    }
                    catch (NumberFormatException e) {
                        conditions.addProperty(k, v);
                    }
                }
            }
            return new GenericTriggerRequirement(triggerId, conditions);
        }
        if (this.requirement instanceof EquipItemRequirement) {
            EquipItemRequirement eir = new EquipItemRequirement();
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                EquipItemRequirement.EquipmentEntry equipEntry = new EquipItemRequirement.EquipmentEntry(entry.currentSlot, entry.itemField.m_94155_());
                String nbt = entry.nbtField.m_94155_().trim();
                if (!nbt.isBlank()) {
                    try {
                        equipEntry.setNbt(TagParser.m_129359_((String)nbt));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                eir.addEntry(equipEntry);
            }
            return eir;
        }
        return this.requirement;
    }

    private String getFieldValue(int index) {
        return this.fields.get(index).m_94155_().trim();
    }

    private int parseInt(int index) {
        return Integer.parseInt(this.getFieldValue(index));
    }

    private long parseLong(int index) {
        return Long.parseLong(this.getFieldValue(index));
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelX = (this.f_96543_ - 500) / 2;
        int panelY = (this.f_96544_ - 250) / 2;
        g.m_280509_(panelX, panelY, panelX + 500, panelY + 250, -535818224);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, panelY + 12, -1);
        this.renderLabels(g, panelX, panelY + 40);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderLabels(GuiGraphics g, int x, int y) {
        if (this.requirement instanceof ItemRequirement) {
            this.drawLabel(g, "Item ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Consume:", x, y + 48);
        } else if (this.requirement instanceof EntityKillRequirement) {
            this.drawLabel(g, "Entity ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
        } else if (this.requirement instanceof LocationRequirement) {
            this.drawLabel(g, "X:", x, y);
            this.drawLabel(g, "Y:", x + 110, y);
            this.drawLabel(g, "Z:", x + 220, y);
            this.drawLabel(g, "Radius:", x, y + 24);
        } else if (this.requirement instanceof XpRequirement) {
            this.drawLabel(g, "Amount:", x, y);
        } else if (this.requirement instanceof CraftingRequirement) {
            this.drawLabel(g, "Item ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
        } else if (this.requirement instanceof StageRequirement) {
            this.drawLabel(g, "Stage Name:", x, y);
        } else if (this.requirement instanceof ObservationRequirement) {
            this.drawLabel(g, "Target ID:", x, y);
            this.drawLabel(g, "Timer (ticks):", x, y + 24);
        } else if (this.requirement instanceof StructureRequirement) {
            this.drawLabel(g, "Structure:", x, y);
        } else if (this.requirement instanceof RegionRequirement) {
            this.drawLabel(g, "Dimension:", x, y);
            this.drawLabel(g, "x1:", x, y + 24);
            this.drawLabel(g, "y1:", x + 134, y + 24);
            this.drawLabel(g, "z1:", x + 198, y + 24);
            this.drawLabel(g, "x2:", x, y + 48);
            this.drawLabel(g, "y2:", x + 134, y + 48);
            this.drawLabel(g, "z2:", x + 198, y + 48);
        } else if (this.requirement instanceof ItemTagRequirement) {
            this.drawLabel(g, "Tag:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Consume:", x, y + 48);
        } else if (this.requirement instanceof AdvancementRequirement) {
            this.drawLabel(g, "Advancement ID:", x, y);
        } else if (this.requirement instanceof BiomeRequirement) {
            this.drawLabel(g, "Biome or Tag:", x, y);
        } else if (this.requirement instanceof DimensionRequirement) {
            this.drawLabel(g, "Dimension ID:", x, y);
        } else if (this.requirement instanceof WeatherRequirement) {
            this.drawLabel(g, "Weather Mode:", x, y);
        } else if (this.requirement instanceof TimeRequirement) {
            this.drawLabel(g, "Start:", x, y);
            this.drawLabel(g, "End:", x + 200, y);
        } else if (this.requirement instanceof CommandRequirement) {
            this.drawLabel(g, "Command ID:", x, y);
            this.drawLabel(g, "Description:", x, y + 24);
        } else if (this.requirement instanceof CustomRequirement) {
            this.drawLabel(g, "Task ID:", x, y);
            this.drawLabel(g, "Description:", x, y + 24);
            this.drawLabel(g, "Max:", x, y + 48);
        } else if (this.requirement instanceof StatisticRequirement) {
            this.drawLabel(g, "Statistic:", x, y);
            this.drawLabel(g, "Target:", x, y + 24);
        } else if (this.requirement instanceof EnergyRequirement) {
            this.drawLabel(g, "Amount (FE):", x, y);
        } else if (this.requirement instanceof FluidRequirement) {
            this.drawLabel(g, "Fluid ID:", x, y);
            this.drawLabel(g, "Amount (mB):", x, y + 24);
            this.drawLabel(g, "NBT:", x, y + 48);
        } else if (this.requirement instanceof CurrencyRequirement) {
            this.drawLabel(g, "Currency ID:", x, y);
            this.drawLabel(g, "Amount:", x, y + 24);
        } else if (this.requirement instanceof GenericTriggerRequirement) {
            this.drawLabel(g, "Trigger ID:", x, y);
            g.m_280488_(this.f_96547_, "(?)", x + 70, y + 5, 0x888888);
            if (this.isAdvancedMode) {
                this.drawLabel(g, "Conditions (JSON):", x, y + 24);
                if (this.fields.size() > 1) {
                    String jsonStr = this.fields.get(1).m_94155_();
                    boolean valid = this.isValidJson(jsonStr);
                    String indicator = valid ? "\u2713 Valid" : "\u2717 Invalid JSON";
                    int color = valid ? 0x55FF55 : 0xFF5555;
                    g.m_280488_(this.f_96547_, indicator, x + 400, y + 24 + 5, color);
                }
            } else {
                this.drawLabel(g, "Conditions:", x, y + 24);
                if (this.conditionEntries.isEmpty()) {
                    g.m_280488_(this.f_96547_, "(empty = triggers on any occurrence)", x + 100, y + 48 + 5, 0x888888);
                }
            }
        } else if (this.requirement instanceof EquipItemRequirement) {
            this.drawLabel(g, "Equipment Slots:", x, y);
        }
    }

    private void drawLabel(GuiGraphics g, String text, int x, int y) {
        g.m_280488_(this.f_96547_, text, x + 12, y + 5, -1);
    }

    private boolean isValidJson(String jsonStr) {
        if (jsonStr == null || jsonStr.trim().isEmpty()) {
            return true;
        }
        try {
            JsonParser.parseString((String)jsonStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.requirement instanceof EquipItemRequirement && this.totalEquipmentEntries > 3) {
            int maxScroll = this.totalEquipmentEntries - 3;
            float scrollStep = 1.0f / (float)maxScroll;
            this.equipmentScrollOffset = Math.max(0.0f, Math.min(1.0f, this.equipmentScrollOffset - (float)delta * scrollStep));
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class EquipmentSlotEntry {
        EditBox itemField;
        EditBox nbtField;
        EditBox customSlotField;
        Button slotBtn;
        Button removeBtn;
        Button toggleNbtBtn;
        String currentSlot;
        boolean showNbt;
        boolean isCustomSlot;

        EquipmentSlotEntry(EditBox item, EditBox nbt, EditBox customSlot, Button slot, Button remove, Button toggleNbt, String initialSlot, boolean isCustom) {
            this.itemField = item;
            this.nbtField = nbt;
            this.customSlotField = customSlot;
            this.slotBtn = slot;
            this.removeBtn = remove;
            this.toggleNbtBtn = toggleNbt;
            this.currentSlot = initialSlot;
            this.showNbt = false;
            this.isCustomSlot = isCustom;
        }
    }

    private static class TempEquipmentData {
        String slot;
        String itemId;
        String nbt;
        boolean showNbt;

        TempEquipmentData(String slot, String itemId, String nbt, boolean showNbt) {
            this.slot = slot;
            this.itemId = itemId;
            this.nbt = nbt;
            this.showNbt = showNbt;
        }
    }

    private static class ConditionEntry {
        EditBox keyField;
        EditBox valueField;
        Button removeBtn;

        ConditionEntry(EditBox key, EditBox value, Button remove) {
            this.keyField = key;
            this.valueField = value;
            this.removeBtn = remove;
        }
    }
}

