/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;

public class FieldValidation {
    private final Map<String, ValidationRule> rules = new HashMap<String, ValidationRule>();
    private final Map<String, String> errors = new HashMap<String, String>();

    public void addRule(String fieldId, ValidationRule rule) {
        this.rules.put(fieldId, rule);
    }

    public boolean validate(String fieldId, String value) {
        ValidationRule rule = this.rules.get(fieldId);
        if (rule == null) {
            this.errors.remove(fieldId);
            return true;
        }
        String error = rule.validate(value);
        if (error == null) {
            this.errors.remove(fieldId);
            return true;
        }
        this.errors.put(fieldId, error);
        return false;
    }

    public boolean hasError(String fieldId) {
        return this.errors.containsKey(fieldId);
    }

    public String getError(String fieldId) {
        return this.errors.get(fieldId);
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public void clearError(String fieldId) {
        this.errors.remove(fieldId);
    }

    public boolean hasAnyErrors() {
        return !this.errors.isEmpty();
    }

    public Map<String, String> getAllErrors() {
        return new HashMap<String, String>(this.errors);
    }

    public void renderFieldIndicator(GuiGraphics graphics, Font font, EditBox field, String fieldId, int mouseX, int mouseY) {
        if (!this.hasError(fieldId)) {
            return;
        }
        int x = field.m_252754_() - 1;
        int y = field.m_252907_() - 1;
        int w = field.m_5711_() + 2;
        int h = field.m_93694_() + 2;
        graphics.m_280509_(x, y, x + w, y + 1, -43691);
        graphics.m_280509_(x, y + h - 1, x + w, y + h, -43691);
        graphics.m_280509_(x, y, x + 1, y + h, -43691);
        graphics.m_280509_(x + w - 1, y, x + w, y + h, -43691);
        int iconX = x + w + 4;
        Objects.requireNonNull(font);
        int iconY = y + (h - 9) / 2;
        graphics.m_280056_(font, "\u26a0", iconX, iconY, -22016, false);
        if (mouseX >= x && mouseX <= x + w + 20 && mouseY >= y && mouseY <= y + h) {
            this.renderErrorTooltip(graphics, font, this.getError(fieldId), mouseX, mouseY);
        }
    }

    private void renderErrorTooltip(GuiGraphics graphics, Font font, String error, int mouseX, int mouseY) {
        if (error == null || error.isEmpty()) {
            return;
        }
        int tooltipW = font.m_92895_(error) + 8;
        Objects.requireNonNull(font);
        int tooltipH = 9 + 6;
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - tooltipH / 2;
        graphics.m_280509_(tooltipX, tooltipY, tooltipX + tooltipW, tooltipY + tooltipH, -268435456);
        graphics.m_280509_(tooltipX, tooltipY, tooltipX + tooltipW, tooltipY + 1, -43691);
        graphics.m_280056_(font, error, tooltipX + 4, tooltipY + 3, -1, false);
    }

    @FunctionalInterface
    public static interface ValidationRule {
        public String validate(String var1);
    }

    public static class Rules {
        public static ValidationRule notEmpty() {
            return value -> value == null || value.trim().isEmpty() ? "Field cannot be empty" : null;
        }

        public static ValidationRule maxLength(int max) {
            return value -> value != null && value.length() > max ? "Maximum length: " + max + " characters" : null;
        }

        public static ValidationRule minLength(int min) {
            return value -> value != null && !value.isEmpty() && value.length() < min ? "Minimum length: " + min + " characters" : null;
        }

        public static ValidationRule numeric() {
            return value -> {
                if (value == null || value.trim().isEmpty()) {
                    return null;
                }
                try {
                    Integer.parseInt(value.trim());
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Must be a number";
                }
            };
        }

        public static ValidationRule range(int min, int max) {
            return value -> {
                if (value == null || value.trim().isEmpty()) {
                    return null;
                }
                try {
                    int num = Integer.parseInt(value.trim());
                    if (num < min || num > max) {
                        return "Must be between " + min + " and " + max;
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Must be a number";
                }
            };
        }

        public static ValidationRule pattern(String regex, String errorMessage) {
            return value -> {
                if (value == null || value.trim().isEmpty()) {
                    return null;
                }
                return value.matches(regex) ? null : errorMessage;
            };
        }

        public static ValidationRule custom(Function<String, Boolean> validator, String errorMessage) {
            return value -> (Boolean)validator.apply(value) != false ? null : errorMessage;
        }

        public static ValidationRule combine(ValidationRule ... rules) {
            return value -> {
                for (ValidationRule rule : rules) {
                    String error = rule.validate(value);
                    if (error == null) continue;
                    return error;
                }
                return null;
            };
        }
    }
}

