/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.forge.integration;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.events.QuestEvents;
import org.texboobcat.questory.integration.GameStagesHelper;

public class GameStagesIntegrationForge
extends GameStagesHelper {
    private final boolean loaded = ModList.get().isLoaded("gamestages");
    private Class<?> gameStageHelperClass;
    private Method hasStageMethod;
    private Method addStageMethod;
    private Method removeStageMethod;
    private Method getStagesMethod;

    public GameStagesIntegrationForge() {
        if (this.loaded) {
            try {
                this.initializeReflection();
                this.registerEventListeners();
                Questory.LOGGER.info("[Questory] GameStages integration enabled (Forge)");
            }
            catch (Throwable e) {
                Questory.LOGGER.error("[Questory] Failed to initialize GameStages integration: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            Questory.LOGGER.info("[Questory] GameStages not found - stage features disabled");
        }
    }

    private void initializeReflection() throws Exception {
        this.gameStageHelperClass = Class.forName("net.darkhax.gamestages.GameStageHelper");
        this.hasStageMethod = this.gameStageHelperClass.getMethod("hasStage", Player.class, String.class);
        this.addStageMethod = this.gameStageHelperClass.getMethod("addStage", Player.class, String.class);
        this.removeStageMethod = this.gameStageHelperClass.getMethod("removeStage", Player.class, String.class);
        this.getStagesMethod = this.gameStageHelperClass.getMethod("getStages", Player.class);
    }

    private void registerEventListeners() {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new GameStagesEventHandler());
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Failed to register GameStages event handlers: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public boolean isGameStagesLoaded() {
        return this.loaded && this.gameStageHelperClass != null;
    }

    @Override
    public boolean hasStage(ServerPlayer player, String stage) {
        if (!this.isGameStagesLoaded()) {
            return false;
        }
        try {
            return (Boolean)this.hasStageMethod.invoke(null, player, stage);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error checking stage '{}': {}", (Object)stage, (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public void addStage(ServerPlayer player, String stage) {
        if (!this.isGameStagesLoaded()) {
            return;
        }
        try {
            this.addStageMethod.invoke(null, player, stage);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error adding stage '{}': {}", (Object)stage, (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void removeStage(ServerPlayer player, String stage) {
        if (!this.isGameStagesLoaded()) {
            return;
        }
        try {
            this.removeStageMethod.invoke(null, player, stage);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error removing stage '{}': {}", (Object)stage, (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public Collection<String> getStages(ServerPlayer player) {
        if (!this.isGameStagesLoaded()) {
            return Collections.emptyList();
        }
        try {
            return (Collection)this.getStagesMethod.invoke(null, player);
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Error getting stages: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    public static class GameStagesEventHandler {
        @SubscribeEvent
        public void onGameStageEvent(Event event) {
            try {
                String eventClassName = event.getClass().getName();
                if (eventClassName.contains("GameStageEvent$Added")) {
                    this.handleStageAdded(event);
                } else if (eventClassName.contains("GameStageEvent$Removed")) {
                    this.handleStageRemoved(event);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void handleStageAdded(Event event) {
            try {
                Method getEntityMethod = event.getClass().getMethod("getEntity", new Class[0]);
                Method getStageNameMethod = event.getClass().getMethod("getStageName", new Class[0]);
                Object entity = getEntityMethod.invoke((Object)event, new Object[0]);
                String stageName = (String)getStageNameMethod.invoke((Object)event, new Object[0]);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    this.updateStageRequirements(player, stageName, true);
                }
            }
            catch (Throwable e) {
                Questory.LOGGER.error("[Questory] Error handling stage added event: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        private void handleStageRemoved(Event event) {
            try {
                Method getEntityMethod = event.getClass().getMethod("getEntity", new Class[0]);
                Method getStageNameMethod = event.getClass().getMethod("getStageName", new Class[0]);
                Object entity = getEntityMethod.invoke((Object)event, new Object[0]);
                String stageName = (String)getStageNameMethod.invoke((Object)event, new Object[0]);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    this.updateStageRequirements(player, stageName, false);
                }
            }
            catch (Throwable e) {
                Questory.LOGGER.error("[Questory] Error handling stage removed event: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        private void updateStageRequirements(ServerPlayer player, String stage, boolean has) {
            try {
                QuestEvents.onStageChanged(player, stage, has);
            }
            catch (Throwable e) {
                Questory.LOGGER.error("[Questory] Error updating stage requirements: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

