/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterDataUpdateRequestPacket {
    private static final Gson GSON = new Gson();
    private final String chapterJson;

    public ChapterDataUpdateRequestPacket(String chapterJson) {
        this.chapterJson = chapterJson;
    }

    public static void encode(ChapterDataUpdateRequestPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.chapterJson);
    }

    public static ChapterDataUpdateRequestPacket decode(FriendlyByteBuf buf) {
        return new ChapterDataUpdateRequestPacket(buf.m_130277_());
    }

    public void handle(ServerPlayer player) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.enableAdvancedEditor) {
            return;
        }
        if (cfg.advancedEditorRequiresOp && !player.m_20310_(cfg.adminPermissionLevel)) {
            return;
        }
        try {
            JsonObject json = (JsonObject)GSON.fromJson(this.chapterJson, JsonObject.class);
            ChapterData cd = ChapterData.fromJson(json);
            QuestManager qm = QuestManager.getInstance();
            qm.updateChapterData(cd);
            List allPlayers = player.f_8924_.m_6846_().m_11314_();
            ArrayList<ChapterData> chapters = new ArrayList<ChapterData>(qm.getAllChapters());
            for (ServerPlayer p : allPlayers) {
                NetworkManager.sendToClient(p, new ChapterDataSyncPacket(chapters));
            }
            player.m_213846_((Component)Component.m_237113_((String)("Saved chapter: " + cd.getTitle())));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("Failed to save chapter: " + e.getMessage())));
        }
    }
}

