/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.quest.Quest;

public class QuestDeleteRequestPacket {
    private final String questId;

    public QuestDeleteRequestPacket(String questId) {
        this.questId = questId;
    }

    public static void encode(QuestDeleteRequestPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.questId);
    }

    public static QuestDeleteRequestPacket decode(FriendlyByteBuf buf) {
        return new QuestDeleteRequestPacket(buf.m_130277_());
    }

    public void handle(ServerPlayer player) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.enableAdvancedEditor) {
            return;
        }
        if (cfg.advancedEditorRequiresOp && !player.m_20310_(cfg.adminPermissionLevel)) {
            return;
        }
        try {
            QuestManager qm = QuestManager.getInstance();
            qm.unregisterQuest(this.questId);
            List list = player.f_8924_.m_6846_().m_11314_();
            ArrayList<Quest> all = new ArrayList<Quest>(qm.getAllQuests());
            for (ServerPlayer p : list) {
                NetworkManager.sendToClient(p, new QuestSyncPacket(all));
            }
            player.m_213846_((Component)Component.m_237113_((String)("Deleted quest: " + this.questId)));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("Failed to delete quest: " + e.getMessage())));
        }
    }
}

