/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import org.texboobcat.questory.telemetry.TelemetryManager;

public class QuestTelemetryPacket {
    private final String questId;
    private final long completionTimeMs;
    private final TelemetryEventType eventType;

    public QuestTelemetryPacket(String questId, long completionTimeMs, TelemetryEventType eventType) {
        this.questId = questId;
        this.completionTimeMs = completionTimeMs;
        this.eventType = eventType;
    }

    public static void encode(QuestTelemetryPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.questId);
        buf.writeLong(packet.completionTimeMs);
        buf.m_130068_((Enum)packet.eventType);
    }

    public static QuestTelemetryPacket decode(FriendlyByteBuf buf) {
        String questId = buf.m_130277_();
        long completionTimeMs = buf.readLong();
        TelemetryEventType eventType = (TelemetryEventType)buf.m_130066_(TelemetryEventType.class);
        return new QuestTelemetryPacket(questId, completionTimeMs, eventType);
    }

    public void handle() {
        Minecraft.m_91087_().execute(() -> {
            try {
                TelemetryManager tm = TelemetryManager.getInstance();
                switch (this.eventType.ordinal()) {
                    case 0: {
                        tm.trackQuestCompleted(this.questId, this.completionTimeMs);
                        break;
                    }
                    case 1: {
                        tm.trackQuestViewed(this.questId);
                        break;
                    }
                    case 2: {
                        tm.trackQuestOpened(this.questId);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public String getQuestId() {
        return this.questId;
    }

    public long getCompletionTimeMs() {
        return this.completionTimeMs;
    }

    public TelemetryEventType getEventType() {
        return this.eventType;
    }

    public static enum TelemetryEventType {
        QUEST_COMPLETED,
        QUEST_VIEWED,
        QUEST_OPENED;

    }
}

