/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.ITeamProvider;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class TeamActionPacket {
    private final Action action;
    private final String targetPlayerName;
    private final UUID teamId;

    private boolean isFtbProviderActive() {
        ITeamProvider active = TeamManager.getInstance().getActiveProvider();
        return active != null && "ftbteams".equals(active.getProviderId());
    }

    private void runAsPlayer(ServerPlayer player, String command) {
        try {
            MinecraftServer server = player.m_20194_();
            if (server != null) {
                server.m_129892_().m_230957_(player.m_20203_(), command);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TeamActionPacket(Action action, String targetPlayerName, UUID teamId) {
        this.action = action;
        this.targetPlayerName = targetPlayerName;
        this.teamId = teamId;
    }

    public static TeamActionPacket invite(String playerName) {
        return new TeamActionPacket(Action.INVITE, playerName, null);
    }

    public static TeamActionPacket accept(UUID teamId) {
        return new TeamActionPacket(Action.ACCEPT, null, teamId);
    }

    public static TeamActionPacket decline(UUID teamId) {
        return new TeamActionPacket(Action.DECLINE, null, teamId);
    }

    public static TeamActionPacket leave() {
        return new TeamActionPacket(Action.LEAVE, null, null);
    }

    public static TeamActionPacket kick(String playerName) {
        return new TeamActionPacket(Action.KICK, playerName, null);
    }

    public static void encode(TeamActionPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.action);
        buf.writeBoolean(packet.targetPlayerName != null);
        if (packet.targetPlayerName != null) {
            buf.m_130070_(packet.targetPlayerName);
        }
        buf.writeBoolean(packet.teamId != null);
        if (packet.teamId != null) {
            buf.m_130077_(packet.teamId);
        }
    }

    public static TeamActionPacket decode(FriendlyByteBuf buf) {
        Action action = (Action)buf.m_130066_(Action.class);
        String targetPlayerName = buf.readBoolean() ? buf.m_130277_() : null;
        UUID teamId = buf.readBoolean() ? buf.m_130259_() : null;
        return new TeamActionPacket(action, targetPlayerName, teamId);
    }

    public void handle(ServerPlayer player) {
        TeamManager teamMgr = TeamManager.getInstance();
        switch (this.action.ordinal()) {
            case 0: {
                this.handleInvite(player, teamMgr);
                break;
            }
            case 1: {
                this.handleAccept(player, teamMgr);
                break;
            }
            case 2: {
                this.handleDecline(player, teamMgr);
                break;
            }
            case 3: {
                this.handleLeave(player, teamMgr);
                break;
            }
            case 4: {
                this.handleKick(player, teamMgr);
            }
        }
    }

    private void handleInvite(ServerPlayer player, TeamManager teamMgr) {
        UUID myTeamId = teamMgr.getPlayerTeamId(player.m_20148_());
        if (myTeamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (this.isFtbProviderActive()) {
            if (this.targetPlayerName == null || this.targetPlayerName.isBlank()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] No target player specified"));
                return;
            }
            ServerPlayer target = player.m_20194_().m_6846_().m_11255_(this.targetPlayerName);
            this.runAsPlayer(player, "ftbteams party invite " + this.targetPlayerName);
            this.syncTeamToPlayer(player);
            if (target != null) {
                this.syncTeamToPlayer(target);
            }
            return;
        }
        if (!teamMgr.isTeamOwner(player.m_20148_(), myTeamId)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Only the team owner can invite players"));
            return;
        }
        ServerPlayer target = player.m_20194_().m_6846_().m_11255_(this.targetPlayerName);
        if (target == null) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Questory] Player not found: " + this.targetPlayerName)));
            return;
        }
        if (teamMgr.invitePlayer(myTeamId, target.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Invited " + this.targetPlayerName + " to your team")));
            target.m_213846_((Component)Component.m_237113_((String)"\u00a7e[Questory] You have been invited to join a team! Check your Team GUI or use /questory team accept"));
            this.syncTeamToPlayer(player);
            this.syncTeamToPlayer(target);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Failed to invite player"));
        }
    }

    private void handleAccept(ServerPlayer player, TeamManager teamMgr) {
        if (this.isFtbProviderActive()) {
            if (this.teamId != null) {
                this.runAsPlayer(player, "ftbteams party join " + String.valueOf(this.teamId));
                this.syncTeamToPlayer(player);
                UUID newTeam = teamMgr.getPlayerTeamId(player.m_20148_());
                if (newTeam != null) {
                    for (UUID memberId : teamMgr.getTeamMembers(newTeam)) {
                        ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
                        if (member == null || member.m_20148_().equals(player.m_20148_())) continue;
                        this.syncTeamToPlayer(member);
                    }
                }
            }
            return;
        }
        if (teamMgr.acceptInvite(player.m_20148_(), this.teamId)) {
            String teamName = teamMgr.getTeamName(this.teamId);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] You joined the team: " + teamName)));
            for (UUID memberId : teamMgr.getTeamMembers(this.teamId)) {
                ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
                if (member == null || member.m_20148_().equals(player.m_20148_())) continue;
                member.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Questory] " + player.m_7755_().getString() + " joined the team!")));
                this.syncTeamToPlayer(member);
            }
            this.syncTeamToPlayer(player);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Failed to join team"));
        }
    }

    private void handleDecline(ServerPlayer player, TeamManager teamMgr) {
        if (this.isFtbProviderActive()) {
            if (this.teamId != null) {
                this.runAsPlayer(player, "ftbteams party decline " + String.valueOf(this.teamId));
                this.syncTeamToPlayer(player);
            }
            return;
        }
        if (teamMgr.declineInvite(player.m_20148_(), this.teamId)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Questory] Declined team invite"));
            this.syncTeamToPlayer(player);
        }
    }

    private void handleLeave(ServerPlayer player, TeamManager teamMgr) {
        UUID teamId = teamMgr.getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (this.isFtbProviderActive()) {
            this.runAsPlayer(player, "ftbteams party leave");
            Set<UUID> membersBefore = teamMgr.getTeamMembers(teamId);
            for (UUID memberId : membersBefore) {
                ServerPlayer member;
                if (memberId.equals(player.m_20148_()) || (member = player.m_20194_().m_6846_().m_11259_(memberId)) == null) continue;
                this.syncTeamToPlayer(member);
            }
            this.syncTeamToPlayer(player);
            return;
        }
        String teamName = teamMgr.getTeamName(teamId);
        Set<UUID> membersBefore = teamMgr.getTeamMembers(teamId);
        if (teamMgr.leaveTeam(player.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] You left the team: " + teamName)));
            for (UUID memberId : membersBefore) {
                ServerPlayer member;
                if (memberId.equals(player.m_20148_()) || (member = player.m_20194_().m_6846_().m_11259_(memberId)) == null) continue;
                member.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Questory] " + player.m_7755_().getString() + " left the team")));
                this.syncTeamToPlayer(member);
            }
            this.syncTeamToPlayer(player);
        }
    }

    private void handleKick(ServerPlayer player, TeamManager teamMgr) {
        UUID targetId;
        UUID teamId = teamMgr.getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return;
        }
        if (this.isFtbProviderActive()) {
            if (this.targetPlayerName == null || this.targetPlayerName.isBlank()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] No target player specified"));
                return;
            }
            this.runAsPlayer(player, "ftbteams party kick " + this.targetPlayerName);
            ServerPlayer target = player.m_20194_().m_6846_().m_11255_(this.targetPlayerName);
            if (target != null) {
                this.syncTeamToPlayer(target);
            }
            this.syncTeamToPlayer(player);
            return;
        }
        ServerPlayer target = player.m_20194_().m_6846_().m_11255_(this.targetPlayerName);
        UUID uUID = targetId = target != null ? target.m_20148_() : null;
        if (targetId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Player must be online to kick"));
            return;
        }
        if (teamMgr.kickPlayer(teamId, targetId, player.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Kicked " + this.targetPlayerName + " from the team")));
            if (target != null) {
                target.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You were kicked from the team"));
                this.syncTeamToPlayer(target);
            }
            this.syncTeamToPlayer(player);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Failed to kick player"));
        }
    }

    private void syncTeamToPlayer(ServerPlayer player) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.m_20148_());
        QuestTeam team = null;
        if (teamId != null && (team = teamMgr.getTeam(teamId)) == null) {
            team = teamMgr.buildExternalTeamSnapshot(teamId);
        }
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.m_20148_());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) {
                inviteTeam = teamMgr.buildExternalTeamSnapshot(inviteTeamId);
            }
            if (inviteTeam == null) continue;
            String ownerName = this.getPlayerName(player.m_20194_(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.m_20148_());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.m_20148_(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private String getPlayerName(MinecraftServer server, UUID playerId) {
        ServerPlayer player = server.m_6846_().m_11259_(playerId);
        if (player != null) {
            return player.m_7755_().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    public static enum Action {
        INVITE,
        ACCEPT,
        DECLINE,
        LEAVE,
        KICK;

    }
}

