/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.integration.GameStagesHelper;
import org.texboobcat.questory.quest.Reward;

public class StageReward
extends Reward {
    private String stage;
    private boolean remove;

    public StageReward(String stage, boolean remove) {
        super("stage");
        this.stage = stage;
        this.remove = remove;
    }

    public String getStage() {
        return this.stage;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    @Override
    public void grant(ServerPlayer player) {
        if (!GameStagesHelper.isAvailable()) {
            System.err.println("[Questory] Cannot " + (this.remove ? "remove" : "grant") + " stage '" + this.stage + "' - GameStages mod not installed");
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Questory] GameStages mod required for stage reward: " + this.stage)));
            return;
        }
        if (this.remove) {
            GameStagesHelper.getInstance().removeStage(player, this.stage);
            System.out.println("[Questory] Removed stage '" + this.stage + "' from " + player.m_7755_().getString());
        } else {
            GameStagesHelper.getInstance().addStage(player, this.stage);
            System.out.println("[Questory] Granted stage '" + this.stage + "' to " + player.m_7755_().getString());
        }
    }

    @Override
    public String getDisplayString() {
        return (this.remove ? "Remove" : "Grant") + " stage: " + this.stage;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "stage");
        json.addProperty("stage", this.stage);
        if (this.remove) {
            json.addProperty("remove", Boolean.valueOf(true));
        }
        return json;
    }

    public static StageReward fromJson(JsonObject json) {
        String stage = json.get("stage").getAsString();
        boolean remove = json.has("remove") && json.get("remove").getAsBoolean();
        return new StageReward(stage, remove);
    }
}

