/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage;

import java.nio.file.Path;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.storage.backend.json.JsonPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.json.JsonTeamStorageBackend;
import org.texboobcat.questory.storage.backend.mysql.MysqlPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.mysql.MysqlTeamStorageBackend;
import org.texboobcat.questory.storage.backend.sqlite.SqlitePlayerProgressBackend;
import org.texboobcat.questory.storage.backend.sqlite.SqliteTeamStorageBackend;

public class StorageBackendFactory {
    public static IPlayerProgressBackend createPlayerProgressBackend(QuestoryConfig config, Path dataPath) {
        IPlayerProgressBackend backend;
        String storageType;
        switch (storageType = config.storageType.toLowerCase()) {
            case "sqlite": {
                System.out.println("[Questory] Creating SQLite player progress backend");
                IPlayerProgressBackend iPlayerProgressBackend = new SqlitePlayerProgressBackend(dataPath, config.sqliteDatabasePath);
                break;
            }
            case "mysql": {
                System.out.println("[Questory] Creating MySQL player progress backend");
                IPlayerProgressBackend iPlayerProgressBackend = new MysqlPlayerProgressBackend(config);
                break;
            }
            case "json": {
                System.out.println("[Questory] Creating JSON player progress backend");
                IPlayerProgressBackend iPlayerProgressBackend = new JsonPlayerProgressBackend(dataPath);
                break;
            }
            default: {
                System.err.println("[Questory] Unknown storage type '" + config.storageType + "', using JSON as fallback");
                IPlayerProgressBackend iPlayerProgressBackend = backend = new JsonPlayerProgressBackend(dataPath);
            }
        }
        if (!StorageBackendFactory.connectWithRetry(backend, 3)) {
            System.err.println("[Questory] Failed to connect to " + backend.getBackendType() + " backend after retries");
            if (!storageType.equals("json")) {
                System.out.println("[Questory] Falling back to JSON storage backend");
                backend = new JsonPlayerProgressBackend(dataPath);
                backend.connect();
            }
        }
        return backend;
    }

    private static boolean connectWithRetry(IPlayerProgressBackend backend, int maxRetries) {
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            System.out.println("[Questory] Connection attempt " + attempt + "/" + maxRetries + " for " + backend.getBackendType() + " backend");
            if (backend.connect()) {
                if (attempt > 1) {
                    System.out.println("[Questory] Successfully connected on attempt " + attempt);
                }
                return true;
            }
            if (attempt >= maxRetries) continue;
            int delayMs = 1000 * attempt;
            System.out.println("[Questory] Connection failed, retrying in " + delayMs + "ms...");
            try {
                Thread.sleep(delayMs);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("[Questory] Connection retry interrupted");
                return false;
            }
        }
        return false;
    }

    public static ITeamStorageBackend createTeamStorageBackend(QuestoryConfig config, Path dataPath) {
        ITeamStorageBackend backend;
        String storageType;
        switch (storageType = config.storageType.toLowerCase()) {
            case "sqlite": {
                System.out.println("[Questory] Creating SQLite team storage backend");
                ITeamStorageBackend iTeamStorageBackend = new SqliteTeamStorageBackend(dataPath, config.sqliteDatabasePath);
                break;
            }
            case "mysql": {
                System.out.println("[Questory] Creating MySQL team storage backend");
                ITeamStorageBackend iTeamStorageBackend = new MysqlTeamStorageBackend(config);
                break;
            }
            case "json": {
                System.out.println("[Questory] Creating JSON team storage backend");
                ITeamStorageBackend iTeamStorageBackend = new JsonTeamStorageBackend(dataPath);
                break;
            }
            default: {
                System.err.println("[Questory] Unknown storage type '" + config.storageType + "', using JSON as fallback");
                ITeamStorageBackend iTeamStorageBackend = backend = new JsonTeamStorageBackend(dataPath);
            }
        }
        if (!StorageBackendFactory.connectWithRetryTeam(backend, 3)) {
            System.err.println("[Questory] Failed to connect to " + backend.getBackendType() + " team backend after retries");
            if (!storageType.equals("json")) {
                System.out.println("[Questory] Falling back to JSON team storage backend");
                backend = new JsonTeamStorageBackend(dataPath);
                backend.connect();
            }
        }
        return backend;
    }

    private static boolean connectWithRetryTeam(ITeamStorageBackend backend, int maxRetries) {
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            System.out.println("[Questory] Connection attempt " + attempt + "/" + maxRetries + " for " + backend.getBackendType() + " team backend");
            if (backend.connect()) {
                if (attempt > 1) {
                    System.out.println("[Questory] Successfully connected on attempt " + attempt);
                }
                return true;
            }
            if (attempt >= maxRetries) continue;
            int delayMs = 1000 * attempt;
            System.out.println("[Questory] Connection failed, retrying in " + delayMs + "ms...");
            try {
                Thread.sleep(delayMs);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("[Questory] Connection retry interrupted");
                return false;
            }
        }
        return false;
    }
}

