/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import com.google.gson.JsonObject;
import java.util.UUID;

public class TeamInviteInfo {
    private final UUID teamId;
    private final String teamName;
    private final String ownerName;
    private final int memberCount;

    public TeamInviteInfo(UUID teamId, String teamName, String ownerName, int memberCount) {
        this.teamId = teamId;
        this.teamName = teamName;
        this.ownerName = ownerName;
        this.memberCount = memberCount;
    }

    public UUID getTeamId() {
        return this.teamId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("teamId", this.teamId.toString());
        json.addProperty("teamName", this.teamName);
        json.addProperty("ownerName", this.ownerName);
        json.addProperty("memberCount", (Number)this.memberCount);
        return json;
    }

    public static TeamInviteInfo fromJson(JsonObject json) {
        UUID teamId = UUID.fromString(json.get("teamId").getAsString());
        String teamName = json.get("teamName").getAsString();
        String ownerName = json.get("ownerName").getAsString();
        int memberCount = json.get("memberCount").getAsInt();
        return new TeamInviteInfo(teamId, teamName, ownerName, memberCount);
    }
}

