/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_332;

public enum QuestShape {
    SQUARE("square", "default"),
    CIRCLE("circle", new String[0]),
    RSQUARE("rsquare", "rounded_square"),
    DIAMOND("diamond", new String[0]),
    HEXAGON("hexagon", new String[0]),
    OCTAGON("octagon", new String[0]),
    HEART("heart", new String[0]),
    GEAR("gear", new String[0]),
    PENTAGON("pentagon", new String[0]),
    STAR("star", new String[0]),
    TRIANGLE("triangle", new String[0]),
    OVAL("oval", "ellipse"),
    CROSS("cross", "plus"),
    SHIELD("shield", new String[0]),
    ARROW("arrow", new String[0]);

    private final String id;
    private final String[] aliases;
    private static final Map<String, QuestShape> EXTRA_ALIAS_REGISTRY;
    private static final double SQRT_3 = 1.732050807568877;
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;

    private QuestShape(String id, String ... aliases) {
        this.id = id;
        this.aliases = aliases;
    }

    public void drawShadeOverlay(class_332 graphics, int x, int y, int size, String mode, String direction, double strength, int tintColor) {
        if (mode == null) {
            mode = "linear";
        }
        if (direction == null) {
            direction = "down_right";
        }
        if (strength <= 0.0) {
            return;
        }
        int halfSize = size / 2;
        double maxAlpha = Math.max(0.0, Math.min(1.0, strength)) * 140.0;
        int tint = tintColor;
        if ("none".equalsIgnoreCase(mode)) {
            return;
        }
        int denom = Math.max(1, size - 1);
        double normDiag = Math.sqrt(0.5);
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                double t;
                int dx = px - halfSize;
                if (!this.contains(x, y, size, x + px, y + py)) continue;
                double u = (double)px / (double)denom;
                double v = (double)py / (double)denom;
                if ("radial".equalsIgnoreCase(mode)) {
                    double rx = u - 0.5;
                    double ry = v - 0.5;
                    t = Math.sqrt(rx * rx + ry * ry) / normDiag;
                } else {
                    switch (direction.toLowerCase(Locale.ROOT)) {
                        case "down": {
                            t = v;
                            break;
                        }
                        case "right": {
                            t = u;
                            break;
                        }
                        case "up": {
                            t = 1.0 - v;
                            break;
                        }
                        case "left": {
                            t = 1.0 - u;
                            break;
                        }
                        case "up_right": {
                            t = (u - v + 1.0) / 2.0;
                            break;
                        }
                        case "down_left": {
                            t = (v - u + 1.0) / 2.0;
                            break;
                        }
                        case "up_left": {
                            t = 1.0 - (u + v) / 2.0;
                            break;
                        }
                        default: {
                            t = (u + v) / 2.0;
                        }
                    }
                }
                if (t < 0.0) {
                    t = 0.0;
                } else if (t > 1.0) {
                    t = 1.0;
                }
                int a = (int)Math.round(maxAlpha * t) & 0xFF;
                if (a <= 0) continue;
                int argb = a << 24 | tint & 0xFFFFFF;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, argb);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public static QuestShape get(String shapeId) {
        if (shapeId == null || shapeId.isEmpty() || "default".equals(shapeId)) {
            return SQUARE;
        }
        String lowerShapeId = shapeId.toLowerCase(Locale.ROOT);
        QuestShape mapped = EXTRA_ALIAS_REGISTRY.get(lowerShapeId);
        if (mapped != null) {
            return mapped;
        }
        for (QuestShape shape : QuestShape.values()) {
            if (!shape.id.equals(lowerShapeId)) continue;
            return shape;
        }
        for (QuestShape shape : QuestShape.values()) {
            for (String alias : shape.aliases) {
                if (!alias.equalsIgnoreCase(shapeId)) continue;
                return shape;
            }
        }
        return SQUARE;
    }

    public static void registerExtraAliases(String csv) {
        String[] parts;
        if (csv == null || csv.isEmpty()) {
            return;
        }
        for (String p : parts = csv.split(",")) {
            String name = p.trim().toLowerCase(Locale.ROOT);
            if (name.isEmpty()) continue;
            QuestShape target = switch (name) {
                case "square", "rsquare", "rounded_square" -> RSQUARE;
                case "circle" -> CIRCLE;
                case "diamond" -> DIAMOND;
                case "hexagon" -> HEXAGON;
                case "octagon" -> OCTAGON;
                case "heart" -> HEART;
                case "gear" -> GEAR;
                case "pentagon" -> PENTAGON;
                case "star" -> STAR;
                case "triangle" -> TRIANGLE;
                case "oval", "ellipse" -> OVAL;
                case "cross", "plus" -> CROSS;
                case "shield" -> SHIELD;
                case "arrow" -> ARROW;
                default -> DIAMOND;
            };
            EXTRA_ALIAS_REGISTRY.put(name, target);
        }
    }

    public void drawBackground(class_332 graphics, int x, int y, int size, int color) {
        switch (this.ordinal()) {
            case 1: {
                this.drawCircle(graphics, x, y, size, color);
                break;
            }
            case 3: {
                this.drawDiamond(graphics, x, y, size, color);
                break;
            }
            case 4: {
                this.drawHexagon(graphics, x, y, size, color);
                break;
            }
            case 5: {
                this.drawOctagon(graphics, x, y, size, color);
                break;
            }
            case 2: {
                this.drawRoundedSquare(graphics, x, y, size, color);
                break;
            }
            case 6: {
                this.drawHeart(graphics, x, y, size, color);
                break;
            }
            case 7: {
                this.drawGear(graphics, x, y, size, color);
                break;
            }
            case 8: {
                this.drawPentagon(graphics, x, y, size, color);
                break;
            }
            case 9: {
                this.drawStar(graphics, x, y, size, color);
                break;
            }
            case 10: {
                this.drawTriangle(graphics, x, y, size, color);
                break;
            }
            case 11: {
                this.drawOval(graphics, x, y, size, color);
                break;
            }
            case 12: {
                this.drawCross(graphics, x, y, size, color);
                break;
            }
            case 13: {
                this.drawShield(graphics, x, y, size, color);
                break;
            }
            case 14: {
                this.drawArrow(graphics, x, y, size, color);
                break;
            }
            default: {
                graphics.method_25294(x, y, x + size, y + size, color);
            }
        }
    }

    public void drawOutline(class_332 graphics, int x, int y, int size, int color, int thickness) {
        int halfSize = size / 2;
        int centerX = x + halfSize;
        int centerY = y + halfSize;
        for (int py = -thickness; py < size + thickness; ++py) {
            for (int px = -thickness; px < size + thickness; ++px) {
                int screenX = x + px;
                int screenY = y + py;
                boolean isInside = this.contains(x, y, size, screenX, screenY);
                if (isInside) continue;
                boolean hasInsideNeighbor = false;
                for (int dy = -thickness; dy <= thickness && !hasInsideNeighbor; ++dy) {
                    for (int dx = -thickness; dx <= thickness && !hasInsideNeighbor; ++dx) {
                        if (dx == 0 && dy == 0 || !this.contains(x, y, size, screenX + dx, screenY + dy)) continue;
                        hasInsideNeighbor = true;
                    }
                }
                if (!hasInsideNeighbor) continue;
                graphics.method_25294(screenX, screenY, screenX + 1, screenY + 1, color);
            }
        }
    }

    public boolean contains(int shapeX, int shapeY, int shapeSize, int pointX, int pointY) {
        int halfSize = shapeSize / 2;
        int centerX = shapeX + halfSize;
        int centerY = shapeY + halfSize;
        int dx = pointX - centerX;
        int dy = pointY - centerY;
        return switch (this.ordinal()) {
            case 1 -> {
                int radiusSquared = halfSize * halfSize;
                if (dx * dx + dy * dy <= radiusSquared) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (Math.abs(dx) + Math.abs(dy) <= halfSize) {
                    yield true;
                }
                yield false;
            }
            case 10 -> this.containsTriangle(dx, dy, shapeSize);
            case 9 -> this.containsStar(dx, dy, shapeSize);
            case 4 -> this.containsHexagon(dx, dy, halfSize);
            case 8 -> this.containsPentagon(dx, dy, halfSize);
            case 5 -> this.containsOctagon(dx, dy, halfSize);
            case 6 -> this.containsHeart(dx, dy, halfSize);
            case 7 -> this.containsGear(dx, dy, halfSize);
            case 11 -> this.containsOval(dx, dy, halfSize);
            case 12 -> this.containsCross(dx, dy, shapeSize);
            case 13 -> this.containsShield(dx, dy, halfSize);
            case 14 -> this.containsArrow(dx, dy, shapeSize);
            case 2 -> this.containsRoundedSquare(dx, dy, shapeSize);
            default -> pointX >= shapeX && pointX < shapeX + shapeSize && pointY >= shapeY && pointY < shapeY + shapeSize;
        };
    }

    private void drawCircle(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        int radiusSquared = halfSize * halfSize;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            int dySquared = dy * dy;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (dx * dx + dySquared > radiusSquared) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private void drawDiamond(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = Math.abs(py - halfSize);
            int maxDx = halfSize - dy;
            for (int px = 0; px < size; ++px) {
                int dx = Math.abs(px - halfSize);
                if (dx > maxDx) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private void drawRoundedSquare(class_332 graphics, int x, int y, int size, int color) {
        int cornerRadius = Math.max(1, size / 5);
        int radiusSquared = cornerRadius * cornerRadius;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                boolean inside = false;
                if (px >= cornerRadius && px < size - cornerRadius) {
                    inside = true;
                } else if (py >= cornerRadius && py < size - cornerRadius) {
                    inside = true;
                } else {
                    int cx = px < cornerRadius ? cornerRadius : size - cornerRadius;
                    int cy = py < cornerRadius ? cornerRadius : size - cornerRadius;
                    int dx = px - cx;
                    int dy = py - cy;
                    boolean bl = inside = dx * dx + dy * dy <= radiusSquared;
                }
                if (!inside) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private void drawHexagon(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsHexagon(dx, dy, halfSize)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsHexagon(int dx, int dy, int radius) {
        double absDx = Math.abs(dx);
        double absDy = Math.abs(dy);
        if (absDy > (double)radius * 0.866) {
            return false;
        }
        if (absDx > (double)radius) {
            return false;
        }
        return absDx + absDy / 1.732050807568877 <= (double)radius;
    }

    private void drawOctagon(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        double cutoff = (double)size * 0.293;
        for (int py = 0; py < size; ++py) {
            int dy = Math.abs(py - halfSize);
            for (int px = 0; px < size; ++px) {
                int dx = Math.abs(px - halfSize);
                if (!this.containsOctagon(dx, dy, halfSize)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsOctagon(int dx, int dy, int radius) {
        double diagonal;
        double absDy;
        double absDx = Math.abs(dx);
        double maxAxisAligned = Math.max(absDx, absDy = (double)Math.abs(dy));
        return Math.max(maxAxisAligned, diagonal = (absDx + absDy) / 1.414) <= (double)radius;
    }

    private void drawHeart(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsHeart(dx, dy, halfSize)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsHeart(int dx, int dy, int radius) {
        double x = (double)dx / (double)radius;
        double y = (double)(-dy) / (double)radius + 0.3;
        double xy2 = x * x + y * y;
        double term1 = xy2 - 1.0;
        return term1 * term1 * term1 - x * x * y * y * y <= 0.0;
    }

    private void drawGear(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsGear(dx, dy, halfSize)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsGear(int dx, int dy, int radius) {
        double angle = Math.atan2(dy, dx);
        double dist = Math.sqrt((double)dx * (double)dx + (double)dy * (double)dy);
        if (dist > (double)radius) {
            return false;
        }
        int teeth = 12;
        double baseFactor = 0.78;
        double tipFactor = 1.0;
        double sharpen = 0.55;
        double period = 0.5235987755982988;
        double a = angle % period;
        if (a < 0.0) {
            a += period;
        }
        double t = a / period;
        double lobe = 0.5 * (1.0 - Math.cos(Math.PI * 2 * t));
        lobe = Math.pow(lobe, 0.55);
        double rMax = (double)radius * (0.78 + 0.21999999999999997 * lobe);
        if (t < 0.08 || t > 0.92) {
            double edge = t < 0.08 ? t / 0.08 : (1.0 - t) / 0.08;
            rMax *= 0.9 + 0.1 * edge;
        }
        return dist <= rMax;
    }

    private void drawPentagon(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsPentagon(dx, dy, halfSize)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsPentagon(int dx, int dy, int radius) {
        double angle = Math.atan2(dy, dx);
        double distance = Math.sqrt(dx * dx + dy * dy);
        double sideAngle = 1.2566370614359172;
        double normalizedAngle = ((angle -= 1.5707963267948966) % sideAngle + sideAngle) % sideAngle;
        double edgeDistance = (double)radius * Math.cos(0.6283185307179586) / Math.cos(normalizedAngle - 0.6283185307179586);
        return distance <= edgeDistance;
    }

    private void drawStar(class_332 graphics, int x, int y, int size, int color) {
        int halfSize;
        int outerRadius = halfSize = size / 2;
        int innerRadius = (int)((double)halfSize * 0.4);
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsStar(dx, dy, size)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsStar(int dx, int dy, int size) {
        int outerRadius = size / 2;
        int innerRadius = (int)((double)(size / 2) * 0.4);
        double angle = Math.atan2(dy, dx);
        double distance = Math.sqrt(dx * dx + dy * dy);
        if ((angle -= 1.5707963267948966) < 0.0) {
            angle += Math.PI * 2;
        }
        double segmentAngle = 0.6283185307179586;
        int segment = (int)(angle / segmentAngle);
        double angleInSegment = angle % segmentAngle / segmentAngle;
        boolean isOuterSegment = segment % 2 == 0;
        double startRadius = isOuterSegment ? (double)outerRadius : (double)innerRadius;
        double endRadius = isOuterSegment ? (double)innerRadius : (double)outerRadius;
        double maxRadius = startRadius + (endRadius - startRadius) * angleInSegment;
        return distance <= maxRadius;
    }

    private void drawTriangle(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsTriangle(dx, dy, size)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsTriangle(int dx, int dy, int size) {
        int halfSize = size / 2;
        double height = (double)halfSize * 1.732050807568877;
        double y = (double)dy + height / 3.0;
        if (y < -height / 2.0 || y > height / 2.0) {
            return false;
        }
        double width = (height / 2.0 + y) * 2.0 / 1.732050807568877;
        return (double)Math.abs(dx) <= width / 2.0;
    }

    private void drawOval(class_332 graphics, int x, int y, int size, int color) {
        int halfSize;
        int radiusX = halfSize = size / 2;
        int radiusY = (int)((double)halfSize * 0.7);
        double radiusXSquared = radiusX * radiusX;
        double radiusYSquared = radiusY * radiusY;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            double dyTerm = (double)(dy * dy) / radiusYSquared;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                double dxTerm = (double)(dx * dx) / radiusXSquared;
                if (!(dxTerm + dyTerm <= 1.0)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsOval(int dx, int dy, int radius) {
        int radiusX = radius;
        int radiusY = (int)((double)radius * 0.7);
        double normalized = (double)(dx * dx) / (double)(radiusX * radiusX) + (double)(dy * dy) / (double)(radiusY * radiusY);
        return normalized <= 1.0;
    }

    private void drawCross(class_332 graphics, int x, int y, int size, int color) {
        int thickness = Math.max(1, size / 3);
        int centerStart = (size - thickness) / 2;
        int centerEnd = centerStart + thickness;
        graphics.method_25294(x + centerStart, y, x + centerEnd, y + size, color);
        graphics.method_25294(x, y + centerStart, x + size, y + centerEnd, color);
    }

    private boolean containsCross(int dx, int dy, int size) {
        int thickness = Math.max(1, size / 3);
        int halfThickness = thickness / 2;
        return Math.abs(dx) <= halfThickness || Math.abs(dy) <= halfThickness;
    }

    private void drawShield(class_332 graphics, int x, int y, int size, int color) {
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            int dy = py - halfSize;
            for (int px = 0; px < size; ++px) {
                int dx = px - halfSize;
                if (!this.containsShield(dx, dy, halfSize)) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsShield(int dx, int dy, int radius) {
        double absX = (double)Math.abs(dx) / (double)radius;
        double relY = (double)dy / (double)radius;
        if (relY <= 0.0) {
            return absX * absX + relY * relY <= 1.0;
        }
        return absX <= (1.0 - relY) * 0.9;
    }

    private void drawArrow(class_332 graphics, int x, int y, int size, int color) {
        int thickness = Math.max(1, size / 3);
        int halfSize = size / 2;
        int shaftEnd = size * 2 / 3;
        graphics.method_25294(x, y + halfSize - thickness / 2, x + shaftEnd, y + halfSize + thickness / 2, color);
        for (int py = 0; py < size; ++py) {
            int dy = Math.abs(py - halfSize);
            for (int px = shaftEnd; px < size; ++px) {
                int dx = px - shaftEnd;
                int maxDy = halfSize - (int)((double)dx * 1.5);
                if (dy > maxDy) continue;
                graphics.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsArrow(int dx, int dy, int size) {
        int thickness = Math.max(1, size / 3);
        int halfThickness = thickness / 2;
        int halfSize = size / 2;
        int shaftEnd = size * 2 / 3 - halfSize;
        if (dx <= shaftEnd && Math.abs(dy) <= halfThickness) {
            return true;
        }
        if (dx > shaftEnd) {
            int dxFromHead = dx - shaftEnd;
            int maxDy = halfSize - (int)((double)dxFromHead * 1.5);
            return Math.abs(dy) <= maxDy;
        }
        return false;
    }

    private boolean containsRoundedSquare(int dx, int dy, int size) {
        int cornerRadius = Math.max(1, size / 5);
        int halfSize = size / 2;
        int absDx = Math.abs(dx);
        int absDy = Math.abs(dy);
        if (absDx <= halfSize - cornerRadius || absDy <= halfSize - cornerRadius) {
            return true;
        }
        int cornerDx = absDx - (halfSize - cornerRadius);
        int cornerDy = absDy - (halfSize - cornerRadius);
        return cornerDx * cornerDx + cornerDy * cornerDy <= cornerRadius * cornerRadius;
    }

    static {
        EXTRA_ALIAS_REGISTRY = new HashMap<String, QuestShape>();
    }
}

