/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.team.TeamProgressMode;
import org.texboobcat.questory.team.TeamQuestSettings;
import org.texboobcat.questory.team.TeamRewardMode;

public class TeamTabPanel
extends TabPanel {
    private boolean teamEnabled = false;
    private TeamProgressMode progressMode = TeamProgressMode.SHARED;
    private TeamRewardMode rewardMode = TeamRewardMode.SHARED;
    private int minTeamSize = 1;
    private int maxTeamSize = 10;
    private boolean requireAllOnline = false;
    private boolean allowSoloCompletion = true;
    private class_4185 teamEnabledBtn;
    private class_4185 progressModeBtn;
    private class_4185 rewardModeBtn;
    private class_342 minSizeField;
    private class_342 maxSizeField;
    private class_4185 requireOnlineBtn;
    private class_4185 allowSoloBtn;

    public TeamTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12;
        int labelW = 180;
        int btnW = 120;
        this.teamEnabledBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Team Enabled: No"), b -> {
            this.teamEnabled = !this.teamEnabled;
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX + labelW, fieldY, btnW, 20).method_46431();
        this.progressModeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Progress: SHARED"), b -> {
            this.progressMode = switch (this.progressMode) {
                default -> throw new IncompatibleClassChangeError();
                case TeamProgressMode.SHARED -> TeamProgressMode.INDIVIDUAL;
                case TeamProgressMode.INDIVIDUAL -> TeamProgressMode.COMBINED;
                case TeamProgressMode.COMBINED -> TeamProgressMode.PARALLEL;
                case TeamProgressMode.PARALLEL -> TeamProgressMode.SHARED;
            };
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX + labelW, fieldY += 30, btnW + 30, 20).method_46431();
        this.rewardModeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reward: SHARED"), b -> {
            this.rewardMode = switch (this.rewardMode) {
                default -> throw new IncompatibleClassChangeError();
                case TeamRewardMode.SHARED -> TeamRewardMode.COMPLETER_ONLY;
                case TeamRewardMode.COMPLETER_ONLY -> TeamRewardMode.DISTRIBUTED;
                case TeamRewardMode.DISTRIBUTED -> TeamRewardMode.ALL_MEMBERS;
                case TeamRewardMode.ALL_MEMBERS -> TeamRewardMode.SHARED;
            };
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX + labelW, fieldY += 30, btnW + 30, 20).method_46431();
        this.minSizeField = this.createField(fieldX + labelW, fieldY += 30, 60, "1");
        this.minSizeField.method_1880(2);
        this.maxSizeField = this.createField(fieldX + labelW, fieldY += 30, 60, "10");
        this.maxSizeField.method_1880(2);
        this.requireOnlineBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Require All Online: No"), b -> {
            this.requireAllOnline = !this.requireAllOnline;
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX + labelW, fieldY += 30, btnW + 30, 20).method_46431();
        this.allowSoloBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Allow Solo: Yes"), b -> {
            this.allowSoloCompletion = !this.allowSoloCompletion;
            this.updateButtonLabels();
            this.editor.saveCurrentTabToQuest();
        }).method_46434(fieldX + labelW, fieldY += 30, btnW + 30, 20).method_46431();
    }

    private void updateButtonLabels() {
        this.teamEnabledBtn.method_25355((class_2561)class_2561.method_43470((String)("Team Enabled: " + (this.teamEnabled ? "Yes" : "No"))));
        this.progressModeBtn.method_25355((class_2561)class_2561.method_43470((String)("Progress: " + this.progressMode.name())));
        this.rewardModeBtn.method_25355((class_2561)class_2561.method_43470((String)("Reward: " + this.rewardMode.name())));
        this.requireOnlineBtn.method_25355((class_2561)class_2561.method_43470((String)("Require All Online: " + (this.requireAllOnline ? "Yes" : "No"))));
        this.allowSoloBtn.method_25355((class_2561)class_2561.method_43470((String)("Allow Solo: " + (this.allowSoloCompletion ? "Yes" : "No"))));
        this.progressModeBtn.field_22763 = this.teamEnabled;
        this.rewardModeBtn.field_22763 = this.teamEnabled;
        this.minSizeField.method_1888(this.teamEnabled);
        this.maxSizeField.method_1888(this.teamEnabled);
        this.requireOnlineBtn.field_22763 = this.teamEnabled;
        this.allowSoloBtn.field_22763 = this.teamEnabled;
    }

    @Override
    public void loadFromQuest(Quest quest) {
        TeamQuestSettings settings = quest.getTeamSettings();
        if (settings != null) {
            this.teamEnabled = settings.isTeamEnabled();
            this.progressMode = settings.getProgressMode();
            this.rewardMode = settings.getRewardMode();
            this.minTeamSize = settings.getMinTeamSize();
            this.maxTeamSize = settings.getMaxTeamSize();
            this.requireAllOnline = settings.isRequireAllOnline();
            this.allowSoloCompletion = settings.isAllowSoloCompletion();
            this.minSizeField.method_1852(String.valueOf(this.minTeamSize));
            this.maxSizeField.method_1852(String.valueOf(this.maxTeamSize));
        } else {
            this.teamEnabled = false;
            this.progressMode = TeamProgressMode.SHARED;
            this.rewardMode = TeamRewardMode.SHARED;
            this.minTeamSize = 1;
            this.maxTeamSize = 10;
            this.requireAllOnline = false;
            this.allowSoloCompletion = true;
            this.minSizeField.method_1852("1");
            this.maxSizeField.method_1852("10");
        }
        this.updateButtonLabels();
    }

    @Override
    public void saveToQuest(Quest quest) {
        try {
            this.minTeamSize = Integer.parseInt(this.minSizeField.method_1882());
        }
        catch (NumberFormatException e) {
            this.minTeamSize = 1;
        }
        try {
            this.maxTeamSize = Integer.parseInt(this.maxSizeField.method_1882());
        }
        catch (NumberFormatException e) {
            this.maxTeamSize = 10;
        }
        TeamQuestSettings settings = new TeamQuestSettings();
        settings.setTeamEnabled(this.teamEnabled);
        settings.setProgressMode(this.progressMode);
        settings.setRewardMode(this.rewardMode);
        settings.setMinTeamSize(this.minTeamSize);
        settings.setMaxTeamSize(this.maxTeamSize);
        settings.setRequireAllOnline(this.requireAllOnline);
        settings.setAllowSoloCompletion(this.allowSoloCompletion);
        quest.setTeamSettings(settings);
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12;
        int labelW = 180;
        g.method_25303(this.getFont(), "\u00a7e\u00a7lTeam Quest Settings", fieldX, fieldY - 10, 0xFFFFFF);
        g.method_25303(this.getFont(), "Enable Team Quest:", fieldX, fieldY, 0xFFFFFF);
        this.teamEnabledBtn.method_25394(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        if (this.teamEnabled) {
            g.method_25303(this.getFont(), "Progress Mode:", fieldX, fieldY, 0xFFFFFF);
            this.progressModeBtn.method_25394(g, mouseX, mouseY, partialTick);
            g.method_25303(this.getFont(), "  \u00a77" + this.getProgressModeHelp(), fieldX + 4, fieldY += 25, 0x888888);
            g.method_25303(this.getFont(), "Reward Mode:", fieldX, fieldY += 15, 0xFFFFFF);
            this.rewardModeBtn.method_25394(g, mouseX, mouseY, partialTick);
            g.method_25303(this.getFont(), "  \u00a77" + this.getRewardModeHelp(), fieldX + 4, fieldY += 25, 0x888888);
            g.method_25303(this.getFont(), "Min Team Size:", fieldX, fieldY += 15, 0xFFFFFF);
            this.minSizeField.method_25394(g, mouseX, mouseY, partialTick);
            g.method_25303(this.getFont(), "Max Team Size:", fieldX, fieldY += 30, 0xFFFFFF);
            this.maxSizeField.method_25394(g, mouseX, mouseY, partialTick);
            g.method_25303(this.getFont(), "Require All Members Online:", fieldX, fieldY += 30, 0xFFFFFF);
            this.requireOnlineBtn.method_25394(g, mouseX, mouseY, partialTick);
            g.method_25303(this.getFont(), "Allow Solo Completion:", fieldX, fieldY += 30, 0xFFFFFF);
            this.allowSoloBtn.method_25394(g, mouseX, mouseY, partialTick);
        } else {
            g.method_25303(this.getFont(), "\u00a77Enable team settings to configure", fieldX, fieldY + 10, 0x888888);
            g.method_25303(this.getFont(), "\u00a77team-specific quest behavior.", fieldX, fieldY + 22, 0x888888);
        }
    }

    private String getProgressModeHelp() {
        return switch (this.progressMode) {
            default -> throw new IncompatibleClassChangeError();
            case TeamProgressMode.SHARED -> "All members share progress";
            case TeamProgressMode.INDIVIDUAL -> "Each tracks own progress";
            case TeamProgressMode.COMBINED -> "Sum of all contributions";
            case TeamProgressMode.PARALLEL -> "All must complete individually";
        };
    }

    private String getRewardModeHelp() {
        return switch (this.rewardMode) {
            default -> throw new IncompatibleClassChangeError();
            case TeamRewardMode.SHARED -> "All online members get rewards";
            case TeamRewardMode.COMPLETER_ONLY -> "Only completer gets rewards";
            case TeamRewardMode.DISTRIBUTED -> "Rewards split among all";
            case TeamRewardMode.ALL_MEMBERS -> "All members (including offline)";
        };
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.teamEnabledBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.progressModeBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.rewardModeBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.requireOnlineBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.allowSoloBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

