/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.QuestShape;
import org.texboobcat.questory.client.rendering.AnimationHelper;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;
import org.texboobcat.questory.theme.property.ColorProperty;
import org.texboobcat.questory.theme.property.DoubleProperty;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.IntProperty;
import org.texboobcat.questory.theme.property.StringProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class ThemeEditorScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeEditorScreen.class);
    private static final int PANEL_WIDTH = 300;
    private static final int PREVIEW_WIDTH = 400;
    private static final int SPACING = 10;
    private final class_437 parent;
    private QuestTheme currentTheme;
    private String themeName = "custom_theme";
    private class_342 themeNameBox;
    private class_342 propertySearchBox;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int contentTopY = 200;
    private int contentBottomY = 0;
    private final Map<String, PropertyEditor> propertyEditors = new HashMap<String, PropertyEditor>();
    private final List<String> propertyCategories = new ArrayList<String>();
    private final Map<String, String> propertyCategoryByLabel = new HashMap<String, String>();
    private final Map<String, String> propertyKeyByLabel = new HashMap<String, String>();
    private final Map<String, List<String>> propertyDescriptions = new HashMap<String, List<String>>();
    private String selectedCategory = "Quest Appearance";
    private final List<EditorSlot> visibleEditorSlots = new ArrayList<EditorSlot>();
    private EditorSlot draggingSliderSlot = null;
    private boolean draggingSlider = false;
    private class_342 activeTextEditor = null;
    private EditorSlot activeTextSlot = null;
    private boolean previewDirty = true;
    private long lastPreviewUpdate = 0L;
    private static final String[] BUILTIN_PRESETS = new String[]{"dark", "light", "ftb_like", "minimal"};
    private int presetIndex = 0;

    public ThemeEditorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Theme Editor"));
        this.parent = parent;
        this.currentTheme = new QuestTheme();
        this.initializePropertyCategories();
    }

    public ThemeEditorScreen(class_437 parent, QuestTheme theme, String name) {
        this(parent);
        this.currentTheme = theme;
        this.themeName = name;
    }

    private void initializePropertyCategories() {
        this.propertyCategories.add("Quest Appearance");
        this.propertyCategories.add("Colors");
        this.propertyCategories.add("Dependency Lines");
        this.propertyCategories.add("Background");
        this.propertyCategories.add("Icons");
        this.propertyCategories.add("Animation");
    }

    protected void method_25426() {
        super.method_25426();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "theme_editor");
        this.themeNameBox = new class_342(this.field_22793, this.field_22789 - 300 + 10, 30, 280, 20, (class_2561)class_2561.method_43470((String)"Theme Name"));
        this.themeNameBox.method_1852(this.themeName);
        this.themeNameBox.method_1880(50);
        this.method_37063((class_364)this.themeNameBox);
        int categoryY = 60;
        for (String category : this.propertyCategories) {
            class_4185 categoryButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)category), b -> this.selectCategory(category)).method_46434(this.field_22789 - 300 + 10, categoryY, 280, 20).method_46431();
            this.method_37063((class_364)categoryButton);
            categoryY += 25;
        }
        this.propertySearchBox = new class_342(this.field_22793, this.field_22789 - 300 + 10, categoryY + 5, 280, 18, (class_2561)class_2561.method_43470((String)"Search"));
        this.propertySearchBox.method_1852("");
        this.method_37063((class_364)this.propertySearchBox);
        this.contentTopY = this.propertySearchBox.method_46427() + this.propertySearchBox.method_25364() + 8;
        this.contentBottomY = this.field_22790 - 60;
        int bottomY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save Theme"), b -> this.saveTheme()).method_46434(this.field_22789 - 300 + 10, bottomY, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load"), b -> this.loadTheme()).method_46434(this.field_22789 - 300 + 100, bottomY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> this.resetTheme()).method_46434(this.field_22789 - 300 + 170, bottomY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(this.field_22789 - 300 + 240, bottomY, 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply & Back"), b -> {
            this.saveTheme();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(this.field_22789 - 300 + 120, bottomY, 110, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Preset"), b -> this.loadNextPreset()).method_46434(this.field_22789 - 300 + 10, bottomY - 26, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export JSON"), b -> this.exportThemeJson()).method_46434(this.field_22789 - 300 + 10 + 75, bottomY - 26, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Import JSON"), b -> this.importThemeJson()).method_46434(this.field_22789 - 300 + 10 + 180, bottomY - 26, 100, 20).method_46431());
        this.initializePropertyEditors();
        this.initializePropertyDescriptions();
        this.assignPropertyCategories();
        if (!this.propertyCategories.isEmpty()) {
            this.selectedCategory = this.propertyCategories.get(0);
        }
    }

    private void initializePropertyEditors() {
        this.propertyEditors.clear();
        this.propertyCategoryByLabel.clear();
        this.propertyKeyByLabel.clear();
        try {
            Field[] fields;
            for (Field f : fields = ThemeProperties.class.getFields()) {
                PropertyEditor editor;
                Object v = f.get(null);
                if (!(v instanceof ThemeProperty)) continue;
                ThemeProperty tp = (ThemeProperty)v;
                String key = tp.getName();
                String label = this.toDisplayLabel(key);
                if ("quest_shade_mode".equals(key)) {
                    String string;
                    if (v instanceof StringProperty) {
                        sp = (StringProperty)v;
                        string = (String)sp.get();
                    } else {
                        string = "linear";
                    }
                    String seed = string;
                    editor = new DropdownEditor(key, seed, new String[]{"none", "linear", "radial"});
                } else if ("quest_shade_direction".equals(key)) {
                    String string;
                    if (v instanceof StringProperty) {
                        sp = (StringProperty)v;
                        string = (String)sp.get();
                    } else {
                        string = "down_right";
                    }
                    String seed = string;
                    editor = new DropdownEditor(key, seed, new String[]{"down_right", "down", "right", "up_left", "up", "left", "up_right", "down_left"});
                } else if (v instanceof ColorProperty) {
                    int seed = (Integer)((ColorProperty)v).get();
                    editor = new ColorEditor(key, seed);
                } else if (v instanceof IntProperty) {
                    IntProperty ip = (IntProperty)v;
                    int seed = (Integer)ip.get();
                    editor = new NumberEditor(key, String.valueOf(seed), true);
                } else if (v instanceof DoubleProperty) {
                    DoubleProperty dp = (DoubleProperty)v;
                    double seed = (Double)dp.get();
                    editor = new NumberEditor(key, this.trimDouble(seed), false);
                } else if (v instanceof IconProperty) {
                    IconProperty ic = (IconProperty)v;
                    IconProperty.IconData data = (IconProperty.IconData)ic.get();
                    editor = new TextEditor(key, data == null ? "" : data.toString());
                } else {
                    if (!(v instanceof StringProperty)) continue;
                    StringProperty sp = (StringProperty)v;
                    editor = new TextEditor(key, (String)sp.get());
                }
                this.propertyEditors.put(label, editor);
                this.propertyKeyByLabel.put(label, key);
                String cat = this.categorizeKey(key, v);
                this.propertyCategoryByLabel.put(label, cat);
                if (this.propertyCategories.contains(cat)) continue;
                this.propertyCategories.add(cat);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to build editors from ThemeProperties", t);
        }
    }

    private void selectCategory(String category) {
        if (category != null) {
            this.selectedCategory = category;
        }
        this.scrollOffset = 0;
        this.previewDirty = true;
    }

    private void assignPropertyCategories() {
        if (this.propertyCategories.isEmpty()) {
            this.propertyCategories.add("Quest Appearance");
            this.propertyCategories.add("Colors");
            this.propertyCategories.add("Dependency Lines");
            this.propertyCategories.add("Background");
            this.propertyCategories.add("Icons");
            this.propertyCategories.add("Animation");
        }
    }

    private void saveTheme() {
        block13: {
            String name = this.themeNameBox.method_1882();
            if (name.isEmpty()) {
                name = "custom_theme";
            }
            try {
                Path configDir = Paths.get("config", "questory", "themes");
                Files.createDirectories(configDir, new FileAttribute[0]);
                Path themePath = configDir.resolve(name + ".txt");
                try (BufferedWriter writer = Files.newBufferedWriter(themePath, new OpenOption[0]);){
                    writer.write("// Questory Theme: " + name);
                    writer.newLine();
                    writer.write("// Generated by Theme Editor");
                    writer.newLine();
                    writer.newLine();
                    writer.write("[*]");
                    writer.newLine();
                    for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
                        String key;
                        String display = entry.getKey();
                        Object value = entry.getValue().getValue();
                        if (value == null || (key = this.propertyKeyByLabel.get(display)) == null || key.isEmpty()) continue;
                        String valueStr = this.formatPropertyValue(value);
                        writer.write(key + ": " + valueStr);
                        writer.newLine();
                    }
                    String bg = this.buildBackgroundIconString((String)this.getEditorValue("Background Path"), (Number)this.getEditorValue("Background Tile Size"), (Integer)this.getEditorValue("Background Tint"));
                    if (bg != null) {
                        writer.write("background: " + bg);
                        writer.newLine();
                    }
                }
                LOGGER.info("Saved theme to: {}", (Object)themePath);
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                QuestoryConfig config = QuestoryConfig.getInstance();
                config.customThemeName = name;
                QuestoryConfig.save(Paths.get("config", new String[0]));
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Theme saved: " + String.valueOf(themePath.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to save theme", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block13;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to save theme: " + e.getMessage())));
            }
        }
    }

    private String mapDisplayToThemeKey(String displayName) {
        return this.propertyKeyByLabel.get(displayName);
    }

    private Object getEditorValue(String displayName) {
        PropertyEditor ed = this.propertyEditors.get(displayName);
        return ed == null ? null : ed.getValue();
    }

    private String buildBackgroundIconString(String path, Number tileSizeValue, Integer tint) {
        int a;
        int tile;
        if (path == null || path.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(path.trim());
        if (tileSizeValue != null && (tile = Math.max(0, (int)Math.round(tileSizeValue.doubleValue()))) > 0) {
            sb.append("; tile_size=").append(tile);
        }
        if (tint != null && (a = tint >> 24 & 0xFF) != 0) {
            sb.append("; color=").append(String.format("#%08X", tint));
        }
        return sb.toString();
    }

    private String formatPropertyValue(Object value) {
        if (value instanceof Integer) {
            int color = (Integer)value;
            return String.format("#%08X", color);
        }
        if (value instanceof Float) {
            return String.format("%.2f", (Float)value);
        }
        if (value instanceof Double) {
            return this.trimDouble((Double)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        return value.toString();
    }

    private String trimDouble(double d) {
        String s = String.format(Locale.ROOT, "%.4f", d);
        while (s.contains(".") && (s.endsWith("0") || s.endsWith("."))) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? "0" : s;
    }

    private String toDisplayLabel(String key) {
        String[] parts = key.split("_");
        StringBuilder b = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            b.append(Character.toUpperCase(p.charAt(0))).append(p.length() > 1 ? p.substring(1) : "").append(" ");
        }
        return b.toString().trim();
    }

    private String categorizeKey(String key, Object prop) {
        if (key.contains("dependency_line")) {
            return "Dependency Lines";
        }
        if (key.contains("background")) {
            return "Background";
        }
        if (key.startsWith("quest_shade_")) {
            return "Quest Appearance";
        }
        if (prop instanceof IconProperty) {
            return "Icons";
        }
        if (prop instanceof ColorProperty) {
            return "Colors";
        }
        if (key.contains("quest") || key.contains("widget") || key.contains("spacing") || key.contains("pinned")) {
            return "Quest Appearance";
        }
        if (key.contains("animation") || key.contains("pulse")) {
            return "Animation";
        }
        return "Quest Appearance";
    }

    private void loadTheme() {
        block7: {
            try {
                Path themesDir = Paths.get("config", "questory", "themes");
                if (!Files.exists(themesDir, new LinkOption[0])) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"No themes directory found"));
                    }
                    return;
                }
                ArrayList themes = new ArrayList();
                Files.list(themesDir).filter(p -> p.toString().endsWith(".txt")).forEach(p -> themes.add(p.getFileName().toString().replace(".txt", "")));
                if (themes.isEmpty()) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("No themes found in " + String.valueOf(themesDir))));
                    }
                    return;
                }
                String themeName = (String)themes.get(0);
                Path themePath = themesDir.resolve(themeName + ".txt");
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                this.previewDirty = true;
                LOGGER.info("Loaded theme: {}", (Object)themeName);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Loaded theme: " + themeName + " (" + themes.size() + " available)")));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load theme", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block7;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to load theme: " + e.getMessage())));
            }
        }
    }

    private void resetTheme() {
        this.currentTheme = new QuestTheme();
        this.previewDirty = true;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        this.renderEditorPanel(graphics, mouseX, mouseY);
        this.renderPreviewPanel(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
        if (this.previewDirty && System.currentTimeMillis() - this.lastPreviewUpdate > 120L) {
            this.applyInMemoryThemeFromEditors();
            this.lastPreviewUpdate = System.currentTimeMillis();
            this.previewDirty = false;
        }
    }

    private void renderEditorPanel(class_332 graphics, int mouseX, int mouseY) {
        int panelX = this.field_22789 - 300;
        int panelY = 0;
        int panelHeight = this.field_22790;
        graphics.method_25294(panelX, panelY, panelX + 300, panelY + panelHeight, -536870912);
        graphics.method_25294(panelX, panelY, panelX + 2, panelY + panelHeight, -12566464);
        this.visibleEditorSlots.clear();
        this.contentBottomY = this.field_22790 - 60;
        int panelLeft = this.field_22789 - 300;
        try {
            graphics.method_44379(panelLeft, this.contentTopY, 300, Math.max(1, this.contentBottomY - this.contentTopY));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int propertyY = this.contentTopY - this.scrollOffset;
        String filter = this.propertySearchBox != null ? this.propertySearchBox.method_1882().trim().toLowerCase() : "";
        for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
            String label = entry.getKey();
            String cat = this.propertyCategoryByLabel.getOrDefault(label, "");
            if (!cat.equals(this.selectedCategory)) continue;
            if (!filter.isEmpty() && !label.toLowerCase().contains(filter)) {
                propertyY += 40;
                continue;
            }
            int editorTop = propertyY;
            int editorBottom = propertyY + 40;
            if (editorBottom > this.contentTopY && editorTop < this.contentBottomY) {
                PropertyEditor editor = entry.getValue();
                int labelX = panelLeft + 10;
                graphics.method_25303(this.field_22793, label, labelX, propertyY, -1);
                String k = this.propertyKeyByLabel.get(label);
                if (k != null) {
                    List<String> lines;
                    int lw = this.field_22793.method_1727(label);
                    if (mouseX >= labelX && mouseX <= labelX + lw && mouseY >= propertyY - 2 && mouseY <= propertyY + 10 && (lines = this.propertyDescriptions.get(k)) != null && !lines.isEmpty()) {
                        this.drawTooltip(graphics, mouseX + 12, mouseY + 12, lines);
                    }
                }
                int edX = panelLeft + 10;
                int edY = propertyY + 12;
                int edW = 280;
                int edH = 20;
                editor.render(graphics, edX, edY, edW, edH, mouseX, mouseY);
                this.visibleEditorSlots.add(new EditorSlot(label, editor, edX, edY, edW, edH));
            }
            propertyY += 40;
        }
        int viewportH = Math.max(0, this.contentBottomY - this.contentTopY);
        int contentH = Math.max(0, propertyY - this.contentTopY);
        this.maxScroll = Math.max(0, contentH - viewportH);
        try {
            graphics.method_44380();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initializePropertyDescriptions() {
        this.propertyDescriptions.clear();
        this.propertyDescriptions.put("extra_quest_shapes", List.of("CSV list of additional shape names to enable.", "Built-ins: square, circle, rsquare, diamond, hexagon, octagon,", "heart, gear, pentagon, star, triangle, oval, cross, shield, arrow.", "Example: diamond, pentagon, hexagon", "Notes: names are case-insensitive; unknown names are ignored."));
        this.propertyDescriptions.put("full_screen_quest", List.of("0 = quest details open in a side panel (default)", "1 = quest details open full-screen"));
        this.propertyDescriptions.put("quest_shade_mode", List.of("Shading style applied over quest backgrounds:", "- none: disable shading", "- linear: directional gradient (uses Quest Shade Direction)", "- radial: center-out gradient"));
        this.propertyDescriptions.put("quest_shade_direction", List.of("Direction for linear mode only:", "down_right, down, right, up_left, up, left, up_right, down_left", "Default: down_right"));
        this.propertyDescriptions.put("quest_shade_strength", List.of("Shading intensity 0.0 \u2013 1.0.", "Typical values: 0.20 \u2013 0.40.", "0 disables shading even if mode is set."));
        this.propertyDescriptions.put("quest_shade_color", List.of("Tint color for the shade (ARGB).", "Use with Shade Strength to control overall darkness and hue.", "Examples: warm = #FF2E1A00, cool = #FF001A2E, neutral = #FF000000"));
        this.propertyDescriptions.put("icon", List.of("Default quest icon when none is supplied.", "Value: resource path or 'builtin'"));
        this.propertyDescriptions.put("quest_view_background", List.of("Background texture for the quest view panel.", "Empty = use default"));
        this.propertyDescriptions.put("quest_not_started_color", List.of("Overlay color for quests that haven't been started."));
        this.propertyDescriptions.put("checkmark_task_active", List.of("Icon shown on tasks that are currently active/being progressed.", "Empty = use default"));
        this.propertyDescriptions.put("checkmark_task_inactive", List.of("Icon shown on tasks that are not currently active.", "Empty = use default"));
    }

    private void drawTooltip(class_332 g, int x, int y, List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        int maxW = 0;
        for (String s : lines) {
            maxW = Math.max(maxW, this.field_22793.method_1727(s));
        }
        int pad = 5;
        int w = maxW + pad * 2;
        int h = lines.size() * 10 + pad * 2;
        g.method_25294(x, y, x + w, y + h, -535489259);
        g.method_25294(x, y, x + w, y + 1, -12566464);
        g.method_25294(x, y + h - 1, x + w, y + h, -12566464);
        g.method_25294(x, y, x + 1, y + h, -12566464);
        g.method_25294(x + w - 1, y, x + w, y + h, -12566464);
        int ty = y + pad;
        for (String s : lines) {
            g.method_25303(this.field_22793, s, x + pad, ty, -1);
            ty += 10;
        }
    }

    private void applyInMemoryThemeFromEditors() {
        try {
            QuestTheme theme;
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("[*]");
            for (Map.Entry<String, PropertyEditor> e : this.propertyEditors.entrySet()) {
                Object val;
                String key = this.propertyKeyByLabel.get(e.getKey());
                if (key == null || (val = e.getValue().getValue()) == null) continue;
                lines.add(key + ": " + this.formatPropertyValue(val));
            }
            QuestTheme.instance = theme = ThemeLoader.parseTheme(lines);
            QuestTheme.instance.clearCache();
        }
        catch (Throwable t) {
            LOGGER.warn("Live apply failed: {}", (Object)t.toString());
        }
    }

    private void renderPreviewPanel(class_332 graphics, int mouseX, int mouseY) {
        int previewX = 10;
        int previewY = 40;
        int previewHeight = this.field_22790 - 80;
        graphics.method_25294(previewX, previewY, previewX + 400, previewY + previewHeight, -536870912);
        graphics.method_25294(previewX, previewY, previewX + 400, previewY + 2, -12566464);
        graphics.method_25300(this.field_22793, "Preview", previewX + 200, previewY + 10, -256);
        this.renderPreviewQuest(graphics, previewX + 50, previewY + 100, mouseX, mouseY);
        this.renderPreviewDependencyLine(graphics, previewX + 50, previewY + 100, previewX + 200, previewY + 200);
        this.renderPreviewQuest(graphics, previewX + 200, previewY + 200, mouseX, mouseY);
    }

    private void renderPreviewQuest(class_332 graphics, int x, int y, int mouseX, int mouseY) {
        int size = 40;
        int pulseColor = AnimationHelper.getPulsingColor(-1);
        graphics.method_25294(x - 1, y - 1, x + size + 1, y + size + 1, pulseColor);
        graphics.method_25294(x, y, x + size, y + size, -12566464);
        try {
            String mode = (String)ThemeProperties.QUEST_SHADE_MODE.get();
            String dir = (String)ThemeProperties.QUEST_SHADE_DIRECTION.get();
            double k = (Double)ThemeProperties.QUEST_SHADE_STRENGTH.get();
            int tint = (Integer)ThemeProperties.QUEST_SHADE_COLOR.get();
            if (k > 0.0 && mode != null && !"none".equalsIgnoreCase(mode)) {
                QuestShape.SQUARE.drawShadeOverlay(graphics, x, y, size, mode, dir, k, tint);
            }
        }
        catch (Throwable mode) {
            // empty catch block
        }
        graphics.method_25294(x + 10, y + 10, x + 30, y + 30, -16711681);
        int indicatorSize = 12;
        graphics.method_25294(x + size - indicatorSize, y, x + size, y + indicatorSize, -16711936);
    }

    private void renderPreviewDependencyLine(class_332 graphics, int x1, int y1, int x2, int y2) {
        float offset = AnimationHelper.DependencyLineAnimation.getLineOffset(true, 0.001);
        int lineColor = AnimationHelper.DependencyLineAnimation.getAnimatedLineColor(-1, false, true);
        graphics.method_25294(x1, y1, x2, y1 + 2, lineColor);
        graphics.method_25294(x2 - 2, y1, x2, y2, lineColor);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseX > (double)(this.field_22789 - 300) && mouseY >= (double)this.contentTopY && mouseY <= (double)this.contentBottomY) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean handledByWidget = super.method_25402(mouseX, mouseY, button);
        if (mouseX > (double)(this.field_22789 - 300) && mouseY >= (double)this.contentTopY && mouseY <= (double)this.contentBottomY) {
            for (EditorSlot s : this.visibleEditorSlots) {
                if (!this.inside(mouseX, mouseY, s)) continue;
                if (s.editor instanceof SliderEditor && button == 0) {
                    float newVal;
                    double ratio = (mouseX - (double)s.x) / (double)Math.max(1, s.w);
                    ratio = Math.max(0.0, Math.min(1.0, ratio));
                    SliderEditor se = (SliderEditor)s.editor;
                    se.current = newVal = (float)((double)se.min + ratio * (double)(se.max - se.min));
                    this.draggingSliderSlot = s;
                    this.draggingSlider = true;
                    this.previewDirty = true;
                    return true;
                }
                if (s.editor instanceof DropdownEditor && button == 0) {
                    DropdownEditor de = (DropdownEditor)s.editor;
                    de.index = (de.index + 1) % de.options.length;
                    this.previewDirty = true;
                    return true;
                }
                if (s.editor instanceof BooleanEditor && button == 0) {
                    BooleanEditor be = (BooleanEditor)s.editor;
                    be.value = !be.value;
                    this.previewDirty = true;
                    return true;
                }
                if (s.editor instanceof ColorEditor && button == 0) {
                    ColorEditor ce = (ColorEditor)s.editor;
                    ce.color = this.nextPaletteColor(ce.color);
                    this.previewDirty = true;
                    return true;
                }
                if (!(s.editor instanceof TextEditor) && !(s.editor instanceof NumberEditor) || button != 0) continue;
                this.openInlineTextEditor(s);
                return true;
            }
            return handledByWidget;
        }
        return handledByWidget;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingSlider && this.draggingSliderSlot != null && this.draggingSliderSlot.editor instanceof SliderEditor && mouseX > (double)(this.field_22789 - 300) && mouseY >= (double)this.contentTopY && mouseY <= (double)this.contentBottomY) {
            EditorSlot s = this.draggingSliderSlot;
            SliderEditor se = (SliderEditor)s.editor;
            double ratio = (mouseX - (double)s.x) / (double)Math.max(1, s.w);
            ratio = Math.max(0.0, Math.min(1.0, ratio));
            se.current = (float)((double)se.min + ratio * (double)(se.max - se.min));
            this.previewDirty = true;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingSlider = false;
        this.draggingSliderSlot = null;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.activeTextEditor != null) {
            if (keyCode == 257 || keyCode == 335) {
                this.commitInlineTextEditor();
                return true;
            }
            if (keyCode == 256) {
                this.cancelInlineTextEditor();
                return true;
            }
            if (keyCode == 32) {
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void openInlineTextEditor(EditorSlot slot) {
        String seed;
        this.cancelInlineTextEditor();
        this.activeTextSlot = slot;
        PropertyEditor propertyEditor = slot.editor;
        if (propertyEditor instanceof TextEditor) {
            TextEditor te = (TextEditor)propertyEditor;
            seed = te.text;
        } else {
            propertyEditor = slot.editor;
            if (propertyEditor instanceof NumberEditor) {
                NumberEditor ne = (NumberEditor)propertyEditor;
                seed = ne.text;
            } else {
                seed = "";
            }
        }
        this.activeTextEditor = new class_342(this.field_22793, slot.x, slot.y, slot.w, slot.h, (class_2561)class_2561.method_43470((String)"Value"));
        this.activeTextEditor.method_1852(seed);
        this.method_37063((class_364)this.activeTextEditor);
        this.method_25395((class_364)this.activeTextEditor);
    }

    private void commitInlineTextEditor() {
        if (this.activeTextSlot != null && this.activeTextEditor != null) {
            if (this.activeTextSlot.editor instanceof TextEditor) {
                ((TextEditor)this.activeTextSlot.editor).text = this.activeTextEditor.method_1882();
                this.previewDirty = true;
            } else if (this.activeTextSlot.editor instanceof NumberEditor) {
                ((NumberEditor)this.activeTextSlot.editor).text = this.activeTextEditor.method_1882();
                this.previewDirty = true;
            }
        }
        this.removeInlineTextEditor();
    }

    private void cancelInlineTextEditor() {
        this.removeInlineTextEditor();
    }

    private void removeInlineTextEditor() {
        if (this.activeTextEditor != null) {
            this.method_37066((class_364)this.activeTextEditor);
            this.activeTextEditor = null;
            this.activeTextSlot = null;
        }
    }

    private boolean inside(double mx, double my, EditorSlot s) {
        return mx >= (double)s.x && mx <= (double)(s.x + s.w) && my >= (double)s.y && my <= (double)(s.y + s.h);
    }

    private int nextPaletteColor(int current) {
        int[] palette = new int[]{-1, -16777216, -65536, -16711936, -16776961, -256, -16711681, -65281, -8355712, -12566464};
        for (int i = 0; i < palette.length; ++i) {
            if (palette[i] != current) continue;
            return palette[(i + 1) % palette.length];
        }
        return palette[0];
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void loadNextPreset() {
        block13: {
            try {
                if (this.field_22787 == null) {
                    return;
                }
                String name = BUILTIN_PRESETS[this.presetIndex];
                this.presetIndex = (this.presetIndex + 1) % BUILTIN_PRESETS.length;
                class_2960 rl = new class_2960("questory", "presets/" + name + ".txt");
                class_3300 rm = this.field_22787.method_1478();
                Optional res = rm.method_14486(rl);
                if (res.isPresent()) {
                    List<String> lines;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)res.get()).method_14482(), StandardCharsets.UTF_8));){
                        lines = reader.lines().toList();
                    }
                    QuestTheme.instance = this.currentTheme = ThemeLoader.parseTheme(lines);
                    QuestTheme.instance.clearCache();
                    this.themeName = name;
                    if (this.themeNameBox != null) {
                        this.themeNameBox.method_1852(this.themeName);
                    }
                    this.previewDirty = true;
                    if (this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Loaded preset: " + name)));
                    }
                    break block13;
                }
                if (this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Preset not found: " + name)));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load preset", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block13;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to load preset: " + e.getMessage())));
            }
        }
    }

    private void exportThemeJson() {
        block4: {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                JsonObject root = new JsonObject();
                root.addProperty("name", this.themeNameBox != null ? this.themeNameBox.method_1882() : this.themeName);
                JsonObject props = new JsonObject();
                for (Map.Entry<String, PropertyEditor> e : this.propertyEditors.entrySet()) {
                    String display = e.getKey();
                    Object v = e.getValue().getValue();
                    if (v == null) continue;
                    props.add(display, this.toJsonPrimitive(v));
                }
                root.add("properties", (JsonElement)props);
                Path dir = Paths.get("config", "questory", "themes");
                Files.createDirectories(dir, new FileAttribute[0]);
                Path out = dir.resolve((this.themeNameBox != null ? this.themeNameBox.method_1882() : this.themeName) + ".json");
                Files.writeString(out, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Exported JSON: " + String.valueOf(out.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to export JSON", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block4;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to export JSON: " + e.getMessage())));
            }
        }
    }

    private void importThemeJson() {
        block18: {
            Gson gson = new GsonBuilder().create();
            try {
                JsonObject props;
                String name;
                Path dir = Paths.get("config", "questory", "themes");
                if (!Files.exists(dir, new LinkOption[0])) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("No themes dir: " + String.valueOf(dir))));
                    }
                    return;
                }
                Path chosen = null;
                try (Stream<Path> stream = Files.list(dir);){
                    Iterator<Path> iterator = stream.filter(p -> p.toString().endsWith(".json")).toList().iterator();
                    if (iterator.hasNext()) {
                        Path p2;
                        chosen = p2 = iterator.next();
                    }
                }
                if (chosen == null) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"No JSON themes found"));
                    }
                    return;
                }
                String content = Files.readString(chosen);
                JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
                this.themeName = name = root.has("name") ? root.get("name").getAsString() : "imported_theme";
                if (this.themeNameBox != null) {
                    this.themeNameBox.method_1852(name);
                }
                if ((props = root.getAsJsonObject("properties")) != null) {
                    for (Map.Entry e : props.entrySet()) {
                        PropertyEditor ed = this.propertyEditors.get(e.getKey());
                        if (ed == null) continue;
                        ed.setValue(this.fromJsonPrimitive((JsonElement)e.getValue()));
                    }
                }
                this.previewDirty = true;
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Imported JSON: " + String.valueOf(chosen.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to import JSON", (Throwable)e);
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block18;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Failed to import JSON: " + e.getMessage())));
            }
        }
    }

    private JsonElement toJsonPrimitive(Object v) {
        if (v instanceof Integer) {
            Integer i = (Integer)v;
            return new JsonPrimitive((Number)i);
        }
        if (v instanceof Float) {
            Float f = (Float)v;
            return new JsonPrimitive((Number)f);
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return new JsonPrimitive(b);
        }
        return new JsonPrimitive(String.valueOf(v));
    }

    private Object fromJsonPrimitive(JsonElement el) {
        if (el != null && el.isJsonPrimitive()) {
            JsonPrimitive prim = el.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isNumber()) {
                double d = prim.getAsDouble();
                if (Math.floor(d) == d) {
                    return (int)d;
                }
                return Float.valueOf((float)d);
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
        }
        return null;
    }

    private static class EditorSlot {
        final String label;
        final PropertyEditor editor;
        final int x;
        final int y;
        final int w;
        final int h;

        EditorSlot(String label, PropertyEditor editor, int x, int y, int w, int h) {
            this.label = label;
            this.editor = editor;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }

    private static class DropdownEditor
    extends PropertyEditor {
        private final String[] options;
        private int index = 0;

        public DropdownEditor(String name, String seed, String[] options) {
            super(name);
            this.options = options;
            if (seed != null) {
                for (int i = 0; i < options.length; ++i) {
                    if (!options[i].equalsIgnoreCase(seed)) continue;
                    this.index = i;
                    break;
                }
            }
        }

        @Override
        public void render(class_332 g, int x, int y, int w, int h, int mouseX, int mouseY) {
            g.method_25294(x, y, x + w, y + h, -14671840);
            String text = this.options[Math.max(0, Math.min(this.index, this.options.length - 1))];
            g.method_25303(class_310.method_1551().field_1772, text, x + 4, y + h / 2 - 4, -1);
            g.method_25303(class_310.method_1551().field_1772, "\u25be", x + w - 10, y + h / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.options[this.index];
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                String s = (String)value;
                for (int i = 0; i < this.options.length; ++i) {
                    if (!this.options[i].equalsIgnoreCase(s)) continue;
                    this.index = i;
                    break;
                }
            }
        }
    }

    private static class ColorEditor
    extends PropertyEditor {
        private int color;

        public ColorEditor(String name, int defaultColor) {
            super(name);
            this.color = defaultColor;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + height, y + height, this.color);
            graphics.method_25294(x, y, x + height, y + 1, -1);
            graphics.method_25294(x, y, x + 1, y + height, -1);
            graphics.method_25294(x + height - 1, y, x + height, y + height, -1);
            graphics.method_25294(x, y + height - 1, x + height, y + height, -1);
            String hexStr = String.format("#%08X", this.color);
            graphics.method_25303(class_310.method_1551().field_1772, hexStr, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.color;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Integer) {
                this.color = (Integer)value;
            }
        }
    }

    private static class NumberEditor
    extends PropertyEditor {
        private String text;
        private final boolean isInt;

        public NumberEditor(String name, String initial, boolean isInt) {
            super(name);
            this.text = initial == null ? "0" : initial;
            this.isInt = isInt;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + width, y + height, -14671840);
            graphics.method_25303(class_310.method_1551().field_1772, this.text, x + 2, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            try {
                if (this.isInt) {
                    return Integer.parseInt(this.text.trim());
                }
                return Double.parseDouble(this.text.trim());
            }
            catch (Exception e) {
                return this.isInt ? 0.0 : 0.0;
            }
        }

        @Override
        public void setValue(Object value) {
            this.text = value == null ? "" : String.valueOf(value);
        }
    }

    private static class TextEditor
    extends PropertyEditor {
        private String text;

        public TextEditor(String name, String defaultValue) {
            super(name);
            this.text = defaultValue;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + width, y + height, -14671840);
            graphics.method_25303(class_310.method_1551().field_1772, this.text, x + 2, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.text;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.text = (String)value;
            }
        }
    }

    private static abstract class PropertyEditor {
        protected String propertyName;

        public PropertyEditor(String propertyName) {
            this.propertyName = propertyName;
        }

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public abstract Object getValue();

        public abstract void setValue(Object var1);
    }

    private static class SliderEditor
    extends PropertyEditor {
        private float min;
        private float max;
        private float current;

        public SliderEditor(String name, float min, float max, float defaultValue) {
            super(name);
            this.min = min;
            this.max = max;
            this.current = defaultValue;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y + height / 2 - 2, x + width, y + height / 2 + 2, -12566464);
            int handleX = (int)((float)x + (this.current - this.min) / (this.max - this.min) * (float)width);
            graphics.method_25294(handleX - 3, y, handleX + 3, y + height, -1);
            String valueStr = String.format("%.2f", Float.valueOf(this.current));
            graphics.method_25303(class_310.method_1551().field_1772, valueStr, x + width + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.current);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                this.current = ((Number)value).floatValue();
            }
        }
    }

    private static class BooleanEditor
    extends PropertyEditor {
        private boolean value;

        public BooleanEditor(String name, boolean defaultValue) {
            super(name);
            this.value = defaultValue;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.method_25294(x, y, x + height, y + height, this.value ? -16711936 : -12566464);
            graphics.method_25294(x, y, x + height, y + 1, -1);
            graphics.method_25294(x, y, x + 1, y + height, -1);
            graphics.method_25294(x + height - 1, y, x + height, y + height, -1);
            graphics.method_25294(x, y + height - 1, x + height, y + height, -1);
            String label = this.value ? "Enabled" : "Disabled";
            graphics.method_25303(class_310.method_1551().field_1772, label, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                this.value = (Boolean)value;
            }
        }
    }
}

