/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.editor.AutoSaveManager;

public class AutoSaveConfigScreen
extends class_437 {
    private final class_437 parent;
    private final AutoSaveManager autoSaveManager;
    private class_342 intervalField;
    private class_342 maxAutoSavesField;
    private class_342 purgeDaysField;
    private class_4185 enabledToggleBtn;
    private class_4185 focusLossToggleBtn;
    private class_4185 entitySwitchToggleBtn;
    private class_4185 saveBtn;
    private class_4185 cancelBtn;
    private class_4185 resetBtn;
    private AutoSaveManager.AutoSaveConfig workingConfig;

    public AutoSaveConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Auto-Save Configuration"));
        this.parent = parent;
        this.autoSaveManager = AutoSaveManager.getInstance();
        this.workingConfig = this.autoSaveManager.getConfig().copy();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int startY = 60;
        int fieldWidth = 200;
        int spacing = 35;
        int y = startY;
        this.enabledToggleBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Auto-Save: " + (this.workingConfig.enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), b -> {
            this.workingConfig.enabled = !this.workingConfig.enabled;
            b.method_25355((class_2561)class_2561.method_43470((String)("Auto-Save: " + (this.workingConfig.enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))));
        }).method_46434(centerX - fieldWidth / 2, y, fieldWidth, 20).method_46431());
        this.intervalField = new class_342(this.field_22793, centerX - fieldWidth / 2, y += spacing, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Interval"));
        this.intervalField.method_1852(String.valueOf(this.workingConfig.intervalSeconds));
        this.intervalField.method_47404((class_2561)class_2561.method_43470((String)"Seconds between auto-saves (min: 5)"));
        this.intervalField.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.intervalField);
        this.maxAutoSavesField = new class_342(this.field_22793, centerX - fieldWidth / 2, y += spacing, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Max Auto-Saves"));
        this.maxAutoSavesField.method_1852(String.valueOf(this.workingConfig.maxAutoSaves));
        this.maxAutoSavesField.method_47404((class_2561)class_2561.method_43470((String)"Max auto-save entries per entity"));
        this.maxAutoSavesField.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.maxAutoSavesField);
        this.purgeDaysField = new class_342(this.field_22793, centerX - fieldWidth / 2, y += spacing, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Purge Days"));
        this.purgeDaysField.method_1852(String.valueOf(this.workingConfig.purgeAfterDays));
        this.purgeDaysField.method_47404((class_2561)class_2561.method_43470((String)"Delete auto-saves older than (days)"));
        this.purgeDaysField.method_1890(s -> s.matches("\\d*"));
        this.method_37063((class_364)this.purgeDaysField);
        this.focusLossToggleBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Save on Focus Loss: " + (this.workingConfig.saveOnFocusLoss ? "\u00a7aYes" : "\u00a77No"))), b -> {
            this.workingConfig.saveOnFocusLoss = !this.workingConfig.saveOnFocusLoss;
            b.method_25355((class_2561)class_2561.method_43470((String)("Save on Focus Loss: " + (this.workingConfig.saveOnFocusLoss ? "\u00a7aYes" : "\u00a77No"))));
        }).method_46434(centerX - fieldWidth / 2, y += spacing, fieldWidth, 20).method_46431());
        this.entitySwitchToggleBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Save on Entity Switch: " + (this.workingConfig.saveOnEntitySwitch ? "\u00a7aYes" : "\u00a77No"))), b -> {
            this.workingConfig.saveOnEntitySwitch = !this.workingConfig.saveOnEntitySwitch;
            b.method_25355((class_2561)class_2561.method_43470((String)("Save on Entity Switch: " + (this.workingConfig.saveOnEntitySwitch ? "\u00a7aYes" : "\u00a77No"))));
        }).method_46434(centerX - fieldWidth / 2, y += 25, fieldWidth, 20).method_46431());
        int btnWidth = 90;
        int btnSpacing = 10;
        int totalBtnWidth = btnWidth * 3 + btnSpacing * 2;
        int btnStartX = centerX - totalBtnWidth / 2;
        this.saveBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.save()).method_46434(btnStartX, y += spacing + 20, btnWidth, 20).method_46431());
        this.resetBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset Defaults"), b -> this.resetDefaults()).method_46434(btnStartX + btnWidth + btnSpacing, y, btnWidth, 20).method_46431());
        this.cancelBtn = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.method_25419()).method_46434(btnStartX + (btnWidth + btnSpacing) * 2, y, btnWidth, 20).method_46431());
        y += spacing + 10;
    }

    private void save() {
        block9: {
            try {
                int newInterval = Integer.parseInt(this.intervalField.method_1882());
                int newMaxAutoSaves = Integer.parseInt(this.maxAutoSavesField.method_1882());
                int newPurgeDays = Integer.parseInt(this.purgeDaysField.method_1882());
                if (newInterval < 5) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cInterval must be at least 5 seconds"));
                    }
                    return;
                }
                if (newMaxAutoSaves < 1) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cMax auto-saves must be at least 1"));
                    }
                    return;
                }
                if (newPurgeDays < 1) {
                    if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cPurge days must be at least 1"));
                    }
                    return;
                }
                this.workingConfig.intervalSeconds = newInterval;
                this.workingConfig.maxAutoSaves = newMaxAutoSaves;
                this.workingConfig.purgeAfterDays = newPurgeDays;
                this.autoSaveManager.updateConfig(this.workingConfig);
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7aAuto-save configuration saved"));
                }
                this.method_25419();
            }
            catch (NumberFormatException e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block9;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7cInvalid number format"));
            }
        }
    }

    private void resetDefaults() {
        this.workingConfig.enabled = true;
        this.workingConfig.intervalSeconds = 30;
        this.workingConfig.maxAutoSaves = 5;
        this.workingConfig.purgeAfterDays = 7;
        this.workingConfig.saveOnFocusLoss = false;
        this.workingConfig.saveOnEntitySwitch = true;
        this.enabledToggleBtn.method_25355((class_2561)class_2561.method_43470((String)"Auto-Save: \u00a7aEnabled"));
        this.intervalField.method_1852("30");
        this.maxAutoSavesField.method_1852("5");
        this.purgeDaysField.method_1852("7");
        this.focusLossToggleBtn.method_25355((class_2561)class_2561.method_43470((String)"Save on Focus Loss: \u00a77No"));
        this.entitySwitchToggleBtn.method_25355((class_2561)class_2561.method_43470((String)"Save on Entity Switch: \u00a7aYes"));
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
        int centerX = this.field_22789 / 2;
        int fieldWidth = 200;
        int labelX = centerX - fieldWidth / 2;
        g.method_25303(this.field_22793, "Enable/Disable:", labelX, 53, -5592406);
        g.method_25303(this.field_22793, "Interval (seconds):", labelX, 88, -5592406);
        g.method_25303(this.field_22793, "Max Auto-Saves:", labelX, 123, -5592406);
        g.method_25303(this.field_22793, "Purge After (days):", labelX, 158, -5592406);
        int infoY = 310;
        int infoWidth = 450;
        int infoX = this.field_22789 / 2 - infoWidth / 2;
        g.method_25294(infoX, infoY, infoX + infoWidth, infoY + 90, -1442840576);
        String[] infoLines = new String[]{"\u00a77Auto-Save Configuration", "\u00a7fInterval: How often editors auto-save (min: 5s)", "\u00a7fMax Auto-Saves: Number of auto-save entries per entity", "\u00a7fPurge Days: Delete auto-saves older than this many days", "\u00a7fFocus Loss: Save when editor loses focus (experimental)", "\u00a7fEntity Switch: Save when switching between entities (recommended)", "\u00a7fChanges apply immediately to all open editors"};
        int lineY = infoY + 8;
        for (String line : infoLines) {
            g.method_25303(this.field_22793, line, infoX + 8, lineY, -1);
            lineY += 11;
        }
        String status = this.autoSaveManager.getStatusString();
        g.method_25300(this.field_22793, "\u00a77Current Status: \u00a7f" + status, this.field_22789 / 2, this.field_22790 - 30, -1);
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return true;
    }
}

