/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import org.texboobcat.questory.client.gui.editor.ChangeTracker;

public class EditorStateManager<T> {
    private static final Gson GSON = new GsonBuilder().create();
    private T workingCopy;
    private T originalCopy;
    private String entityId;
    private boolean isDirty;
    private long lastModifiedTime;
    private final ChangeTracker changeTracker;
    private final Function<T, T> cloneFunction;
    private final Function<T, String> idExtractor;
    private final Stack<T> undoStack = new Stack();
    private final Stack<T> redoStack = new Stack();
    private static final int MAX_HISTORY = 50;

    public EditorStateManager(Function<T, T> cloneFunction, Function<T, String> idExtractor) {
        this.changeTracker = new ChangeTracker();
        this.cloneFunction = cloneFunction;
        this.idExtractor = idExtractor;
        this.isDirty = false;
        this.lastModifiedTime = 0L;
    }

    public void load(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Cannot load null entity");
        }
        this.originalCopy = this.cloneFunction.apply(entity);
        this.workingCopy = this.cloneFunction.apply(entity);
        this.entityId = this.idExtractor.apply(entity);
        this.isDirty = false;
        this.lastModifiedTime = System.currentTimeMillis();
        this.changeTracker.reset();
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public void markDirty() {
        if (!this.isDirty) {
            this.isDirty = true;
            this.lastModifiedTime = System.currentTimeMillis();
        }
    }

    public void markClean() {
        this.isDirty = false;
        this.changeTracker.commitChanges();
    }

    public boolean hasUnsavedChanges() {
        return this.isDirty || this.changeTracker.hasChanges();
    }

    public T getWorkingCopy() {
        return this.workingCopy;
    }

    public T getOriginalCopy() {
        return this.originalCopy;
    }

    public void setWorkingCopy(T newWorkingCopy) {
        this.pushSnapshot();
        this.workingCopy = newWorkingCopy;
        this.entityId = this.idExtractor.apply(newWorkingCopy);
        this.markDirty();
    }

    public void pushSnapshot() {
        if (this.workingCopy != null) {
            this.undoStack.push(this.cloneFunction.apply(this.workingCopy));
            if (this.undoStack.size() > 50) {
                this.undoStack.remove(0);
            }
            this.redoStack.clear();
        }
    }

    public void popUndo() {
        if (!this.undoStack.isEmpty()) {
            this.undoStack.pop();
        }
    }

    public boolean undo() {
        if (this.undoStack.isEmpty()) {
            return false;
        }
        this.redoStack.push(this.cloneFunction.apply(this.workingCopy));
        this.workingCopy = this.undoStack.pop();
        this.entityId = this.idExtractor.apply(this.workingCopy);
        this.markDirty();
        return true;
    }

    public boolean redo() {
        if (this.redoStack.isEmpty()) {
            return false;
        }
        this.undoStack.push(this.cloneFunction.apply(this.workingCopy));
        this.workingCopy = this.redoStack.pop();
        this.entityId = this.idExtractor.apply(this.workingCopy);
        this.markDirty();
        return true;
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    public void resetToOriginal() {
        this.workingCopy = this.cloneFunction.apply(this.originalCopy);
        this.isDirty = false;
        this.changeTracker.revertChanges();
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public Map<String, Object> getChangedFields() {
        return this.changeTracker.getChangedValues();
    }

    public void commitAsOriginal() {
        this.originalCopy = this.cloneFunction.apply(this.workingCopy);
        this.isDirty = false;
        this.changeTracker.commitChanges();
    }

    public boolean isLoaded() {
        return this.workingCopy != null && this.originalCopy != null;
    }

    public String getDebugSummary() {
        return String.format("EditorStateManager[id=%s, dirty=%s, changes=%d, undo=%d, redo=%d]", this.entityId, this.isDirty, this.changeTracker.getChangeCount(), this.undoStack.size(), this.redoStack.size());
    }

    public void clear() {
        this.workingCopy = null;
        this.originalCopy = null;
        this.entityId = null;
        this.isDirty = false;
        this.lastModifiedTime = 0L;
        this.changeTracker.reset();
        this.undoStack.clear();
        this.redoStack.clear();
    }
}

