/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.client.gui.editor.EditorNotification;

public class EditorStatusBar {
    private String message;
    private EditorNotification.Type type;
    private List<String> details;
    private boolean expanded;
    private class_4185 expandButton;
    private int x;
    private int y;
    private int width;
    private int height;
    private static final int BASE_HEIGHT = 24;
    private static final int DETAIL_LINE_HEIGHT = 12;
    private static final int PADDING = 6;

    public EditorStatusBar(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = 24;
        this.details = new ArrayList<String>();
        this.expanded = false;
    }

    public void setSuccess(String message) {
        this.message = message;
        this.type = EditorNotification.Type.SUCCESS;
        this.details.clear();
        this.expanded = false;
        this.updateHeight();
    }

    public void setError(String message, List<String> errorDetails) {
        this.message = message;
        this.type = EditorNotification.Type.ERROR;
        this.details = errorDetails != null ? new ArrayList<String>(errorDetails) : new ArrayList();
        this.expanded = !this.details.isEmpty();
        this.updateHeight();
    }

    public void setWarning(String message, List<String> warningDetails) {
        this.message = message;
        this.type = EditorNotification.Type.WARNING;
        this.details = warningDetails != null ? new ArrayList<String>(warningDetails) : new ArrayList();
        this.expanded = false;
        this.updateHeight();
    }

    public void clear() {
        this.message = null;
        this.type = null;
        this.details.clear();
        this.expanded = false;
        this.updateHeight();
    }

    public boolean hasContent() {
        return this.message != null && !this.message.isEmpty();
    }

    public void toggleExpand() {
        if (!this.details.isEmpty()) {
            this.expanded = !this.expanded;
            this.updateHeight();
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    private void updateHeight() {
        this.height = !this.hasContent() ? 0 : (this.expanded && !this.details.isEmpty() ? 24 + this.details.size() * 12 + 6 : 24);
    }

    public void render(class_332 graphics, class_327 font, int mouseX, int mouseY) {
        if (!this.hasContent()) {
            return;
        }
        int bgColor = 0xFF000000 | (this.type == EditorNotification.Type.ERROR ? 3806485 : (this.type == EditorNotification.Type.WARNING ? 3811861 : (this.type == EditorNotification.Type.SUCCESS ? 1391125 : 1381690)));
        int borderColor = 0xFF000000 | (this.type == EditorNotification.Type.ERROR ? 8333866 : (this.type == EditorNotification.Type.WARNING ? 8344832 : (this.type == EditorNotification.Type.SUCCESS ? 2785066 : 2763391)));
        int textColor = 0xFF000000 | (this.type == EditorNotification.Type.ERROR ? 0xFF5555 : (this.type == EditorNotification.Type.WARNING ? 0xFFAA00 : (this.type == EditorNotification.Type.SUCCESS ? 0x55FF55 : 0x5555FF)));
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, borderColor);
        graphics.method_25294(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, bgColor);
        int iconX = this.x + 6;
        Objects.requireNonNull(font);
        int iconY = this.y + (24 - 9) / 2;
        graphics.method_51433(font, this.type.icon, iconX, iconY, textColor, false);
        int textX = iconX + font.method_1727(this.type.icon) + 6;
        int maxTextWidth = this.width - (textX - this.x) - 6 - 40;
        class_2561 formattedMessage = TextFormatter.parseToComponent(this.message);
        Object plainText = formattedMessage.getString();
        if (font.method_1727((String)plainText) > maxTextWidth) {
            plainText = font.method_27524((String)plainText, maxTextWidth - 10, false) + "...";
            formattedMessage = class_2561.method_43470((String)plainText);
        }
        graphics.method_51439(font, formattedMessage, textX, iconY, -1, true);
        if (!this.details.isEmpty()) {
            String expandIcon = this.expanded ? "\u25bc" : "\u25b6";
            int expandX = this.x + this.width - 6 - font.method_1727(expandIcon) - 4;
            graphics.method_51433(font, expandIcon, expandX, iconY, -3355444, false);
            String countText = "(" + this.details.size() + ")";
            int countX = expandX - font.method_1727(countText) - 6;
            graphics.method_51433(font, countText, countX, iconY, -5592406, false);
        }
        if (this.expanded && !this.details.isEmpty()) {
            int detailY = this.y + 24 + 3;
            int detailX = this.x + 6 + 16;
            for (String detail : this.details) {
                class_2561 formattedDetail = TextFormatter.parseToComponent(detail);
                Object plainDetail = formattedDetail.getString();
                int maxDetailWidth = this.width - (detailX - this.x) - 6;
                if (font.method_1727((String)plainDetail) > maxDetailWidth) {
                    plainDetail = font.method_27524((String)plainDetail, maxDetailWidth - 10, false) + "...";
                    formattedDetail = class_2561.method_43470((String)plainDetail);
                }
                graphics.method_51433(font, "\u2022", detailX - 10, detailY, -7829368, false);
                graphics.method_51439(font, formattedDetail, detailX, detailY, -3355444, false);
                detailY += 12;
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.hasContent()) {
            return false;
        }
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 24) && !this.details.isEmpty()) {
            this.toggleExpand();
            return true;
        }
        return false;
    }
}

