/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;

public class AdvancedSearchFilter {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\"([^\"]*)\"|(/[^/]+/)|([^\\s]+)");
    private final String originalQuery;
    private final List<FilterTerm> terms;
    private final boolean isEmpty;

    private AdvancedSearchFilter(String query, List<FilterTerm> terms) {
        this.originalQuery = query;
        this.terms = terms;
        this.isEmpty = query == null || query.trim().isEmpty();
    }

    public static AdvancedSearchFilter parse(String query) {
        if (query == null || query.trim().isEmpty()) {
            return new AdvancedSearchFilter("", Collections.emptyList());
        }
        String normalized = query.trim().toLowerCase();
        ArrayList<FilterTerm> terms = new ArrayList<FilterTerm>();
        List<String> orGroups = AdvancedSearchFilter.splitByOr(normalized);
        for (String orGroup : orGroups) {
            List<String> andTerms = AdvancedSearchFilter.splitByAnd(orGroup);
            ArrayList<FilterTerm> groupTerms = new ArrayList<FilterTerm>();
            for (String token : andTerms) {
                FilterTerm term = AdvancedSearchFilter.parseToken(token.trim());
                if (term == null) continue;
                groupTerms.add(term);
            }
            if (groupTerms.isEmpty()) continue;
            if (groupTerms.size() > 1) {
                terms.add(new AndFilterTerm(groupTerms));
                continue;
            }
            terms.add((FilterTerm)groupTerms.get(0));
        }
        return new AdvancedSearchFilter(query, terms);
    }

    private static List<String> splitByOr(String query) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        boolean inRegex = false;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '\"' && (i == 0 || query.charAt(i - 1) != '\\')) {
                inQuotes = !inQuotes;
                current.append(c);
                continue;
            }
            if (c == '/' && !inQuotes) {
                inRegex = !inRegex;
                current.append(c);
                continue;
            }
            if (c == '|' && !inQuotes && !inRegex) {
                if (current.length() <= 0) continue;
                result.add(current.toString().trim());
                current = new StringBuilder();
                continue;
            }
            if (i + 3 <= query.length() && query.substring(i, i + 3).equals(" or ") && !inQuotes && !inRegex) {
                if (current.length() > 0) {
                    result.add(current.toString().trim());
                    current = new StringBuilder();
                }
                i += 2;
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString().trim());
        }
        return result.isEmpty() ? Collections.singletonList(query) : result;
    }

    private static List<String> splitByAnd(String query) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = TOKEN_PATTERN.matcher(query);
        while (m.find()) {
            String t;
            String token = null;
            if (m.group(1) != null) {
                token = m.group(1);
            } else if (m.group(2) != null) {
                token = m.group(2);
            } else if (m.group(3) != null && !(t = m.group(3)).equalsIgnoreCase("and") && !t.equals("&")) {
                token = t;
            }
            if (token == null || token.isBlank()) continue;
            result.add(token.trim());
        }
        return result;
    }

    private static FilterTerm parseToken(String token) {
        if (token.isEmpty()) {
            return null;
        }
        boolean isNot = false;
        String value = token;
        if (token.startsWith("!") || token.startsWith("-")) {
            isNot = true;
            value = token.substring(1);
            if (value.isEmpty()) {
                return null;
            }
        }
        if (value.startsWith("/") && value.endsWith("/") && value.length() > 2) {
            String pattern = value.substring(1, value.length() - 1);
            try {
                Pattern regex = Pattern.compile(pattern, 2);
                return new RegexFilterTerm(regex, isNot);
            }
            catch (PatternSyntaxException e) {
                return new LiteralFilterTerm(value, isNot);
            }
        }
        if (value.startsWith("#")) {
            String tagValue = value.substring(1);
            return new FieldFilterTerm("tag", tagValue, isNot);
        }
        int colonIdx = value.indexOf(58);
        if (colonIdx > 0 && colonIdx < value.length() - 1) {
            String field = value.substring(0, colonIdx);
            String fieldValue = value.substring(colonIdx + 1);
            field = AdvancedSearchFilter.normalizeFieldName(field);
            return new FieldFilterTerm(field, fieldValue, isNot);
        }
        if (value.contains("*") || value.contains("?")) {
            return new WildcardFilterTerm(value, isNot);
        }
        return new LiteralFilterTerm(value, isNot);
    }

    private static String normalizeFieldName(String field) {
        return switch (field) {
            case "g" -> "group";
            case "t" -> "tag";
            case "c", "chap", "chapterid" -> "chapter";
            case "name" -> "title";
            default -> field;
        };
    }

    public boolean matchesQuest(Quest quest, Map<String, String> chapterIdToTitle, QuestProgress progress) {
        if (this.isEmpty) {
            return true;
        }
        Map<String, Object> fields = this.buildQuestFields(quest, chapterIdToTitle, progress);
        for (FilterTerm term : this.terms) {
            if (!term.matches(fields)) continue;
            return true;
        }
        return this.terms.isEmpty();
    }

    private Map<String, Object> buildQuestFields(Quest quest, Map<String, String> chapterIdToTitle, QuestProgress progress) {
        String ct;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("id", quest.getId() == null ? "" : quest.getId().toLowerCase());
        fields.put("title", quest.getTitle() == null ? "" : quest.getTitle().toLowerCase());
        fields.put("group", quest.getGroup() == null ? "" : quest.getGroup().toLowerCase());
        String chapterId = quest.getChapterId();
        fields.put("chapterid", chapterId == null ? "" : chapterId.toLowerCase());
        String chapterTitle = "";
        if (chapterId != null && chapterIdToTitle != null && (ct = chapterIdToTitle.get(chapterId.toLowerCase())) != null) {
            chapterTitle = ct.toLowerCase();
        }
        fields.put("chapter", chapterTitle);
        List tags = quest.getTags() == null ? Collections.emptyList() : quest.getTags().stream().map(String::toLowerCase).collect(Collectors.toList());
        fields.put("tags", tags);
        boolean isCompleted = progress != null && progress.isQuestCompleted(quest.getId());
        boolean isVisible = progress == null || quest.isVisible(progress);
        boolean isOptional = quest.isOptional();
        fields.put("is:completed", isCompleted);
        fields.put("is:incomplete", !isCompleted);
        fields.put("is:visible", isVisible);
        fields.put("is:hidden", !isVisible);
        fields.put("is:invisible", !isVisible);
        fields.put("is:optional", isOptional);
        fields.put("is:required", !isOptional);
        fields.put("is:mandatory", !isOptional);
        return fields;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private static interface FilterTerm {
        public boolean matches(Map<String, Object> var1);
    }

    private static class AndFilterTerm
    implements FilterTerm {
        private final List<FilterTerm> terms;

        AndFilterTerm(List<FilterTerm> terms) {
            this.terms = terms;
        }

        @Override
        public boolean matches(Map<String, Object> fields) {
            for (FilterTerm term : this.terms) {
                if (term.matches(fields)) continue;
                return false;
            }
            return true;
        }
    }

    private static class RegexFilterTerm
    implements FilterTerm {
        private final Pattern pattern;
        private final boolean isNot;

        RegexFilterTerm(Pattern pattern, boolean isNot) {
            this.pattern = pattern;
            this.isNot = isNot;
        }

        @Override
        public boolean matches(Map<String, Object> fields) {
            Object tagsObj;
            boolean found = false;
            for (String field : Arrays.asList("id", "title", "group", "chapter", "chapterid")) {
                String str;
                Object val = fields.get(field);
                if (!(val instanceof String) || !this.pattern.matcher(str = (String)val).find()) continue;
                found = true;
                break;
            }
            if (!found && (tagsObj = fields.get("tags")) instanceof List) {
                List tags = (List)tagsObj;
                for (Object tag : tags) {
                    String str;
                    if (!(tag instanceof String) || !this.pattern.matcher(str = (String)tag).find()) continue;
                    found = true;
                    break;
                }
            }
            return this.isNot ? !found : found;
        }
    }

    private static class LiteralFilterTerm
    implements FilterTerm {
        private final String value;
        private final boolean isNot;

        LiteralFilterTerm(String value, boolean isNot) {
            this.value = value.toLowerCase();
            this.isNot = isNot;
        }

        @Override
        public boolean matches(Map<String, Object> fields) {
            Object tagsObj;
            boolean found = false;
            for (String field : Arrays.asList("id", "title", "group", "chapter")) {
                String str;
                Object val = fields.get(field);
                if (!(val instanceof String) || !(str = (String)val).contains(this.value)) continue;
                found = true;
                break;
            }
            if (!found && (tagsObj = fields.get("tags")) instanceof List) {
                List tags = (List)tagsObj;
                for (Object tag : tags) {
                    String str;
                    if (!(tag instanceof String) || !(str = (String)tag).contains(this.value)) continue;
                    found = true;
                    break;
                }
            }
            return this.isNot ? !found : found;
        }
    }

    private static class FieldFilterTerm
    implements FilterTerm {
        private final String field;
        private final String value;
        private final boolean isNot;

        FieldFilterTerm(String field, String value, boolean isNot) {
            this.field = field.toLowerCase();
            this.value = value.toLowerCase();
            this.isNot = isNot;
        }

        @Override
        public boolean matches(Map<String, Object> fields) {
            boolean found = false;
            if (this.field.equals("is")) {
                String stateKey = "is:" + this.value;
                Object stateVal = fields.get(stateKey);
                if (stateVal instanceof Boolean) {
                    Boolean bool = (Boolean)stateVal;
                    found = bool;
                }
            } else if (this.field.equals("tag")) {
                Object tagsObj = fields.get("tags");
                if (tagsObj instanceof List) {
                    List tags = (List)tagsObj;
                    for (Object tag : tags) {
                        String str;
                        if (!(tag instanceof String) || !(str = (String)tag).contains(this.value)) continue;
                        found = true;
                        break;
                    }
                }
            } else {
                Object fieldVal = fields.get(this.field);
                if (fieldVal instanceof String) {
                    String str = (String)fieldVal;
                    found = str.contains(this.value);
                } else if (fieldVal instanceof Boolean) {
                    Boolean bool = (Boolean)fieldVal;
                    if (this.value.equals("true") || this.value.equals("yes")) {
                        found = bool;
                    } else if (this.value.equals("false") || this.value.equals("no")) {
                        boolean bl = found = bool == false;
                    }
                }
            }
            return this.isNot ? !found : found;
        }
    }

    private static class WildcardFilterTerm
    implements FilterTerm {
        private final Pattern pattern;
        private final boolean isNot;

        WildcardFilterTerm(String wildcard, boolean isNot) {
            this.isNot = isNot;
            String regex = Pattern.quote(wildcard).replace("\\*", ".*").replace("\\?", ".");
            this.pattern = Pattern.compile(regex, 2);
        }

        @Override
        public boolean matches(Map<String, Object> fields) {
            Object tagsObj;
            boolean found = false;
            for (String field : Arrays.asList("id", "title", "group", "chapter", "chapterid")) {
                String str;
                Object val = fields.get(field);
                if (!(val instanceof String) || !this.pattern.matcher(str = (String)val).matches()) continue;
                found = true;
                break;
            }
            if (!found && (tagsObj = fields.get("tags")) instanceof List) {
                List tags = (List)tagsObj;
                for (Object tag : tags) {
                    String str;
                    if (!(tag instanceof String) || !this.pattern.matcher(str = (String)tag).matches()) continue;
                    found = true;
                    break;
                }
            }
            return this.isNot ? !found : found;
        }
    }
}

