/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.texboobcat.questory.shape.ShapeDef;

public class ShapeTessellator {
    public static Mesh buildMesh(ShapeDef def) {
        if (def == null || def.paths == null || def.paths.isEmpty()) {
            return null;
        }
        for (ShapeDef.Path p : def.paths) {
            float[] tris;
            List<double[]> boundary;
            if (!p.fill) continue;
            if ((boundary = (switch (p.type == null ? "polygon" : p.type.toLowerCase()) {
                case "polygon" -> ShapeTessellator.toPairs(p.points);
                case "circle" -> ShapeTessellator.approxCircle(p.num.getOrDefault("cx", 0.5), p.num.getOrDefault("cy", 0.5), p.num.getOrDefault("r", 0.48), 48);
                case "ellipse" -> ShapeTessellator.approxEllipse(p.num.getOrDefault("cx", 0.5), p.num.getOrDefault("cy", 0.5), p.num.getOrDefault("rx", 0.48), p.num.getOrDefault("ry", 0.3), 48);
                case "rounded_rect" -> ShapeTessellator.approxRoundedRect(p.num.getOrDefault("x", 0.1), p.num.getOrDefault("y", 0.1), p.num.getOrDefault("w", 0.8), p.num.getOrDefault("h", 0.8), p.num.getOrDefault("rx", 0.12), p.num.getOrDefault("ry", p.num.getOrDefault("rx", 0.12)), 12);
                case "star" -> ShapeTessellator.approxStar(p.num.getOrDefault("cx", 0.5), p.num.getOrDefault("cy", 0.5), (int)Math.round(p.num.getOrDefault("points", 5.0)), p.num.getOrDefault("innerR", 0.25), p.num.getOrDefault("outerR", 0.48), Math.toRadians(p.num.getOrDefault("rotation", -90.0)), 1);
                case "gear" -> ShapeTessellator.approxGear(p.num.getOrDefault("cx", 0.5), p.num.getOrDefault("cy", 0.5), (int)Math.round(p.num.getOrDefault("teeth", 10.0)), p.num.getOrDefault("innerR", 0.3), p.num.getOrDefault("outerR", 0.48));
                default -> ShapeTessellator.toPairs(p.points);
            })) == null || boundary.size() < 3 || (tris = ShapeTessellator.earClip(boundary)) == null || tris.length < 6) continue;
            return new Mesh(tris);
        }
        return null;
    }

    public static void drawMesh(class_332 g, Mesh mesh, int x, int y, int size, int argb) {
        if (mesh == null || mesh.triCount == 0) {
            return;
        }
        Matrix4f pose = g.method_51448().method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34540);
        class_287 buf = class_289.method_1348().method_1349();
        buf.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float gg = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        float[] v = mesh.verts;
        for (int i = 0; i < v.length; i += 6) {
            float x1 = (float)x + v[i] * (float)size;
            float y1 = (float)y + v[i + 1] * (float)size;
            float x2 = (float)x + v[i + 2] * (float)size;
            float y2 = (float)y + v[i + 3] * (float)size;
            float x3 = (float)x + v[i + 4] * (float)size;
            float y3 = (float)y + v[i + 5] * (float)size;
            buf.method_22918(pose, x1, y1, 0.0f).method_22915(r, gg, b, a).method_1344();
            buf.method_22918(pose, x2, y2, 0.0f).method_22915(r, gg, b, a).method_1344();
            buf.method_22918(pose, x3, y3, 0.0f).method_22915(r, gg, b, a).method_1344();
        }
        RenderSystem.disableCull();
        class_286.method_43433((class_287.class_7433)buf.method_1326());
    }

    private static List<double[]> toPairs(List<Double> flat) {
        if (flat == null) {
            return null;
        }
        ArrayList<double[]> out = new ArrayList<double[]>();
        int i = 0;
        while (i + 1 < flat.size()) {
            out.add(new double[]{flat.get(i), flat.get(i + 1)});
            i += 2;
        }
        return out;
    }

    private static List<double[]> approxCircle(double cx, double cy, double r, int seg) {
        ArrayList<double[]> pts = new ArrayList<double[]>(seg);
        for (int i = 0; i < seg; ++i) {
            double a = Math.toRadians((double)i / (double)seg * 360.0);
            pts.add(new double[]{cx + r * Math.cos(a), cy + r * Math.sin(a)});
        }
        return pts;
    }

    private static List<double[]> approxEllipse(double cx, double cy, double rx, double ry, int seg) {
        ArrayList<double[]> pts = new ArrayList<double[]>(seg);
        for (int i = 0; i < seg; ++i) {
            double a = Math.toRadians((double)i / (double)seg * 360.0);
            pts.add(new double[]{cx + rx * Math.cos(a), cy + ry * Math.sin(a)});
        }
        return pts;
    }

    private static List<double[]> approxRoundedRect(double x, double y, double w, double h, double rx, double ry, int cornerSeg) {
        double a;
        int i;
        ArrayList<double[]> pts = new ArrayList<double[]>();
        rx = Math.max(0.0, Math.min(rx, w / 2.0));
        ry = Math.max(0.0, Math.min(ry, h / 2.0));
        for (i = 0; i <= cornerSeg; ++i) {
            a = Math.toRadians(180.0 + (double)i * 90.0 / (double)cornerSeg);
            pts.add(new double[]{x + rx + rx * Math.cos(a), y + ry + ry * Math.sin(a)});
        }
        for (i = 0; i <= cornerSeg; ++i) {
            a = Math.toRadians(270.0 + (double)i * 90.0 / (double)cornerSeg);
            pts.add(new double[]{x + w - rx + rx * Math.cos(a), y + ry + ry * Math.sin(a)});
        }
        for (i = 0; i <= cornerSeg; ++i) {
            a = Math.toRadians((double)i * 90.0 / (double)cornerSeg);
            pts.add(new double[]{x + w - rx + rx * Math.cos(a), y + h - ry + ry * Math.sin(a)});
        }
        for (i = 0; i <= cornerSeg; ++i) {
            a = Math.toRadians(90.0 + (double)i * 90.0 / (double)cornerSeg);
            pts.add(new double[]{x + rx + rx * Math.cos(a), y + h - ry + ry * Math.sin(a)});
        }
        return pts;
    }

    private static List<double[]> approxStar(double cx, double cy, int points, double innerR, double outerR, double rot, int dummy) {
        ArrayList<double[]> pts = new ArrayList<double[]>(points * 2);
        double step = Math.PI / (double)points;
        for (int i = 0; i < points * 2; ++i) {
            double r = i % 2 == 0 ? outerR : innerR;
            double a = rot + (double)i * step;
            pts.add(new double[]{cx + r * Math.cos(a), cy + r * Math.sin(a)});
        }
        return pts;
    }

    private static List<double[]> approxGear(double cx, double cy, int teeth, double innerR, double outerR) {
        ArrayList<double[]> pts = new ArrayList<double[]>(teeth * 4);
        double period = Math.PI * 2 / (double)Math.max(3, teeth);
        for (int i = 0; i < teeth; ++i) {
            double base = (double)i * period;
            pts.add(new double[]{cx + innerR * Math.cos(base + period * 0.15), cy + innerR * Math.sin(base + period * 0.15)});
            pts.add(new double[]{cx + outerR * Math.cos(base + period * 0.4), cy + outerR * Math.sin(base + period * 0.4)});
            pts.add(new double[]{cx + innerR * Math.cos(base + period * 0.65), cy + innerR * Math.sin(base + period * 0.65)});
            pts.add(new double[]{cx + innerR * Math.cos(base + period * 0.9), cy + innerR * Math.sin(base + period * 0.9)});
        }
        return pts;
    }

    private static float[] earClip(List<double[]> poly) {
        int n = poly.size();
        if (n < 3) {
            return null;
        }
        ArrayList<double[]> vertices = new ArrayList<double[]>(poly);
        ArrayList<Float> tris = new ArrayList<Float>();
        int guard = 0;
        while (vertices.size() >= 3 && guard++ < 10000) {
            int m = vertices.size();
            boolean earFound = false;
            for (int i = 0; i < m; ++i) {
                double[] c;
                double[] b;
                int i0 = (i + m - 1) % m;
                int i1 = i;
                int i2 = (i + 1) % m;
                double[] a = (double[])vertices.get(i0);
                if (!ShapeTessellator.isConvex(a, b = (double[])vertices.get(i1), c = (double[])vertices.get(i2)) || ShapeTessellator.containsAny(vertices, i0, i1, i2, a, b, c)) continue;
                tris.add(Float.valueOf((float)a[0]));
                tris.add(Float.valueOf((float)a[1]));
                tris.add(Float.valueOf((float)b[0]));
                tris.add(Float.valueOf((float)b[1]));
                tris.add(Float.valueOf((float)c[0]));
                tris.add(Float.valueOf((float)c[1]));
                vertices.remove(i1);
                earFound = true;
                break;
            }
            if (earFound) continue;
            break;
        }
        float[] out = new float[tris.size()];
        for (int i = 0; i < tris.size(); ++i) {
            out[i] = ((Float)tris.get(i)).floatValue();
        }
        return out;
    }

    private static boolean isConvex(double[] a, double[] b, double[] c) {
        double cross = (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
        return cross < 0.0;
    }

    private static boolean containsAny(List<double[]> poly, int i0, int i1, int i2, double[] a, double[] b, double[] c) {
        for (int j = 0; j < poly.size(); ++j) {
            double[] p;
            if (j == i0 || j == i1 || j == i2 || !ShapeTessellator.pointInTriangle((p = poly.get(j))[0], p[1], a, b, c)) continue;
            return true;
        }
        return false;
    }

    private static boolean pointInTriangle(double px, double py, double[] a, double[] b, double[] c) {
        double v0x = c[0] - a[0];
        double v0y = c[1] - a[1];
        double v1x = b[0] - a[0];
        double v1y = b[1] - a[1];
        double v2x = px - a[0];
        double v2y = py - a[1];
        double dot00 = v0x * v0x + v0y * v0y;
        double dot01 = v0x * v1x + v0y * v1y;
        double dot02 = v0x * v2x + v0y * v2y;
        double dot11 = v1x * v1x + v1y * v1y;
        double dot12 = v1x * v2x + v1y * v2y;
        double invDen = 1.0 / Math.max(1.0E-9, dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDen;
        double v = (dot00 * dot12 - dot01 * dot02) * invDen;
        return u >= 0.0 && v >= 0.0 && u + v < 1.0;
    }

    public static class Mesh {
        public final float[] verts;
        public final int triCount;

        public Mesh(float[] verts) {
            this.verts = verts;
            this.triCount = verts.length / 6;
        }
    }
}

