/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.texboobcat.questory.telemetry.HardwareIdGenerator;
import org.texboobcat.questory.telemetry.SupabaseClient;
import org.texboobcat.questory.telemetry.TelemetryManager;

public class TelemetryCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"questify").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"telemetry").then(class_2170.method_9247((String)"status").executes(TelemetryCommand::status))).then(class_2170.method_9247((String)"optin").executes(TelemetryCommand::optIn))).then(class_2170.method_9247((String)"optout").executes(TelemetryCommand::optOut))).then(class_2170.method_9247((String)"export").executes(TelemetryCommand::export))).then(class_2170.method_9247((String)"delete").executes(TelemetryCommand::delete))));
    }

    private static int status(CommandContext<class_2168> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        boolean enabled = tm.isEnabled();
        String hwid = HardwareIdGenerator.getHardwareId();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76\u00a7l=== Questify Telemetry Status ==="), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77Status: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77Hardware ID: \u00a7e" + hwid)), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Note: This ID is machine-specific, not linked to your account."), false);
        if (enabled) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77Session ID: \u00a7f" + String.valueOf(tm.getSessionId()))), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77Session Duration: \u00a7f" + TelemetryCommand.formatDuration(tm.getSessionDuration()))), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77You can opt-out at any time with: \u00a7f/questory telemetry optout"), false);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Telemetry helps improve quest design for everyone."), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77All data is anonymous and stored in a central database."), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Opt-in with: \u00a7f/questory telemetry optin"), false);
        }
        return 1;
    }

    private static int optIn(CommandContext<class_2168> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        if (tm.isEnabled()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cTelemetry is already enabled!"));
            return 0;
        }
        tm.enableTelemetry();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Telemetry enabled!"), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Thank you for helping improve quest designs!"), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Your data is anonymous and helps everyone."), false);
        return 1;
    }

    private static int optOut(CommandContext<class_2168> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        if (!tm.isEnabled()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cTelemetry is already disabled!"));
            return 0;
        }
        tm.disableTelemetry();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Telemetry disabled."), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77No further data will be collected."), false);
        return 1;
    }

    private static int export(CommandContext<class_2168> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        String hwid = HardwareIdGenerator.getHardwareId();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a76\u00a7l=== GDPR Data Export ==="), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a77Your hardware ID: \u00a7f" + hwid)), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77To request a full data export, contact the mod author"), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77with this hardware ID. They can query the central database."), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)""), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Note: This ID is machine-specific, not linked to your account."), false);
        return 1;
    }

    private static int delete(CommandContext<class_2168> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7c\u00a7l=== GDPR Data Deletion ==="), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77This will permanently delete all data associated with your Hardware ID."), false);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77To confirm, please run this command again."), false);
        try {
            SupabaseClient.getInstance().deletePlayerData(HardwareIdGenerator.getHardwareId());
            tm.disableTelemetry();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2713 Data deleted successfully."), false);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77You have been opted out of telemetry."), false);
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cFailed to delete data: " + e.getMessage())), false);
        }
        return 1;
    }

    private static String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes % 60L);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds % 60L);
        }
        return String.format("%ds", seconds);
    }
}

